/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.ConnectionState;
import org.apache.kafka.clients.NodeConnectionState;

final class ClusterConnectionStates {
    private final long reconnectBackoffMs;
    private final Map<Integer, NodeConnectionState> nodeState;

    public ClusterConnectionStates(long reconnectBackoffMs) {
        this.reconnectBackoffMs = reconnectBackoffMs;
        this.nodeState = new HashMap<Integer, NodeConnectionState>();
    }

    public boolean canConnect(int node, long now) {
        NodeConnectionState state = this.nodeState.get(node);
        if (state == null) {
            return true;
        }
        return state.state == ConnectionState.DISCONNECTED && now - state.lastConnectAttemptMs >= this.reconnectBackoffMs;
    }

    public boolean isBlackedOut(int node, long now) {
        NodeConnectionState state = this.nodeState.get(node);
        if (state == null) {
            return false;
        }
        return state.state == ConnectionState.DISCONNECTED && now - state.lastConnectAttemptMs < this.reconnectBackoffMs;
    }

    public void connecting(int node, long now) {
        this.nodeState.put(node, new NodeConnectionState(ConnectionState.CONNECTING, now));
    }

    public boolean isConnected(int node) {
        NodeConnectionState state = this.nodeState.get(node);
        return state != null && state.state == ConnectionState.CONNECTED;
    }

    public boolean isConnecting(int node) {
        NodeConnectionState state = this.nodeState.get(node);
        return state != null && state.state == ConnectionState.CONNECTING;
    }

    public void connected(int node) {
        this.nodeState((int)node).state = ConnectionState.CONNECTED;
    }

    public void disconnected(int node) {
        this.nodeState((int)node).state = ConnectionState.DISCONNECTED;
    }

    private NodeConnectionState nodeState(int node) {
        NodeConnectionState state = this.nodeState.get(node);
        if (state == null) {
            throw new IllegalStateException("No entry found for node " + node);
        }
        return state;
    }
}

