/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import org.apache.kafka.common.utils.Java;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JavaTest {
    private String javaVendor;

    @Before
    public void before() {
        this.javaVendor = System.getProperty("java.vendor");
    }

    @After
    public void after() {
        System.setProperty("java.vendor", this.javaVendor);
    }

    @Test
    public void testIsIBMJdk() {
        System.setProperty("java.vendor", "Oracle Corporation");
        Assert.assertFalse((boolean)Java.isIBMJdk());
        System.setProperty("java.vendor", "IBM Corporation");
        Assert.assertTrue((boolean)Java.isIBMJdk());
    }

    @Test
    public void testLoadKerberosLoginModule() throws ClassNotFoundException {
        String clazz = Java.isIBMJdk() ? "com.ibm.security.auth.module.Krb5LoginModule" : "com.sun.security.auth.module.Krb5LoginModule";
        Class.forName(clazz);
    }
}

