/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer;

import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.DefaultRecord;
import org.junit.Assert;
import org.junit.Test;

public class RecordMetadataTest {
    @Test
    public void testConstructionWithMissingRelativeOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        long timestamp = 2340234L;
        int keySize = 3;
        int valueSize = 5;
        Long checksum = 908923L;
        RecordMetadata metadata = new RecordMetadata(tp, -1L, -1L, timestamp, checksum, keySize, valueSize);
        Assert.assertEquals((Object)tp.topic(), (Object)metadata.topic());
        Assert.assertEquals((long)tp.partition(), (long)metadata.partition());
        Assert.assertEquals((long)timestamp, (long)metadata.timestamp());
        Assert.assertEquals((long)-1L, (long)metadata.offset());
        Assert.assertEquals((long)checksum, (long)metadata.checksum());
        Assert.assertEquals((long)keySize, (long)metadata.serializedKeySize());
        Assert.assertEquals((long)valueSize, (long)metadata.serializedValueSize());
    }

    @Test
    public void testConstructionWithRelativeOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        long timestamp = 2340234L;
        int keySize = 3;
        int valueSize = 5;
        long baseOffset = 15L;
        long relativeOffset = 3L;
        Long checksum = 908923L;
        RecordMetadata metadata = new RecordMetadata(tp, baseOffset, relativeOffset, timestamp, checksum, keySize, valueSize);
        Assert.assertEquals((Object)tp.topic(), (Object)metadata.topic());
        Assert.assertEquals((long)tp.partition(), (long)metadata.partition());
        Assert.assertEquals((long)timestamp, (long)metadata.timestamp());
        Assert.assertEquals((long)(baseOffset + relativeOffset), (long)metadata.offset());
        Assert.assertEquals((long)checksum, (long)metadata.checksum());
        Assert.assertEquals((long)keySize, (long)metadata.serializedKeySize());
        Assert.assertEquals((long)valueSize, (long)metadata.serializedValueSize());
    }

    @Test
    public void testNullChecksum() {
        long timestamp = 2340234L;
        int keySize = 3;
        int valueSize = 5;
        RecordMetadata metadata = new RecordMetadata(new TopicPartition("foo", 0), 15L, 3L, timestamp, null, keySize, valueSize);
        Assert.assertEquals((long)DefaultRecord.computePartialChecksum((long)timestamp, (int)keySize, (int)valueSize), (long)metadata.checksum());
    }
}

