/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.io.IOException;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.utils.Serializer;
import org.junit.Assert;
import org.junit.Test;

public class SerializeCompatibilityOffsetAndMetadataTest {
    private String metadata = "test commit metadata";
    private String fileName = "serializedData/offsetAndMetadataSerializedfile";
    private long offset = 10L;

    private void checkValues(OffsetAndMetadata deSerOAM) {
        Assert.assertEquals((String)("Offset should be " + this.offset + " but got " + deSerOAM.offset()), (long)this.offset, (long)deSerOAM.offset());
        Assert.assertEquals((String)("metadata should be " + this.metadata + " but got " + deSerOAM.metadata()), (Object)this.metadata, (Object)deSerOAM.metadata());
    }

    @Test
    public void testSerializationRoundtrip() throws IOException, ClassNotFoundException {
        OffsetAndMetadata origOAM = new OffsetAndMetadata(this.offset, this.metadata);
        byte[] byteArray = Serializer.serialize(origOAM);
        Object deserializedObject = Serializer.deserialize(byteArray);
        Assert.assertTrue((boolean)(deserializedObject instanceof OffsetAndMetadata));
        this.checkValues((OffsetAndMetadata)deserializedObject);
    }

    @Test
    public void testOffsetMetadataSerializationCompatibility() throws IOException, ClassNotFoundException {
        Object deserializedObject = Serializer.deserialize(this.fileName);
        Assert.assertTrue((boolean)(deserializedObject instanceof OffsetAndMetadata));
        this.checkValues((OffsetAndMetadata)deserializedObject);
    }
}

