/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestCondition;
import org.apache.kafka.test.TestUtils;

public class MockClient
implements KafkaClient {
    public static final RequestMatcher ALWAYS_TRUE = new RequestMatcher(){

        @Override
        public boolean matches(AbstractRequest body) {
            return true;
        }
    };
    private final Time time;
    private final Metadata metadata;
    private Set<String> unavailableTopics;
    private Cluster cluster;
    private Node node = null;
    private final Set<String> ready = new HashSet<String>();
    private final Map<Node, Long> blackedOut = new HashMap<Node, Long>();
    private final Queue<ClientRequest> requests = new ConcurrentLinkedDeque<ClientRequest>();
    private final Queue<ClientResponse> responses = new ConcurrentLinkedDeque<ClientResponse>();
    private final Queue<FutureResponse> futureResponses = new ArrayDeque<FutureResponse>();
    private final Queue<MetadataUpdate> metadataUpdates = new ArrayDeque<MetadataUpdate>();
    private volatile NodeApiVersions nodeApiVersions = NodeApiVersions.create();

    public MockClient(Time time) {
        this(time, null);
    }

    public MockClient(Time time, Metadata metadata) {
        this.time = time;
        this.metadata = metadata;
        this.unavailableTopics = Collections.emptySet();
    }

    public boolean isReady(Node node, long now) {
        return this.ready.contains(node.idString());
    }

    public boolean ready(Node node, long now) {
        if (this.isBlackedOut(node)) {
            return false;
        }
        this.ready.add(node.idString());
        return true;
    }

    public long connectionDelay(Node node, long now) {
        return 0L;
    }

    public void blackout(Node node, long duration) {
        this.blackedOut.put(node, this.time.milliseconds() + duration);
    }

    private boolean isBlackedOut(Node node) {
        if (this.blackedOut.containsKey(node)) {
            long expiration = this.blackedOut.get(node);
            if (this.time.milliseconds() > expiration) {
                this.blackedOut.remove(node);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean connectionFailed(Node node) {
        return this.isBlackedOut(node);
    }

    public void disconnect(String node) {
        long now = this.time.milliseconds();
        Iterator iter = this.requests.iterator();
        while (iter.hasNext()) {
            ClientRequest request = (ClientRequest)iter.next();
            if (!request.destination().equals(node)) continue;
            short version = request.requestBuilder().desiredOrLatestVersion();
            this.responses.add(new ClientResponse(request.makeHeader(version), request.callback(), request.destination(), request.createdTimeMs(), now, true, null, null));
            iter.remove();
        }
        this.ready.remove(node);
    }

    public void send(ClientRequest request, long now) {
        Iterator iterator = this.futureResponses.iterator();
        while (iterator.hasNext()) {
            FutureResponse futureResp = (FutureResponse)iterator.next();
            if (futureResp.node != null && !request.destination().equals(futureResp.node.idString())) continue;
            AbstractRequest.Builder builder = request.requestBuilder();
            short version = this.nodeApiVersions.usableVersion(request.apiKey(), builder.desiredVersion());
            AbstractRequest abstractRequest = request.requestBuilder().build(version);
            if (!futureResp.requestMatcher.matches(abstractRequest)) {
                throw new IllegalStateException("Request matcher did not match next-in-line request " + abstractRequest);
            }
            ClientResponse resp = new ClientResponse(request.makeHeader(version), request.callback(), request.destination(), request.createdTimeMs(), this.time.milliseconds(), futureResp.disconnected, null, futureResp.responseBody);
            this.responses.add(resp);
            iterator.remove();
            return;
        }
        this.requests.add(request);
    }

    public List<ClientResponse> poll(long timeoutMs, long now) {
        ClientResponse response;
        ArrayList<ClientResponse> copy = new ArrayList<ClientResponse>(this.responses);
        if (this.metadata != null && this.metadata.updateRequested()) {
            MetadataUpdate metadataUpdate = this.metadataUpdates.poll();
            if (this.cluster != null) {
                this.metadata.update(this.cluster, this.unavailableTopics, this.time.milliseconds());
            }
            if (metadataUpdate == null) {
                this.metadata.update(this.metadata.fetch(), this.unavailableTopics, this.time.milliseconds());
            } else {
                this.unavailableTopics = metadataUpdate.unavailableTopics;
                this.metadata.update(metadataUpdate.cluster, metadataUpdate.unavailableTopics, this.time.milliseconds());
            }
        }
        while ((response = this.responses.poll()) != null) {
            response.onComplete();
        }
        return copy;
    }

    public Queue<ClientRequest> requests() {
        return this.requests;
    }

    public void respond(AbstractResponse response) {
        this.respond(response, false);
    }

    public void respond(RequestMatcher matcher, AbstractResponse response) {
        ClientRequest nextRequest = this.requests.peek();
        if (nextRequest == null) {
            throw new IllegalStateException("No current requests queued");
        }
        AbstractRequest request = nextRequest.requestBuilder().build();
        if (!matcher.matches(request)) {
            throw new IllegalStateException("Request matcher did not match next-in-line request " + request);
        }
        this.respond(response);
    }

    public void respond(AbstractResponse response, boolean disconnected) {
        ClientRequest request = this.requests.remove();
        short version = request.requestBuilder().desiredOrLatestVersion();
        this.responses.add(new ClientResponse(request.makeHeader(version), request.callback(), request.destination(), request.createdTimeMs(), this.time.milliseconds(), disconnected, null, response));
    }

    public void respondFrom(AbstractResponse response, Node node) {
        this.respondFrom(response, node, false);
    }

    public void respondFrom(AbstractResponse response, Node node, boolean disconnected) {
        Iterator iterator = this.requests.iterator();
        while (iterator.hasNext()) {
            ClientRequest request = (ClientRequest)iterator.next();
            if (!request.destination().equals(node.idString())) continue;
            iterator.remove();
            short version = request.requestBuilder().desiredOrLatestVersion();
            this.responses.add(new ClientResponse(request.makeHeader(version), request.callback(), request.destination(), request.createdTimeMs(), this.time.milliseconds(), disconnected, null, response));
            return;
        }
        throw new IllegalArgumentException("No requests available to node " + node);
    }

    public void prepareResponse(AbstractResponse response) {
        this.prepareResponse(ALWAYS_TRUE, response, false);
    }

    public void prepareResponseFrom(AbstractResponse response, Node node) {
        this.prepareResponseFrom(ALWAYS_TRUE, response, node, false);
    }

    public void prepareResponse(RequestMatcher matcher, AbstractResponse response) {
        this.prepareResponse(matcher, response, false);
    }

    public void prepareResponseFrom(RequestMatcher matcher, AbstractResponse response, Node node) {
        this.prepareResponseFrom(matcher, response, node, false);
    }

    public void prepareResponse(AbstractResponse response, boolean disconnected) {
        this.prepareResponse(ALWAYS_TRUE, response, disconnected);
    }

    public void prepareResponseFrom(AbstractResponse response, Node node, boolean disconnected) {
        this.prepareResponseFrom(ALWAYS_TRUE, response, node, disconnected);
    }

    public void prepareResponse(RequestMatcher matcher, AbstractResponse response, boolean disconnected) {
        this.prepareResponseFrom(matcher, response, null, disconnected);
    }

    public void prepareResponseFrom(RequestMatcher matcher, AbstractResponse response, Node node, boolean disconnected) {
        this.futureResponses.add(new FutureResponse(response, disconnected, matcher, node));
    }

    public void waitForRequests(final int minRequests, long maxWaitMs) throws InterruptedException {
        TestUtils.waitForCondition(new TestCondition(){

            @Override
            public boolean conditionMet() {
                return MockClient.this.requests.size() >= minRequests;
            }
        }, maxWaitMs, "Expected requests have not been sent");
    }

    public void reset() {
        this.ready.clear();
        this.blackedOut.clear();
        this.requests.clear();
        this.responses.clear();
        this.futureResponses.clear();
        this.metadataUpdates.clear();
    }

    public void prepareMetadataUpdate(Cluster cluster, Set<String> unavailableTopics) {
        this.metadataUpdates.add(new MetadataUpdate(cluster, unavailableTopics));
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public void cluster(Cluster cluster) {
        this.cluster = cluster;
    }

    public int inFlightRequestCount() {
        return this.requests.size();
    }

    public boolean hasInFlightRequests() {
        return !this.requests.isEmpty();
    }

    public int inFlightRequestCount(String node) {
        int result = 0;
        for (ClientRequest req : this.requests) {
            if (!req.destination().equals(node)) continue;
            ++result;
        }
        return result;
    }

    public boolean hasInFlightRequests(String node) {
        return this.inFlightRequestCount(node) > 0;
    }

    public boolean hasReadyNodes() {
        return !this.ready.isEmpty();
    }

    public ClientRequest newClientRequest(String nodeId, AbstractRequest.Builder<?> requestBuilder, long createdTimeMs, boolean expectResponse) {
        return this.newClientRequest(nodeId, requestBuilder, createdTimeMs, expectResponse, null);
    }

    public ClientRequest newClientRequest(String nodeId, AbstractRequest.Builder<?> requestBuilder, long createdTimeMs, boolean expectResponse, RequestCompletionHandler callback) {
        return new ClientRequest(nodeId, requestBuilder, 0, "mockClientId", createdTimeMs, expectResponse, callback);
    }

    public void wakeup() {
    }

    public void close() {
    }

    public void close(String node) {
        this.ready.remove(node);
    }

    public Node leastLoadedNode(long now) {
        return this.node;
    }

    public void setNodeApiVersions(NodeApiVersions nodeApiVersions) {
        this.nodeApiVersions = nodeApiVersions;
    }

    private static class MetadataUpdate {
        final Cluster cluster;
        final Set<String> unavailableTopics;

        MetadataUpdate(Cluster cluster, Set<String> unavailableTopics) {
            this.cluster = cluster;
            this.unavailableTopics = unavailableTopics;
        }
    }

    public static interface RequestMatcher {
        public boolean matches(AbstractRequest var1);
    }

    private static class FutureResponse {
        public final AbstractResponse responseBody;
        public final boolean disconnected;
        public final RequestMatcher requestMatcher;
        public Node node;

        public FutureResponse(AbstractResponse responseBody, boolean disconnected, RequestMatcher requestMatcher, Node node) {
            this.responseBody = responseBody;
            this.disconnected = disconnected;
            this.requestMatcher = requestMatcher;
            this.node = node;
        }
    }
}

