/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.NotCoordinatorForGroupException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.ControlledShutdownRequest;
import org.apache.kafka.common.requests.ControlledShutdownResponse;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.requests.DescribeGroupsRequest;
import org.apache.kafka.common.requests.DescribeGroupsResponse;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.GroupCoordinatorRequest;
import org.apache.kafka.common.requests.GroupCoordinatorResponse;
import org.apache.kafka.common.requests.HeartbeatRequest;
import org.apache.kafka.common.requests.HeartbeatResponse;
import org.apache.kafka.common.requests.JoinGroupRequest;
import org.apache.kafka.common.requests.JoinGroupResponse;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.LeaderAndIsrResponse;
import org.apache.kafka.common.requests.LeaveGroupRequest;
import org.apache.kafka.common.requests.LeaveGroupResponse;
import org.apache.kafka.common.requests.ListGroupsRequest;
import org.apache.kafka.common.requests.ListGroupsResponse;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.OffsetCommitRequest;
import org.apache.kafka.common.requests.OffsetCommitResponse;
import org.apache.kafka.common.requests.OffsetFetchRequest;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.requests.PartitionState;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.ResponseHeader;
import org.apache.kafka.common.requests.SaslHandshakeRequest;
import org.apache.kafka.common.requests.SaslHandshakeResponse;
import org.apache.kafka.common.requests.StopReplicaRequest;
import org.apache.kafka.common.requests.StopReplicaResponse;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.requests.UpdateMetadataResponse;
import org.junit.Assert;
import org.junit.Test;

public class RequestResponseTest {
    @Test
    public void testSerialization() throws Exception {
        this.checkSerialization((AbstractRequestResponse)this.createRequestHeader(), null);
        this.checkSerialization((AbstractRequestResponse)this.createResponseHeader(), null);
        this.checkSerialization((AbstractRequest)this.createGroupCoordinatorRequest());
        this.checkSerialization((AbstractRequestResponse)this.createGroupCoordinatorRequest().getErrorResponse((Throwable)new UnknownServerException()), null);
        this.checkSerialization((AbstractRequestResponse)this.createGroupCoordinatorResponse(), null);
        this.checkSerialization((AbstractRequest)this.createControlledShutdownRequest());
        this.checkSerialization((AbstractRequestResponse)this.createControlledShutdownResponse(), null);
        this.checkSerialization((AbstractRequestResponse)this.createControlledShutdownRequest().getErrorResponse((Throwable)new UnknownServerException()), null);
        this.checkSerialization((AbstractRequestResponse)this.createFetchRequest(3), 3);
        this.checkSerialization((AbstractRequestResponse)this.createFetchRequest(3).getErrorResponse((Throwable)new UnknownServerException()), 3);
        this.checkSerialization((AbstractRequestResponse)this.createFetchResponse(), null);
        this.checkSerialization((AbstractRequest)this.createHeartBeatRequest());
        this.checkSerialization((AbstractRequestResponse)this.createHeartBeatRequest().getErrorResponse((Throwable)new UnknownServerException()), null);
        this.checkSerialization((AbstractRequestResponse)this.createHeartBeatResponse(), null);
        this.checkSerialization((AbstractRequestResponse)this.createJoinGroupRequest(1), 1);
        this.checkSerialization((AbstractRequestResponse)this.createJoinGroupRequest(0).getErrorResponse((Throwable)new UnknownServerException()), 0);
        this.checkSerialization((AbstractRequestResponse)this.createJoinGroupRequest(1).getErrorResponse((Throwable)new UnknownServerException()), 1);
        this.checkSerialization((AbstractRequestResponse)this.createJoinGroupResponse(), null);
        this.checkSerialization((AbstractRequest)this.createLeaveGroupRequest());
        this.checkSerialization((AbstractRequestResponse)this.createLeaveGroupRequest().getErrorResponse((Throwable)new UnknownServerException()), null);
        this.checkSerialization((AbstractRequestResponse)this.createLeaveGroupResponse(), null);
        this.checkSerialization((AbstractRequest)this.createListGroupsRequest());
        this.checkSerialization((AbstractRequestResponse)this.createListGroupsRequest().getErrorResponse((Throwable)new UnknownServerException()), null);
        this.checkSerialization((AbstractRequestResponse)this.createListGroupsResponse(), null);
        this.checkSerialization((AbstractRequest)this.createDescribeGroupRequest());
        this.checkSerialization((AbstractRequestResponse)this.createDescribeGroupRequest().getErrorResponse((Throwable)new UnknownServerException()), null);
        this.checkSerialization((AbstractRequestResponse)this.createDescribeGroupResponse(), null);
        this.checkSerialization((AbstractRequestResponse)this.createListOffsetRequest(1), 1);
        this.checkSerialization((AbstractRequestResponse)this.createListOffsetRequest(1).getErrorResponse((Throwable)new UnknownServerException()), 1);
        this.checkSerialization((AbstractRequestResponse)this.createListOffsetResponse(1), 1);
        this.checkSerialization((AbstractRequestResponse)MetadataRequest.allTopics((short)2), 2);
        this.checkSerialization((AbstractRequestResponse)this.createMetadataRequest(1, Arrays.asList("topic1")), 1);
        this.checkSerialization((AbstractRequestResponse)this.createMetadataRequest(1, Arrays.asList("topic1")).getErrorResponse((Throwable)new UnknownServerException()), 1);
        this.checkSerialization((AbstractRequestResponse)this.createMetadataResponse(2), 2);
        this.checkSerialization((AbstractRequestResponse)this.createMetadataRequest(2, Arrays.asList("topic1")).getErrorResponse((Throwable)new UnknownServerException()), 2);
        this.checkSerialization((AbstractRequestResponse)this.createOffsetCommitRequest(2), 2);
        this.checkSerialization((AbstractRequestResponse)this.createOffsetCommitRequest(2).getErrorResponse((Throwable)new UnknownServerException()), 2);
        this.checkSerialization((AbstractRequestResponse)this.createOffsetCommitResponse(), null);
        this.checkSerialization((AbstractRequest)OffsetFetchRequest.forAllPartitions((String)"group1"));
        this.checkSerialization((AbstractRequestResponse)OffsetFetchRequest.forAllPartitions((String)"group1").getErrorResponse((Throwable)new NotCoordinatorForGroupException()), 2);
        this.checkSerialization((AbstractRequest)this.createOffsetFetchRequest(0));
        this.checkSerialization((AbstractRequest)this.createOffsetFetchRequest(1));
        this.checkSerialization((AbstractRequest)this.createOffsetFetchRequest(2));
        this.checkSerialization((AbstractRequest)OffsetFetchRequest.forAllPartitions((String)"group1"));
        this.checkSerialization((AbstractRequestResponse)this.createOffsetFetchRequest(0).getErrorResponse((Throwable)new UnknownServerException()), 0);
        this.checkSerialization((AbstractRequestResponse)this.createOffsetFetchRequest(1).getErrorResponse((Throwable)new UnknownServerException()), 1);
        this.checkSerialization((AbstractRequestResponse)this.createOffsetFetchRequest(2).getErrorResponse((Throwable)new UnknownServerException()), 2);
        this.checkSerialization((AbstractRequestResponse)this.createOffsetFetchResponse(), null);
        this.checkSerialization((AbstractRequest)this.createProduceRequest());
        this.checkSerialization((AbstractRequestResponse)this.createProduceRequest().getErrorResponse((Throwable)new UnknownServerException()), null);
        this.checkSerialization((AbstractRequestResponse)this.createProduceResponse(), null);
        this.checkSerialization((AbstractRequest)this.createStopReplicaRequest(true));
        this.checkSerialization((AbstractRequest)this.createStopReplicaRequest(false));
        this.checkSerialization((AbstractRequestResponse)this.createStopReplicaRequest(true).getErrorResponse((Throwable)new UnknownServerException()), null);
        this.checkSerialization((AbstractRequestResponse)this.createStopReplicaResponse(), null);
        this.checkSerialization((AbstractRequest)this.createLeaderAndIsrRequest());
        this.checkSerialization((AbstractRequestResponse)this.createLeaderAndIsrRequest().getErrorResponse((Throwable)new UnknownServerException()), null);
        this.checkSerialization((AbstractRequestResponse)this.createLeaderAndIsrResponse(), null);
        this.checkSerialization((AbstractRequest)this.createSaslHandshakeRequest());
        this.checkSerialization((AbstractRequestResponse)this.createSaslHandshakeRequest().getErrorResponse((Throwable)new UnknownServerException()), null);
        this.checkSerialization((AbstractRequestResponse)this.createSaslHandshakeResponse(), null);
        this.checkSerialization((AbstractRequest)this.createApiVersionRequest());
        this.checkSerialization((AbstractRequestResponse)this.createApiVersionRequest().getErrorResponse((Throwable)new UnknownServerException()), null);
        this.checkSerialization((AbstractRequestResponse)this.createApiVersionResponse(), null);
        this.checkSerialization((AbstractRequestResponse)this.createCreateTopicRequest(0), 0);
        this.checkSerialization((AbstractRequestResponse)this.createCreateTopicRequest(0).getErrorResponse((Throwable)new UnknownServerException()), 0);
        this.checkSerialization((AbstractRequestResponse)this.createCreateTopicResponse(0), 0);
        this.checkSerialization((AbstractRequestResponse)this.createCreateTopicRequest(1), 1);
        this.checkSerialization((AbstractRequestResponse)this.createCreateTopicRequest(1).getErrorResponse((Throwable)new UnknownServerException()), 1);
        this.checkSerialization((AbstractRequestResponse)this.createCreateTopicResponse(1), 1);
        this.checkSerialization((AbstractRequest)this.createDeleteTopicsRequest());
        this.checkSerialization((AbstractRequestResponse)this.createDeleteTopicsRequest().getErrorResponse((Throwable)new UnknownServerException()), null);
        this.checkSerialization((AbstractRequestResponse)this.createDeleteTopicsResponse(), null);
        this.checkOlderFetchVersions();
        this.checkSerialization((AbstractRequestResponse)this.createMetadataResponse(0), 0);
        this.checkSerialization((AbstractRequestResponse)this.createMetadataResponse(1), 1);
        this.checkSerialization((AbstractRequestResponse)this.createMetadataRequest(1, Arrays.asList("topic1")).getErrorResponse((Throwable)new UnknownServerException()), 1);
        this.checkSerialization((AbstractRequestResponse)this.createOffsetCommitRequest(0), 0);
        this.checkSerialization((AbstractRequestResponse)this.createOffsetCommitRequest(0).getErrorResponse((Throwable)new UnknownServerException()), 0);
        this.checkSerialization((AbstractRequestResponse)this.createOffsetCommitRequest(1), 1);
        this.checkSerialization((AbstractRequestResponse)this.createOffsetCommitRequest(1).getErrorResponse((Throwable)new UnknownServerException()), 1);
        this.checkSerialization((AbstractRequestResponse)this.createJoinGroupRequest(0), 0);
        this.checkSerialization((AbstractRequestResponse)this.createUpdateMetadataRequest(0, null), 0);
        this.checkSerialization((AbstractRequestResponse)this.createUpdateMetadataRequest(0, null).getErrorResponse((Throwable)new UnknownServerException()), 0);
        this.checkSerialization((AbstractRequestResponse)this.createUpdateMetadataRequest(1, null), 1);
        this.checkSerialization((AbstractRequestResponse)this.createUpdateMetadataRequest(1, "rack1"), 1);
        this.checkSerialization((AbstractRequestResponse)this.createUpdateMetadataRequest(1, null).getErrorResponse((Throwable)new UnknownServerException()), 1);
        this.checkSerialization((AbstractRequestResponse)this.createUpdateMetadataRequest(2, "rack1"), 2);
        this.checkSerialization((AbstractRequestResponse)this.createUpdateMetadataRequest(2, null), 2);
        this.checkSerialization((AbstractRequestResponse)this.createUpdateMetadataRequest(2, "rack1").getErrorResponse((Throwable)new UnknownServerException()), 2);
        this.checkSerialization((AbstractRequest)this.createUpdateMetadataRequest(3, "rack1"));
        this.checkSerialization((AbstractRequest)this.createUpdateMetadataRequest(3, null));
        this.checkSerialization((AbstractRequestResponse)this.createUpdateMetadataRequest(3, "rack1").getErrorResponse((Throwable)new UnknownServerException()), 3);
        this.checkSerialization((AbstractRequestResponse)this.createUpdateMetadataResponse(), null);
        this.checkSerialization((AbstractRequestResponse)this.createListOffsetRequest(0), 0);
        this.checkSerialization((AbstractRequestResponse)this.createListOffsetRequest(0).getErrorResponse((Throwable)new UnknownServerException()), 0);
        this.checkSerialization((AbstractRequestResponse)this.createListOffsetResponse(0), 0);
    }

    private void checkOlderFetchVersions() throws Exception {
        int latestVersion = ProtoUtils.latestVersion((int)ApiKeys.FETCH.id);
        for (int i = 0; i < latestVersion; ++i) {
            this.checkSerialization((AbstractRequestResponse)this.createFetchRequest(i).getErrorResponse((Throwable)new UnknownServerException()), i);
            this.checkSerialization((AbstractRequestResponse)this.createFetchRequest(i), i);
        }
    }

    private void checkSerialization(AbstractRequest req) throws Exception {
        this.checkSerialization((AbstractRequestResponse)req, Integer.valueOf(req.version()));
    }

    private void checkSerialization(AbstractRequestResponse req, Integer version) throws Exception {
        AbstractRequestResponse deserialized;
        ByteBuffer buffer = ByteBuffer.allocate(req.sizeOf());
        req.writeTo(buffer);
        buffer.rewind();
        if (version == null) {
            Method deserializer = req.getClass().getDeclaredMethod("parse", ByteBuffer.class);
            deserialized = (AbstractRequestResponse)deserializer.invoke(null, buffer);
        } else {
            Method deserializer = req.getClass().getDeclaredMethod("parse", ByteBuffer.class, Integer.TYPE);
            deserialized = (AbstractRequestResponse)deserializer.invoke(null, buffer, version);
        }
        Assert.assertEquals((String)("The original and deserialized of " + req.getClass().getSimpleName() + "(version " + version + ") should be the same."), (Object)req, (Object)deserialized);
        Assert.assertEquals((String)("The original and deserialized of " + req.getClass().getSimpleName() + " should have the same hashcode."), (long)req.hashCode(), (long)deserialized.hashCode());
    }

    @Test
    public void produceResponseVersionTest() {
        HashMap<TopicPartition, ProduceResponse.PartitionResponse> responseData = new HashMap<TopicPartition, ProduceResponse.PartitionResponse>();
        responseData.put(new TopicPartition("test", 0), new ProduceResponse.PartitionResponse(Errors.NONE, 10000L, -1L));
        ProduceResponse v0Response = new ProduceResponse(responseData);
        ProduceResponse v1Response = new ProduceResponse(responseData, 10, 1);
        ProduceResponse v2Response = new ProduceResponse(responseData, 10, 2);
        Assert.assertEquals((String)"Throttle time must be zero", (long)0L, (long)v0Response.getThrottleTime());
        Assert.assertEquals((String)"Throttle time must be 10", (long)10L, (long)v1Response.getThrottleTime());
        Assert.assertEquals((String)"Throttle time must be 10", (long)10L, (long)v2Response.getThrottleTime());
        Assert.assertEquals((String)"Should use schema version 0", (Object)ProtoUtils.responseSchema((int)ApiKeys.PRODUCE.id, (int)0), (Object)v0Response.toStruct().schema());
        Assert.assertEquals((String)"Should use schema version 1", (Object)ProtoUtils.responseSchema((int)ApiKeys.PRODUCE.id, (int)1), (Object)v1Response.toStruct().schema());
        Assert.assertEquals((String)"Should use schema version 2", (Object)ProtoUtils.responseSchema((int)ApiKeys.PRODUCE.id, (int)2), (Object)v2Response.toStruct().schema());
        Assert.assertEquals((String)"Response data does not match", responseData, (Object)v0Response.responses());
        Assert.assertEquals((String)"Response data does not match", responseData, (Object)v1Response.responses());
        Assert.assertEquals((String)"Response data does not match", responseData, (Object)v2Response.responses());
    }

    @Test
    public void fetchResponseVersionTest() {
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> responseData = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)ByteBuffer.allocate(10));
        responseData.put(new TopicPartition("test", 0), new FetchResponse.PartitionData(Errors.NONE.code(), 1000000L, (Records)records));
        FetchResponse v0Response = new FetchResponse(0, responseData, 0);
        FetchResponse v1Response = new FetchResponse(1, responseData, 10);
        Assert.assertEquals((String)"Throttle time must be zero", (long)0L, (long)v0Response.getThrottleTime());
        Assert.assertEquals((String)"Throttle time must be 10", (long)10L, (long)v1Response.getThrottleTime());
        Assert.assertEquals((String)"Should use schema version 0", (Object)ProtoUtils.responseSchema((int)ApiKeys.FETCH.id, (int)0), (Object)v0Response.toStruct().schema());
        Assert.assertEquals((String)"Should use schema version 1", (Object)ProtoUtils.responseSchema((int)ApiKeys.FETCH.id, (int)1), (Object)v1Response.toStruct().schema());
        Assert.assertEquals((String)"Response data does not match", responseData, (Object)v0Response.responseData());
        Assert.assertEquals((String)"Response data does not match", responseData, (Object)v1Response.responseData());
    }

    @Test
    public void verifyFetchResponseFullWrite() throws Exception {
        FetchResponse fetchResponse = this.createFetchResponse();
        RequestHeader header = new RequestHeader(ApiKeys.FETCH.id, ProtoUtils.latestVersion((int)ApiKeys.FETCH.id), "client", 15);
        Send send = fetchResponse.toSend("1", header);
        ByteBufferChannel channel = new ByteBufferChannel(send.size());
        send.writeTo((GatheringByteChannel)channel);
        channel.close();
        ByteBuffer buf = channel.buf;
        int size = buf.getInt();
        Assert.assertTrue((size > 0 ? 1 : 0) != 0);
        ResponseHeader responseHeader = ResponseHeader.parse((ByteBuffer)channel.buf);
        Assert.assertEquals((long)header.correlationId(), (long)responseHeader.correlationId());
        Struct responseBody = ProtoUtils.responseSchema((int)ApiKeys.FETCH.id, (int)header.apiVersion()).read(buf);
        FetchResponse parsedResponse = new FetchResponse(responseBody);
        Assert.assertEquals((Object)parsedResponse, (Object)fetchResponse);
        Assert.assertEquals((long)size, (long)(responseHeader.sizeOf() + parsedResponse.sizeOf()));
    }

    @Test
    public void testControlledShutdownResponse() {
        ControlledShutdownResponse response = this.createControlledShutdownResponse();
        ByteBuffer buffer = ByteBuffer.allocate(response.sizeOf());
        response.writeTo(buffer);
        buffer.rewind();
        ControlledShutdownResponse deserialized = ControlledShutdownResponse.parse((ByteBuffer)buffer);
        Assert.assertEquals((long)response.errorCode(), (long)deserialized.errorCode());
        Assert.assertEquals((Object)response.partitionsRemaining(), (Object)deserialized.partitionsRemaining());
    }

    @Test
    public void testRequestHeaderWithNullClientId() {
        RequestHeader header = new RequestHeader(10, 1, null, 10);
        ByteBuffer buffer = ByteBuffer.allocate(header.sizeOf());
        header.writeTo(buffer);
        buffer.rewind();
        RequestHeader deserialized = RequestHeader.parse((ByteBuffer)buffer);
        Assert.assertEquals((long)header.apiKey(), (long)deserialized.apiKey());
        Assert.assertEquals((long)header.apiVersion(), (long)deserialized.apiVersion());
        Assert.assertEquals((long)header.correlationId(), (long)deserialized.correlationId());
        Assert.assertEquals((Object)"", (Object)deserialized.clientId());
    }

    @Test(expected=UnsupportedVersionException.class)
    public void testCreateTopicRequestV0FailsIfValidateOnly() {
        this.createCreateTopicRequest(0, true);
    }

    private RequestHeader createRequestHeader() {
        return new RequestHeader(10, 1, "", 10);
    }

    private ResponseHeader createResponseHeader() {
        return new ResponseHeader(10);
    }

    private GroupCoordinatorRequest createGroupCoordinatorRequest() {
        return new GroupCoordinatorRequest.Builder("test-group").build();
    }

    private GroupCoordinatorResponse createGroupCoordinatorResponse() {
        return new GroupCoordinatorResponse(Errors.NONE.code(), new Node(10, "host1", 2014));
    }

    private FetchRequest createFetchRequest(int version) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> fetchData = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        fetchData.put(new TopicPartition("test1", 0), new FetchRequest.PartitionData(100L, 1000000));
        fetchData.put(new TopicPartition("test2", 0), new FetchRequest.PartitionData(200L, 1000000));
        return (FetchRequest)new FetchRequest.Builder(100, 100000, fetchData).setMaxBytes(1000).setVersion((short)version).build();
    }

    private FetchResponse createFetchResponse() {
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> responseData = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)ByteBuffer.allocate(10));
        responseData.put(new TopicPartition("test", 0), new FetchResponse.PartitionData(Errors.NONE.code(), 1000000L, (Records)records));
        return new FetchResponse(responseData, 25);
    }

    private HeartbeatRequest createHeartBeatRequest() {
        return new HeartbeatRequest.Builder("group1", 1, "consumer1").build();
    }

    private HeartbeatResponse createHeartBeatResponse() {
        return new HeartbeatResponse(Errors.NONE.code());
    }

    private JoinGroupRequest createJoinGroupRequest(int version) {
        ByteBuffer metadata = ByteBuffer.wrap(new byte[0]);
        ArrayList<JoinGroupRequest.ProtocolMetadata> protocols = new ArrayList<JoinGroupRequest.ProtocolMetadata>();
        protocols.add(new JoinGroupRequest.ProtocolMetadata("consumer-range", metadata));
        if (version == 0) {
            return (JoinGroupRequest)new JoinGroupRequest.Builder("group1", 30000, "consumer1", "consumer", protocols).setVersion((short)version).build();
        }
        return new JoinGroupRequest.Builder("group1", 10000, "consumer1", "consumer", protocols).setRebalanceTimeout(60000).build();
    }

    private JoinGroupResponse createJoinGroupResponse() {
        HashMap<String, ByteBuffer> members = new HashMap<String, ByteBuffer>();
        members.put("consumer1", ByteBuffer.wrap(new byte[0]));
        members.put("consumer2", ByteBuffer.wrap(new byte[0]));
        return new JoinGroupResponse(Errors.NONE.code(), 1, "range", "consumer1", "leader", members);
    }

    private ListGroupsRequest createListGroupsRequest() {
        return new ListGroupsRequest.Builder().build();
    }

    private ListGroupsResponse createListGroupsResponse() {
        List<ListGroupsResponse.Group> groups = Arrays.asList(new ListGroupsResponse.Group("test-group", "consumer"));
        return new ListGroupsResponse(Errors.NONE.code(), groups);
    }

    private DescribeGroupsRequest createDescribeGroupRequest() {
        return new DescribeGroupsRequest.Builder(Collections.singletonList("test-group")).build();
    }

    private DescribeGroupsResponse createDescribeGroupResponse() {
        String clientId = "consumer-1";
        String clientHost = "localhost";
        ByteBuffer empty = ByteBuffer.allocate(0);
        DescribeGroupsResponse.GroupMember member = new DescribeGroupsResponse.GroupMember("memberId", clientId, clientHost, empty, empty);
        DescribeGroupsResponse.GroupMetadata metadata = new DescribeGroupsResponse.GroupMetadata(Errors.NONE.code(), "STABLE", "consumer", "roundrobin", Arrays.asList(member));
        return new DescribeGroupsResponse(Collections.singletonMap("test-group", metadata));
    }

    private LeaveGroupRequest createLeaveGroupRequest() {
        return new LeaveGroupRequest.Builder("group1", "consumer1").build();
    }

    private LeaveGroupResponse createLeaveGroupResponse() {
        return new LeaveGroupResponse(Errors.NONE.code());
    }

    private ListOffsetRequest createListOffsetRequest(int version) {
        if (version == 0) {
            Map<TopicPartition, ListOffsetRequest.PartitionData> offsetData = Collections.singletonMap(new TopicPartition("test", 0), new ListOffsetRequest.PartitionData(1000000L, 10));
            return (ListOffsetRequest)new ListOffsetRequest.Builder().setOffsetData(offsetData).setVersion((short)version).build();
        }
        if (version == 1) {
            Map<TopicPartition, Long> offsetData = Collections.singletonMap(new TopicPartition("test", 0), 1000000L);
            return (ListOffsetRequest)new ListOffsetRequest.Builder().setTargetTimes(offsetData).setVersion((short)version).build();
        }
        throw new IllegalArgumentException("Illegal ListOffsetRequest version " + version);
    }

    private ListOffsetResponse createListOffsetResponse(int version) {
        if (version == 0) {
            HashMap<TopicPartition, ListOffsetResponse.PartitionData> responseData = new HashMap<TopicPartition, ListOffsetResponse.PartitionData>();
            responseData.put(new TopicPartition("test", 0), new ListOffsetResponse.PartitionData(Errors.NONE.code(), Arrays.asList(100L)));
            return new ListOffsetResponse(responseData);
        }
        if (version == 1) {
            HashMap<TopicPartition, ListOffsetResponse.PartitionData> responseData = new HashMap<TopicPartition, ListOffsetResponse.PartitionData>();
            responseData.put(new TopicPartition("test", 0), new ListOffsetResponse.PartitionData(Errors.NONE.code(), 10000L, 100L));
            return new ListOffsetResponse(responseData, 1);
        }
        throw new IllegalArgumentException("Illegal ListOffsetResponse version " + version);
    }

    private MetadataRequest createMetadataRequest(int version, List<String> topics) {
        return (MetadataRequest)new MetadataRequest.Builder(topics).setVersion((short)version).build();
    }

    private MetadataResponse createMetadataResponse(int version) {
        Node node = new Node(1, "host1", 1001);
        List<Node> replicas = Arrays.asList(node);
        List<Node> isr = Arrays.asList(node);
        ArrayList<MetadataResponse.TopicMetadata> allTopicMetadata = new ArrayList<MetadataResponse.TopicMetadata>();
        allTopicMetadata.add(new MetadataResponse.TopicMetadata(Errors.NONE, "__consumer_offsets", true, Arrays.asList(new MetadataResponse.PartitionMetadata(Errors.NONE, 1, node, replicas, isr))));
        allTopicMetadata.add(new MetadataResponse.TopicMetadata(Errors.LEADER_NOT_AVAILABLE, "topic2", false, Collections.emptyList()));
        return new MetadataResponse(Arrays.asList(node), null, -1, allTopicMetadata, version);
    }

    private OffsetCommitRequest createOffsetCommitRequest(int version) {
        HashMap<TopicPartition, OffsetCommitRequest.PartitionData> commitData = new HashMap<TopicPartition, OffsetCommitRequest.PartitionData>();
        commitData.put(new TopicPartition("test", 0), new OffsetCommitRequest.PartitionData(100L, ""));
        commitData.put(new TopicPartition("test", 1), new OffsetCommitRequest.PartitionData(200L, null));
        return (OffsetCommitRequest)new OffsetCommitRequest.Builder("group1", commitData).setGenerationId(100).setMemberId("consumer1").setRetentionTime(1000000L).setVersion((short)version).build();
    }

    private OffsetCommitResponse createOffsetCommitResponse() {
        HashMap<TopicPartition, Short> responseData = new HashMap<TopicPartition, Short>();
        responseData.put(new TopicPartition("test", 0), Errors.NONE.code());
        return new OffsetCommitResponse(responseData);
    }

    private OffsetFetchRequest createOffsetFetchRequest(int version) {
        return (OffsetFetchRequest)new OffsetFetchRequest.Builder("group1", Collections.singletonList(new TopicPartition("test11", 1))).setVersion((short)version).build();
    }

    private OffsetFetchResponse createOffsetFetchResponse() {
        HashMap<TopicPartition, OffsetFetchResponse.PartitionData> responseData = new HashMap<TopicPartition, OffsetFetchResponse.PartitionData>();
        responseData.put(new TopicPartition("test", 0), new OffsetFetchResponse.PartitionData(100L, "", Errors.NONE));
        responseData.put(new TopicPartition("test", 1), new OffsetFetchResponse.PartitionData(100L, null, Errors.NONE));
        return new OffsetFetchResponse(Errors.NONE, responseData);
    }

    private ProduceRequest createProduceRequest() {
        HashMap<TopicPartition, MemoryRecords> produceData = new HashMap<TopicPartition, MemoryRecords>();
        produceData.put(new TopicPartition("test", 0), MemoryRecords.readableRecords((ByteBuffer)ByteBuffer.allocate(10)));
        return new ProduceRequest.Builder(1, 5000, produceData).build();
    }

    private ProduceResponse createProduceResponse() {
        HashMap<TopicPartition, ProduceResponse.PartitionResponse> responseData = new HashMap<TopicPartition, ProduceResponse.PartitionResponse>();
        responseData.put(new TopicPartition("test", 0), new ProduceResponse.PartitionResponse(Errors.NONE, 10000L, -1L));
        return new ProduceResponse(responseData, 0);
    }

    private StopReplicaRequest createStopReplicaRequest(boolean deletePartitions) {
        HashSet<TopicPartition> partitions = new HashSet<TopicPartition>(Arrays.asList(new TopicPartition("test", 0)));
        return new StopReplicaRequest.Builder(0, 1, deletePartitions, partitions).build();
    }

    private StopReplicaResponse createStopReplicaResponse() {
        HashMap<TopicPartition, Short> responses = new HashMap<TopicPartition, Short>();
        responses.put(new TopicPartition("test", 0), Errors.NONE.code());
        return new StopReplicaResponse(Errors.NONE.code(), responses);
    }

    private ControlledShutdownRequest createControlledShutdownRequest() {
        return new ControlledShutdownRequest.Builder(10).build();
    }

    private ControlledShutdownResponse createControlledShutdownResponse() {
        HashSet<TopicPartition> topicPartitions = new HashSet<TopicPartition>(Arrays.asList(new TopicPartition("test2", 5), new TopicPartition("test1", 10)));
        return new ControlledShutdownResponse(Errors.NONE.code(), topicPartitions);
    }

    private LeaderAndIsrRequest createLeaderAndIsrRequest() {
        HashMap<TopicPartition, PartitionState> partitionStates = new HashMap<TopicPartition, PartitionState>();
        List<Integer> isr = Arrays.asList(1, 2);
        List<Integer> replicas = Arrays.asList(1, 2, 3, 4);
        partitionStates.put(new TopicPartition("topic5", 105), new PartitionState(0, 2, 1, new ArrayList<Integer>(isr), 2, new HashSet<Integer>(replicas)));
        partitionStates.put(new TopicPartition("topic5", 1), new PartitionState(1, 1, 1, new ArrayList<Integer>(isr), 2, new HashSet<Integer>(replicas)));
        partitionStates.put(new TopicPartition("topic20", 1), new PartitionState(1, 0, 1, new ArrayList<Integer>(isr), 2, new HashSet<Integer>(replicas)));
        HashSet<Node> leaders = new HashSet<Node>(Arrays.asList(new Node(0, "test0", 1223), new Node(1, "test1", 1223)));
        return new LeaderAndIsrRequest.Builder(1, 10, partitionStates, leaders).build();
    }

    private LeaderAndIsrResponse createLeaderAndIsrResponse() {
        HashMap<TopicPartition, Short> responses = new HashMap<TopicPartition, Short>();
        responses.put(new TopicPartition("test", 0), Errors.NONE.code());
        return new LeaderAndIsrResponse(Errors.NONE.code(), responses);
    }

    private UpdateMetadataRequest createUpdateMetadataRequest(int version, String rack) {
        HashMap<TopicPartition, PartitionState> partitionStates = new HashMap<TopicPartition, PartitionState>();
        List<Integer> isr = Arrays.asList(1, 2);
        List<Integer> replicas = Arrays.asList(1, 2, 3, 4);
        partitionStates.put(new TopicPartition("topic5", 105), new PartitionState(0, 2, 1, new ArrayList<Integer>(isr), 2, new HashSet<Integer>(replicas)));
        partitionStates.put(new TopicPartition("topic5", 1), new PartitionState(1, 1, 1, new ArrayList<Integer>(isr), 2, new HashSet<Integer>(replicas)));
        partitionStates.put(new TopicPartition("topic20", 1), new PartitionState(1, 0, 1, new ArrayList<Integer>(isr), 2, new HashSet<Integer>(replicas)));
        SecurityProtocol plaintext = SecurityProtocol.PLAINTEXT;
        ArrayList<UpdateMetadataRequest.EndPoint> endPoints1 = new ArrayList<UpdateMetadataRequest.EndPoint>();
        endPoints1.add(new UpdateMetadataRequest.EndPoint("host1", 1223, plaintext, ListenerName.forSecurityProtocol((SecurityProtocol)plaintext)));
        ArrayList<UpdateMetadataRequest.EndPoint> endPoints2 = new ArrayList<UpdateMetadataRequest.EndPoint>();
        endPoints2.add(new UpdateMetadataRequest.EndPoint("host1", 1244, plaintext, ListenerName.forSecurityProtocol((SecurityProtocol)plaintext)));
        if (version > 0) {
            SecurityProtocol ssl = SecurityProtocol.SSL;
            endPoints2.add(new UpdateMetadataRequest.EndPoint("host2", 1234, ssl, ListenerName.forSecurityProtocol((SecurityProtocol)ssl)));
            endPoints2.add(new UpdateMetadataRequest.EndPoint("host2", 1334, ssl, new ListenerName("CLIENT")));
        }
        HashSet<UpdateMetadataRequest.Broker> liveBrokers = new HashSet<UpdateMetadataRequest.Broker>(Arrays.asList(new UpdateMetadataRequest.Broker(0, endPoints1, rack), new UpdateMetadataRequest.Broker(1, endPoints2, rack)));
        return (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(1, 10, partitionStates, liveBrokers).setVersion((short)version).build();
    }

    private UpdateMetadataResponse createUpdateMetadataResponse() {
        return new UpdateMetadataResponse(Errors.NONE.code());
    }

    private SaslHandshakeRequest createSaslHandshakeRequest() {
        return new SaslHandshakeRequest("PLAIN");
    }

    private SaslHandshakeResponse createSaslHandshakeResponse() {
        return new SaslHandshakeResponse(Errors.NONE.code(), Collections.singletonList("GSSAPI"));
    }

    private ApiVersionsRequest createApiVersionRequest() {
        return new ApiVersionsRequest.Builder().build();
    }

    private ApiVersionsResponse createApiVersionResponse() {
        List<ApiVersionsResponse.ApiVersion> apiVersions = Arrays.asList(new ApiVersionsResponse.ApiVersion(0, 0, 2));
        return new ApiVersionsResponse(Errors.NONE.code(), apiVersions);
    }

    private CreateTopicsRequest createCreateTopicRequest(int version) {
        return this.createCreateTopicRequest(version, version >= 1);
    }

    private CreateTopicsRequest createCreateTopicRequest(int version, boolean validateOnly) {
        CreateTopicsRequest.TopicDetails request1 = new CreateTopicsRequest.TopicDetails(3, 5);
        HashMap<Integer, List<Integer>> replicaAssignments = new HashMap<Integer, List<Integer>>();
        replicaAssignments.put(1, Arrays.asList(1, 2, 3));
        replicaAssignments.put(2, Arrays.asList(2, 3, 4));
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("config1", "value1");
        CreateTopicsRequest.TopicDetails request2 = new CreateTopicsRequest.TopicDetails(replicaAssignments, configs);
        HashMap<String, CreateTopicsRequest.TopicDetails> request = new HashMap<String, CreateTopicsRequest.TopicDetails>();
        request.put("my_t1", request1);
        request.put("my_t2", request2);
        return (CreateTopicsRequest)new CreateTopicsRequest.Builder(request, 0, validateOnly).setVersion((short)version).build();
    }

    private CreateTopicsResponse createCreateTopicResponse(int version) {
        HashMap<String, CreateTopicsResponse.Error> errors = new HashMap<String, CreateTopicsResponse.Error>();
        errors.put("t1", new CreateTopicsResponse.Error(Errors.INVALID_TOPIC_EXCEPTION, null));
        errors.put("t2", new CreateTopicsResponse.Error(Errors.LEADER_NOT_AVAILABLE, "Leader with id 5 is not available."));
        return new CreateTopicsResponse(errors, (short)version);
    }

    private DeleteTopicsRequest createDeleteTopicsRequest() {
        return new DeleteTopicsRequest.Builder(new HashSet<String>(Arrays.asList("my_t1", "my_t2")), Integer.valueOf(10000)).build();
    }

    private DeleteTopicsResponse createDeleteTopicsResponse() {
        HashMap<String, Errors> errors = new HashMap<String, Errors>();
        errors.put("t1", Errors.INVALID_TOPIC_EXCEPTION);
        errors.put("t2", Errors.TOPIC_AUTHORIZATION_FAILED);
        return new DeleteTopicsResponse(errors);
    }

    private static class ByteBufferChannel
    implements GatheringByteChannel {
        private final ByteBuffer buf;
        private boolean closed = false;

        private ByteBufferChannel(long size) {
            if (size > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("size should be not be greater than Integer.MAX_VALUE");
            }
            this.buf = ByteBuffer.allocate((int)size);
        }

        @Override
        public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            int position = this.buf.position();
            for (int i = 0; i < length; ++i) {
                ByteBuffer src = srcs[i].duplicate();
                if (i == 0) {
                    src.position(offset);
                }
                this.buf.put(src);
            }
            return this.buf.position() - position;
        }

        @Override
        public long write(ByteBuffer[] srcs) throws IOException {
            return this.write(srcs, 0, srcs.length);
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            int position = this.buf.position();
            this.buf.put(src);
            return this.buf.position() - position;
        }

        @Override
        public boolean isOpen() {
            return !this.closed;
        }

        @Override
        public void close() throws IOException {
            this.buf.flip();
            this.closed = true;
        }
    }
}

