/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.nio.ByteBuffer;
import org.apache.kafka.common.record.InvalidRecordException;
import org.apache.kafka.common.record.Record;
import org.junit.Assert;
import org.junit.Test;

public class SimpleRecordTest {
    @Test(expected=InvalidRecordException.class)
    public void testIsValidWithTooSmallBuffer() {
        ByteBuffer buffer = ByteBuffer.allocate(2);
        Record record = new Record(buffer);
        Assert.assertFalse((boolean)record.isValid());
        record.ensureValid();
    }

    @Test(expected=InvalidRecordException.class)
    public void testIsValidWithChecksumMismatch() {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(2);
        Record record = new Record(buffer);
        Assert.assertFalse((boolean)record.isValid());
        record.ensureValid();
    }

    @Test
    public void testIsValidWithFourBytesBuffer() {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        Record record = new Record(buffer);
        Assert.assertTrue((boolean)record.isValid());
        record.ensureValid();
    }

    @Test
    public void testConvertFromV0ToV1() {
        byte[][] keys = new byte[][]{"a".getBytes(), "".getBytes(), null, "b".getBytes()};
        byte[][] values = new byte[][]{"1".getBytes(), "".getBytes(), "2".getBytes(), null};
        for (int i = 0; i < keys.length; ++i) {
            Record record = Record.create((byte)0, (long)-1L, (byte[])keys[i], (byte[])values[i]);
            Record converted = record.convert((byte)1);
            Assert.assertEquals((long)1L, (long)converted.magic());
            Assert.assertEquals((long)-1L, (long)converted.timestamp());
            Assert.assertEquals((Object)record.key(), (Object)converted.key());
            Assert.assertEquals((Object)record.value(), (Object)converted.value());
            Assert.assertTrue((boolean)record.isValid());
            Assert.assertEquals((long)record.convertedSize((byte)1), (long)converted.sizeInBytes());
        }
    }

    @Test
    public void testConvertFromV1ToV0() {
        byte[][] keys = new byte[][]{"a".getBytes(), "".getBytes(), null, "b".getBytes()};
        byte[][] values = new byte[][]{"1".getBytes(), "".getBytes(), "2".getBytes(), null};
        for (int i = 0; i < keys.length; ++i) {
            Record record = Record.create((byte)1, (long)System.currentTimeMillis(), (byte[])keys[i], (byte[])values[i]);
            Record converted = record.convert((byte)0);
            Assert.assertEquals((long)0L, (long)converted.magic());
            Assert.assertEquals((long)-1L, (long)converted.timestamp());
            Assert.assertEquals((Object)record.key(), (Object)converted.key());
            Assert.assertEquals((Object)record.value(), (Object)converted.value());
            Assert.assertTrue((boolean)record.isValid());
            Assert.assertEquals((long)record.convertedSize((byte)0), (long)converted.sizeInBytes());
        }
    }
}

