/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics.stats;

import java.util.Arrays;
import java.util.Random;
import org.apache.kafka.common.metrics.stats.Histogram;
import org.junit.Assert;
import org.junit.Test;

public class HistogramTest {
    private static final double EPS = 1.0E-7;

    @Test
    public void testHistogram() {
        int i;
        Histogram.ConstantBinScheme scheme = new Histogram.ConstantBinScheme(12, -5.0, 5.0);
        Histogram hist = new Histogram((Histogram.BinScheme)scheme);
        for (i = -5; i < 5; ++i) {
            hist.record((double)i);
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((double)scheme.fromBin(i + 1), (double)hist.value((double)i / 10.0 + 1.0E-7), (double)1.0E-7);
        }
    }

    @Test
    public void testConstantBinScheme() {
        Histogram.ConstantBinScheme scheme = new Histogram.ConstantBinScheme(5, -5.0, 5.0);
        Assert.assertEquals((String)"A value below the lower bound should map to the first bin", (long)0L, (long)scheme.toBin(-5.01));
        Assert.assertEquals((String)"A value above the upper bound should map to the last bin", (long)4L, (long)scheme.toBin(5.01));
        Assert.assertEquals((String)"Check boundary of bucket 1", (long)1L, (long)scheme.toBin(-5.0));
        Assert.assertEquals((String)"Check boundary of bucket 4", (long)4L, (long)scheme.toBin(5.0));
        Assert.assertEquals((String)"Check boundary of bucket 3", (long)3L, (long)scheme.toBin(4.9999));
        this.checkBinningConsistency((Histogram.BinScheme)new Histogram.ConstantBinScheme(4, 0.0, 5.0));
        this.checkBinningConsistency((Histogram.BinScheme)scheme);
    }

    @Test
    public void testLinearBinScheme() {
        Histogram.LinearBinScheme scheme = new Histogram.LinearBinScheme(10, 10.0);
        this.checkBinningConsistency((Histogram.BinScheme)scheme);
    }

    private void checkBinningConsistency(Histogram.BinScheme scheme) {
        for (int bin = 0; bin < scheme.bins(); ++bin) {
            double fromBin = scheme.fromBin(bin);
            int binAgain = scheme.toBin(fromBin + 1.0E-7);
            Assert.assertEquals((String)("unbinning and rebinning the bin " + bin + " gave a different result (" + fromBin + " was placed in bin " + binAgain + " )"), (long)bin, (long)binAgain);
        }
    }

    public static void main(String[] args) {
        double quantile;
        Histogram h;
        Random random = new Random();
        System.out.println("[-100, 100]:");
        for (Histogram.BinScheme binScheme : Arrays.asList(new Histogram.ConstantBinScheme(1000, -100.0, 100.0), new Histogram.ConstantBinScheme(100, -100.0, 100.0), new Histogram.ConstantBinScheme(10, -100.0, 100.0))) {
            h = new Histogram(binScheme);
            for (int i = 0; i < 10000; ++i) {
                h.record(200.0 * random.nextDouble() - 100.0);
            }
            for (quantile = 0.0; quantile < 1.0; quantile += 0.05) {
                System.out.printf("%5.2f: %.1f, ", quantile, h.value(quantile));
            }
            System.out.println();
        }
        System.out.println("[0, 1000]");
        for (Histogram.BinScheme binScheme : Arrays.asList(new Histogram.LinearBinScheme(1000, 1000.0), new Histogram.LinearBinScheme(100, 1000.0), new Histogram.LinearBinScheme(10, 1000.0))) {
            h = new Histogram(binScheme);
            for (int i = 0; i < 10000; ++i) {
                h.record(1000.0 * random.nextDouble());
            }
            for (quantile = 0.0; quantile < 1.0; quantile += 0.05) {
                System.out.printf("%5.2f: %.1f, ", quantile, h.value(quantile));
            }
            System.out.println();
        }
    }
}

