/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.utils.Utils;

public class TestUtils {
    public static final File IO_TMP_DIR = new File(System.getProperty("java.io.tmpdir"));
    public static final String LETTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    public static final String DIGITS = "0123456789";
    public static final String LETTERS_AND_DIGITS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    public static final Random SEEDED_RANDOM = new Random(192348092834L);
    public static final Random RANDOM = new Random();

    public static Cluster singletonCluster(Map<String, Integer> topicPartitionCounts) {
        return TestUtils.clusterWith(1, topicPartitionCounts);
    }

    public static Cluster singletonCluster(String topic, int partitions) {
        return TestUtils.clusterWith(1, topic, partitions);
    }

    public static Cluster clusterWith(int nodes, Map<String, Integer> topicPartitionCounts) {
        Node[] ns = new Node[nodes];
        for (int i = 0; i < nodes; ++i) {
            ns[i] = new Node(i, "localhost", 1969);
        }
        ArrayList<PartitionInfo> parts = new ArrayList<PartitionInfo>();
        for (Map.Entry<String, Integer> topicPartition : topicPartitionCounts.entrySet()) {
            String topic = topicPartition.getKey();
            int partitions = topicPartition.getValue();
            for (int i = 0; i < partitions; ++i) {
                parts.add(new PartitionInfo(topic, i, ns[i % ns.length], ns, ns));
            }
        }
        return new Cluster(Arrays.asList(ns), parts, Collections.emptySet());
    }

    public static Cluster clusterWith(int nodes, String topic, int partitions) {
        return TestUtils.clusterWith(nodes, Collections.singletonMap(topic, partitions));
    }

    public static byte[] randomBytes(int size) {
        byte[] bytes = new byte[size];
        SEEDED_RANDOM.nextBytes(bytes);
        return bytes;
    }

    public static String randomString(int len) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            b.append(LETTERS_AND_DIGITS.charAt(SEEDED_RANDOM.nextInt(LETTERS_AND_DIGITS.length())));
        }
        return b.toString();
    }

    public static File tempFile() throws IOException {
        File file = File.createTempFile("kafka", ".tmp");
        file.deleteOnExit();
        return file;
    }

    public static File tempDirectory(String prefix) throws IOException {
        return TestUtils.tempDirectory(null, prefix);
    }

    public static File tempDirectory(Path parent, String prefix) throws IOException {
        final File file = parent == null ? Files.createTempDirectory(prefix == null ? "kafka-" : prefix, new FileAttribute[0]).toFile() : Files.createTempDirectory(parent, prefix == null ? "kafka-" : prefix, new FileAttribute[0]).toFile();
        file.deleteOnExit();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Utils.delete((File)file);
            }
        });
        return file;
    }
}

