/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.serialization;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.junit.Assert;
import org.junit.Test;

public class SerializationTest {
    private final String topic = "testTopic";

    @Test
    public void testSerdeFrom() {
        Serde thisSerde = Serdes.serdeFrom(Long.class);
        Serde otherSerde = Serdes.Long();
        Long value = 423412424L;
        Assert.assertEquals((String)"Should get the original long after serialization and deserialization", (Object)value, (Object)thisSerde.deserializer().deserialize("testTopic", otherSerde.serializer().serialize("testTopic", (Object)value)));
        Assert.assertEquals((String)"Should get the original long after serialization and deserialization", (Object)value, (Object)otherSerde.deserializer().deserialize("testTopic", thisSerde.serializer().serialize("testTopic", (Object)value)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSerdeFromUnknown() {
        Serdes.serdeFrom(DummyClass.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSerdeFromNotNull() {
        Serdes.serdeFrom(null, (Deserializer)Serdes.Long().deserializer());
    }

    @Test
    public void testStringSerializer() {
        String str = "my string";
        ArrayList<String> encodings = new ArrayList<String>();
        encodings.add("UTF8");
        encodings.add("UTF-16");
        for (String encoding : encodings) {
            Serde<String> serDeser = this.getStringSerde(encoding);
            Serializer serializer = serDeser.serializer();
            Deserializer deserializer = serDeser.deserializer();
            Assert.assertEquals((String)("Should get the original string after serialization and deserialization with encoding " + encoding), (Object)str, (Object)deserializer.deserialize("testTopic", serializer.serialize("testTopic", (Object)str)));
            Assert.assertEquals((String)("Should support null in serialization and deserialization with encoding " + encoding), null, (Object)deserializer.deserialize("testTopic", serializer.serialize("testTopic", null)));
        }
    }

    @Test
    public void testIntegerSerializer() {
        Integer[] integers = new Integer[]{423412424, -41243432};
        Serializer serializer = Serdes.Integer().serializer();
        Deserializer deserializer = Serdes.Integer().deserializer();
        for (Integer integer : integers) {
            Assert.assertEquals((String)"Should get the original integer after serialization and deserialization", (Object)integer, (Object)deserializer.deserialize("testTopic", serializer.serialize("testTopic", (Object)integer)));
        }
        Assert.assertEquals((String)"Should support null in serialization and deserialization", null, (Object)deserializer.deserialize("testTopic", serializer.serialize("testTopic", null)));
        serializer.close();
        deserializer.close();
    }

    @Test
    public void testLongSerializer() {
        Long[] longs = new Long[]{0xCCCCCCCCCCCCCCCL, -922337203685477581L};
        Serializer serializer = Serdes.Long().serializer();
        Deserializer deserializer = Serdes.Long().deserializer();
        for (Long value : longs) {
            Assert.assertEquals((String)"Should get the original long after serialization and deserialization", (Object)value, (Object)deserializer.deserialize("testTopic", serializer.serialize("testTopic", (Object)value)));
        }
        Assert.assertEquals((String)"Should support null in serialization and deserialization", null, (Object)deserializer.deserialize("testTopic", serializer.serialize("testTopic", null)));
        serializer.close();
        deserializer.close();
    }

    @Test
    public void testDoubleSerializer() {
        Double[] doubles = new Double[]{5678567.12312, -5678567.12341};
        Serializer serializer = Serdes.Double().serializer();
        Deserializer deserializer = Serdes.Double().deserializer();
        for (Double value : doubles) {
            Assert.assertEquals((String)"Should get the original double after serialization and deserialization", (Object)value, (Object)deserializer.deserialize("testTopic", serializer.serialize("testTopic", (Object)value)));
        }
        Assert.assertEquals((String)"Should support null in serialization and deserialization", null, (Object)deserializer.deserialize("testTopic", serializer.serialize("testTopic", null)));
        serializer.close();
        deserializer.close();
    }

    @Test
    public void testByteBufferSerializer() {
        ByteBuffer buf = ByteBuffer.allocate(10);
        buf.put("my string".getBytes());
        Serializer serializer = Serdes.ByteBuffer().serializer();
        Deserializer deserializer = Serdes.ByteBuffer().deserializer();
        Assert.assertEquals((String)"Should get the original ByteBuffer after serialization and deserialization", (Object)buf, (Object)deserializer.deserialize("testTopic", serializer.serialize("testTopic", (Object)buf)));
        Assert.assertEquals((String)"Should support null in serialization and deserialization", null, (Object)deserializer.deserialize("testTopic", serializer.serialize("testTopic", null)));
        serializer.close();
        deserializer.close();
    }

    private Serde<String> getStringSerde(String encoder) {
        HashMap<String, String> serializerConfigs = new HashMap<String, String>();
        serializerConfigs.put("key.serializer.encoding", encoder);
        Serializer serializer = Serdes.String().serializer();
        serializer.configure(serializerConfigs, true);
        HashMap<String, String> deserializerConfigs = new HashMap<String, String>();
        deserializerConfigs.put("key.deserializer.encoding", encoder);
        Deserializer deserializer = Serdes.String().deserializer();
        deserializer.configure(deserializerConfigs, true);
        return Serdes.serdeFrom((Serializer)serializer, (Deserializer)deserializer);
    }

    private class DummyClass {
        private DummyClass() {
        }
    }
}

