/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.ssl;

import java.io.File;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.security.ssl.SslFactory;
import org.apache.kafka.test.TestSslUtils;
import org.junit.Assert;
import org.junit.Test;

public class SslFactoryTest {
    @Test
    public void testSslFactoryConfiguration() throws Exception {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> serverSslConfig = TestSslUtils.createSslConfig(false, true, Mode.SERVER, trustStoreFile, "server");
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        sslFactory.configure(serverSslConfig);
        SSLEngine engine = sslFactory.createSslEngine("localhost", 0);
        Assert.assertNotNull((Object)engine);
        Object[] expectedProtocols = new String[]{"TLSv1.2"};
        Assert.assertArrayEquals((Object[])expectedProtocols, (Object[])engine.getEnabledProtocols());
        Assert.assertEquals((Object)false, (Object)engine.getUseClientMode());
    }

    @Test
    public void testClientMode() throws Exception {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> clientSslConfig = TestSslUtils.createSslConfig(false, true, Mode.CLIENT, trustStoreFile, "client");
        SslFactory sslFactory = new SslFactory(Mode.CLIENT);
        sslFactory.configure(clientSslConfig);
        SSLEngine engine = sslFactory.createSslEngine("localhost", 0);
        Assert.assertTrue((boolean)engine.getUseClientMode());
    }
}

