/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.consumer.CommitFailedException;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.clients.consumer.RangeAssignor;
import org.apache.kafka.clients.consumer.RetriableCommitFailedException;
import org.apache.kafka.clients.consumer.RoundRobinAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerCoordinator;
import org.apache.kafka.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.clients.consumer.internals.MockPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.PartitionAssignor;
import org.apache.kafka.clients.consumer.internals.RequestFuture;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.DisconnectException;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.OffsetMetadataTooLarge;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.GroupCoordinatorResponse;
import org.apache.kafka.common.requests.HeartbeatResponse;
import org.apache.kafka.common.requests.JoinGroupRequest;
import org.apache.kafka.common.requests.JoinGroupResponse;
import org.apache.kafka.common.requests.LeaveGroupRequest;
import org.apache.kafka.common.requests.LeaveGroupResponse;
import org.apache.kafka.common.requests.OffsetCommitRequest;
import org.apache.kafka.common.requests.OffsetCommitResponse;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.requests.SyncGroupRequest;
import org.apache.kafka.common.requests.SyncGroupResponse;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConsumerCoordinatorTest {
    private String topicName = "test";
    private String groupId = "test-group";
    private TopicPartition tp = new TopicPartition(this.topicName, 0);
    private int sessionTimeoutMs = 10000;
    private int heartbeatIntervalMs = 5000;
    private long retryBackoffMs = 100L;
    private boolean autoCommitEnabled = false;
    private long autoCommitIntervalMs = 2000L;
    private MockPartitionAssignor partitionAssignor = new MockPartitionAssignor();
    private List<PartitionAssignor> assignors = Collections.singletonList(this.partitionAssignor);
    private MockTime time;
    private MockClient client;
    private Cluster cluster = TestUtils.singletonCluster(this.topicName, 1);
    private Node node = (Node)this.cluster.nodes().get(0);
    private SubscriptionState subscriptions;
    private Metadata metadata;
    private Metrics metrics;
    private ConsumerNetworkClient consumerClient;
    private MockRebalanceListener rebalanceListener;
    private MockCommitCallback defaultOffsetCommitCallback;
    private ConsumerCoordinator coordinator;

    @Before
    public void setup() {
        this.time = new MockTime();
        this.client = new MockClient(this.time);
        this.subscriptions = new SubscriptionState(OffsetResetStrategy.EARLIEST);
        this.metadata = new Metadata(0L, Long.MAX_VALUE);
        this.metadata.update(this.cluster, this.time.milliseconds());
        this.consumerClient = new ConsumerNetworkClient((KafkaClient)this.client, this.metadata, (Time)this.time, 100L, 1000L);
        this.metrics = new Metrics((Time)this.time);
        this.rebalanceListener = new MockRebalanceListener();
        this.defaultOffsetCommitCallback = new MockCommitCallback();
        this.partitionAssignor.clear();
        this.client.setNode(this.node);
        this.coordinator = this.buildCoordinator(this.metrics, this.assignors, true, this.autoCommitEnabled);
    }

    @After
    public void teardown() {
        this.metrics.close();
    }

    @Test
    public void testNormalHeartbeat() {
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.coordinator.ensureCoordinatorReady();
        this.time.sleep(this.sessionTimeoutMs);
        RequestFuture future = this.coordinator.sendHeartbeatRequest();
        Assert.assertEquals((long)1L, (long)this.consumerClient.pendingRequestCount());
        Assert.assertFalse((boolean)future.isDone());
        this.client.prepareResponse(this.heartbeatResponse(Errors.NONE.code()));
        this.consumerClient.poll(0L);
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertTrue((boolean)future.succeeded());
    }

    @Test(expected=GroupAuthorizationException.class)
    public void testGroupDescribeUnauthorized() {
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.GROUP_AUTHORIZATION_FAILED.code()));
        this.coordinator.ensureCoordinatorReady();
    }

    @Test(expected=GroupAuthorizationException.class)
    public void testGroupReadUnauthorized() {
        this.subscriptions.subscribe(Arrays.asList(this.topicName), (ConsumerRebalanceListener)this.rebalanceListener);
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.coordinator.ensureCoordinatorReady();
        this.client.prepareResponse(this.joinGroupLeaderResponse(0, "memberId", Collections.emptyMap(), Errors.GROUP_AUTHORIZATION_FAILED.code()));
        this.coordinator.ensurePartitionAssignment();
    }

    @Test
    public void testCoordinatorNotAvailable() {
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.coordinator.ensureCoordinatorReady();
        this.time.sleep(this.sessionTimeoutMs);
        RequestFuture future = this.coordinator.sendHeartbeatRequest();
        Assert.assertEquals((long)1L, (long)this.consumerClient.pendingRequestCount());
        Assert.assertFalse((boolean)future.isDone());
        this.client.prepareResponse(this.heartbeatResponse(Errors.GROUP_COORDINATOR_NOT_AVAILABLE.code()));
        this.time.sleep(this.sessionTimeoutMs);
        this.consumerClient.poll(0L);
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertTrue((boolean)future.failed());
        Assert.assertEquals((Object)Errors.GROUP_COORDINATOR_NOT_AVAILABLE.exception(), (Object)future.exception());
        Assert.assertTrue((boolean)this.coordinator.coordinatorUnknown());
    }

    @Test
    public void testNotCoordinator() {
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.coordinator.ensureCoordinatorReady();
        this.time.sleep(this.sessionTimeoutMs);
        RequestFuture future = this.coordinator.sendHeartbeatRequest();
        Assert.assertEquals((long)1L, (long)this.consumerClient.pendingRequestCount());
        Assert.assertFalse((boolean)future.isDone());
        this.client.prepareResponse(this.heartbeatResponse(Errors.NOT_COORDINATOR_FOR_GROUP.code()));
        this.time.sleep(this.sessionTimeoutMs);
        this.consumerClient.poll(0L);
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertTrue((boolean)future.failed());
        Assert.assertEquals((Object)Errors.NOT_COORDINATOR_FOR_GROUP.exception(), (Object)future.exception());
        Assert.assertTrue((boolean)this.coordinator.coordinatorUnknown());
    }

    @Test
    public void testIllegalGeneration() {
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.coordinator.ensureCoordinatorReady();
        this.subscriptions.subscribe(Arrays.asList(this.topicName), (ConsumerRebalanceListener)this.rebalanceListener);
        this.subscriptions.assignFromSubscribed(Collections.singletonList(this.tp));
        this.time.sleep(this.sessionTimeoutMs);
        RequestFuture future = this.coordinator.sendHeartbeatRequest();
        Assert.assertEquals((long)1L, (long)this.consumerClient.pendingRequestCount());
        Assert.assertFalse((boolean)future.isDone());
        this.client.prepareResponse(this.heartbeatResponse(Errors.ILLEGAL_GENERATION.code()));
        this.time.sleep(this.sessionTimeoutMs);
        this.consumerClient.poll(0L);
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertTrue((boolean)future.failed());
        Assert.assertEquals((Object)Errors.ILLEGAL_GENERATION.exception(), (Object)future.exception());
        Assert.assertTrue((boolean)this.coordinator.needRejoin());
    }

    @Test
    public void testUnknownConsumerId() {
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.coordinator.ensureCoordinatorReady();
        this.subscriptions.subscribe(Arrays.asList(this.topicName), (ConsumerRebalanceListener)this.rebalanceListener);
        this.subscriptions.assignFromSubscribed(Collections.singletonList(this.tp));
        this.time.sleep(this.sessionTimeoutMs);
        RequestFuture future = this.coordinator.sendHeartbeatRequest();
        Assert.assertEquals((long)1L, (long)this.consumerClient.pendingRequestCount());
        Assert.assertFalse((boolean)future.isDone());
        this.client.prepareResponse(this.heartbeatResponse(Errors.UNKNOWN_MEMBER_ID.code()));
        this.time.sleep(this.sessionTimeoutMs);
        this.consumerClient.poll(0L);
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertTrue((boolean)future.failed());
        Assert.assertEquals((Object)Errors.UNKNOWN_MEMBER_ID.exception(), (Object)future.exception());
        Assert.assertTrue((boolean)this.coordinator.needRejoin());
    }

    @Test
    public void testCoordinatorDisconnect() {
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.coordinator.ensureCoordinatorReady();
        this.time.sleep(this.sessionTimeoutMs);
        RequestFuture future = this.coordinator.sendHeartbeatRequest();
        Assert.assertEquals((long)1L, (long)this.consumerClient.pendingRequestCount());
        Assert.assertFalse((boolean)future.isDone());
        this.client.prepareResponse(this.heartbeatResponse(Errors.NONE.code()), true);
        this.time.sleep(this.sessionTimeoutMs);
        this.consumerClient.poll(0L);
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertTrue((boolean)future.failed());
        Assert.assertTrue((boolean)(future.exception() instanceof DisconnectException));
        Assert.assertTrue((boolean)this.coordinator.coordinatorUnknown());
    }

    @Test(expected=ApiException.class)
    public void testJoinGroupInvalidGroupId() {
        String consumerId = "leader";
        this.subscriptions.subscribe(Arrays.asList(this.topicName), (ConsumerRebalanceListener)this.rebalanceListener);
        this.subscriptions.needReassignment();
        this.metadata.setTopics(Arrays.asList(this.topicName));
        this.metadata.update(this.cluster, this.time.milliseconds());
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.coordinator.ensureCoordinatorReady();
        this.client.prepareResponse(this.joinGroupLeaderResponse(0, "leader", Collections.emptyMap(), Errors.INVALID_GROUP_ID.code()));
        this.coordinator.ensurePartitionAssignment();
    }

    @Test
    public void testNormalJoinGroupLeader() {
        String consumerId = "leader";
        this.subscriptions.subscribe(Arrays.asList(this.topicName), (ConsumerRebalanceListener)this.rebalanceListener);
        this.subscriptions.needReassignment();
        this.metadata.setTopics(Arrays.asList(this.topicName));
        this.metadata.update(this.cluster, this.time.milliseconds());
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.coordinator.ensureCoordinatorReady();
        Map<String, List<String>> memberSubscriptions = Collections.singletonMap("leader", Arrays.asList(this.topicName));
        this.partitionAssignor.prepare(Collections.singletonMap("leader", Arrays.asList(this.tp)));
        this.client.prepareResponse(this.joinGroupLeaderResponse(1, "leader", memberSubscriptions, Errors.NONE.code()));
        this.client.prepareResponse(new MockClient.RequestMatcher(){

            @Override
            public boolean matches(ClientRequest request) {
                SyncGroupRequest sync = new SyncGroupRequest(request.request().body());
                return sync.memberId().equals("leader") && sync.generationId() == 1 && sync.groupAssignment().containsKey("leader");
            }
        }, this.syncGroupResponse(Arrays.asList(this.tp), Errors.NONE.code()));
        this.coordinator.ensurePartitionAssignment();
        Assert.assertFalse((boolean)this.subscriptions.partitionAssignmentNeeded());
        Assert.assertEquals(Collections.singleton(this.tp), (Object)this.subscriptions.assignedPartitions());
        Assert.assertEquals((long)1L, (long)this.rebalanceListener.revokedCount);
        Assert.assertEquals(Collections.emptySet(), this.rebalanceListener.revoked);
        Assert.assertEquals((long)1L, (long)this.rebalanceListener.assignedCount);
        Assert.assertEquals(Collections.singleton(this.tp), this.rebalanceListener.assigned);
    }

    @Test
    public void testWakeupDuringJoin() {
        String consumerId = "leader";
        this.subscriptions.subscribe(Arrays.asList(this.topicName), (ConsumerRebalanceListener)this.rebalanceListener);
        this.subscriptions.needReassignment();
        this.metadata.setTopics(Arrays.asList(this.topicName));
        this.metadata.update(this.cluster, this.time.milliseconds());
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.coordinator.ensureCoordinatorReady();
        Map<String, List<String>> memberSubscriptions = Collections.singletonMap("leader", Arrays.asList(this.topicName));
        this.partitionAssignor.prepare(Collections.singletonMap("leader", Arrays.asList(this.tp)));
        this.client.prepareResponse(this.joinGroupLeaderResponse(1, "leader", memberSubscriptions, Errors.NONE.code()));
        this.consumerClient.wakeup();
        try {
            this.coordinator.ensurePartitionAssignment();
        }
        catch (WakeupException wakeupException) {
            // empty catch block
        }
        this.client.prepareResponse(this.syncGroupResponse(Arrays.asList(this.tp), Errors.NONE.code()));
        this.coordinator.ensurePartitionAssignment();
        Assert.assertFalse((boolean)this.subscriptions.partitionAssignmentNeeded());
        Assert.assertEquals(Collections.singleton(this.tp), (Object)this.subscriptions.assignedPartitions());
        Assert.assertEquals((long)1L, (long)this.rebalanceListener.revokedCount);
        Assert.assertEquals(Collections.emptySet(), this.rebalanceListener.revoked);
        Assert.assertEquals((long)1L, (long)this.rebalanceListener.assignedCount);
        Assert.assertEquals(Collections.singleton(this.tp), this.rebalanceListener.assigned);
    }

    @Test
    public void testNormalJoinGroupFollower() {
        String consumerId = "consumer";
        this.subscriptions.subscribe(Arrays.asList(this.topicName), (ConsumerRebalanceListener)this.rebalanceListener);
        this.subscriptions.needReassignment();
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.coordinator.ensureCoordinatorReady();
        this.client.prepareResponse(this.joinGroupFollowerResponse(1, "consumer", "leader", Errors.NONE.code()));
        this.client.prepareResponse(new MockClient.RequestMatcher(){

            @Override
            public boolean matches(ClientRequest request) {
                SyncGroupRequest sync = new SyncGroupRequest(request.request().body());
                return sync.memberId().equals("consumer") && sync.generationId() == 1 && sync.groupAssignment().isEmpty();
            }
        }, this.syncGroupResponse(Arrays.asList(this.tp), Errors.NONE.code()));
        this.coordinator.ensurePartitionAssignment();
        Assert.assertFalse((boolean)this.subscriptions.partitionAssignmentNeeded());
        Assert.assertEquals(Collections.singleton(this.tp), (Object)this.subscriptions.assignedPartitions());
        Assert.assertEquals((long)1L, (long)this.rebalanceListener.revokedCount);
        Assert.assertEquals((long)1L, (long)this.rebalanceListener.assignedCount);
        Assert.assertEquals(Collections.singleton(this.tp), this.rebalanceListener.assigned);
    }

    @Test
    public void testLeaveGroupOnClose() {
        String consumerId = "consumer";
        this.subscriptions.subscribe(Arrays.asList(this.topicName), (ConsumerRebalanceListener)this.rebalanceListener);
        this.subscriptions.needReassignment();
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.coordinator.ensureCoordinatorReady();
        this.client.prepareResponse(this.joinGroupFollowerResponse(1, "consumer", "leader", Errors.NONE.code()));
        this.client.prepareResponse(this.syncGroupResponse(Arrays.asList(this.tp), Errors.NONE.code()));
        this.coordinator.ensurePartitionAssignment();
        final AtomicBoolean received = new AtomicBoolean(false);
        this.client.prepareResponse(new MockClient.RequestMatcher(){

            @Override
            public boolean matches(ClientRequest request) {
                received.set(true);
                LeaveGroupRequest leaveRequest = new LeaveGroupRequest(request.request().body());
                return leaveRequest.memberId().equals("consumer") && leaveRequest.groupId().equals(ConsumerCoordinatorTest.this.groupId);
            }
        }, new LeaveGroupResponse(Errors.NONE.code()).toStruct());
        this.coordinator.close();
        Assert.assertTrue((boolean)received.get());
    }

    @Test
    public void testMaybeLeaveGroup() {
        String consumerId = "consumer";
        this.subscriptions.subscribe(Arrays.asList(this.topicName), (ConsumerRebalanceListener)this.rebalanceListener);
        this.subscriptions.needReassignment();
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.coordinator.ensureCoordinatorReady();
        this.client.prepareResponse(this.joinGroupFollowerResponse(1, "consumer", "leader", Errors.NONE.code()));
        this.client.prepareResponse(this.syncGroupResponse(Arrays.asList(this.tp), Errors.NONE.code()));
        this.coordinator.ensurePartitionAssignment();
        final AtomicBoolean received = new AtomicBoolean(false);
        this.client.prepareResponse(new MockClient.RequestMatcher(){

            @Override
            public boolean matches(ClientRequest request) {
                received.set(true);
                LeaveGroupRequest leaveRequest = new LeaveGroupRequest(request.request().body());
                return leaveRequest.memberId().equals("consumer") && leaveRequest.groupId().equals(ConsumerCoordinatorTest.this.groupId);
            }
        }, new LeaveGroupResponse(Errors.NONE.code()).toStruct());
        this.coordinator.maybeLeaveGroup();
        Assert.assertTrue((boolean)received.get());
        Assert.assertEquals((Object)"", (Object)this.coordinator.memberId);
        Assert.assertEquals((long)-1L, (long)this.coordinator.generation);
    }

    @Test(expected=KafkaException.class)
    public void testUnexpectedErrorOnSyncGroup() {
        String consumerId = "consumer";
        this.subscriptions.subscribe(Arrays.asList(this.topicName), (ConsumerRebalanceListener)this.rebalanceListener);
        this.subscriptions.needReassignment();
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.coordinator.ensureCoordinatorReady();
        this.client.prepareResponse(this.joinGroupFollowerResponse(1, "consumer", "leader", Errors.NONE.code()));
        this.client.prepareResponse(this.syncGroupResponse(Collections.emptyList(), Errors.UNKNOWN.code()));
        this.coordinator.ensurePartitionAssignment();
    }

    @Test
    public void testUnknownMemberIdOnSyncGroup() {
        String consumerId = "consumer";
        this.subscriptions.subscribe(Arrays.asList(this.topicName), (ConsumerRebalanceListener)this.rebalanceListener);
        this.subscriptions.needReassignment();
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.coordinator.ensureCoordinatorReady();
        this.client.prepareResponse(this.joinGroupFollowerResponse(1, "consumer", "leader", Errors.NONE.code()));
        this.client.prepareResponse(this.syncGroupResponse(Collections.emptyList(), Errors.UNKNOWN_MEMBER_ID.code()));
        this.client.prepareResponse(new MockClient.RequestMatcher(){

            @Override
            public boolean matches(ClientRequest request) {
                JoinGroupRequest joinRequest = new JoinGroupRequest(request.request().body());
                return joinRequest.memberId().equals("");
            }
        }, this.joinGroupFollowerResponse(2, "consumer", "leader", Errors.NONE.code()));
        this.client.prepareResponse(this.syncGroupResponse(Arrays.asList(this.tp), Errors.NONE.code()));
        this.coordinator.ensurePartitionAssignment();
        Assert.assertFalse((boolean)this.subscriptions.partitionAssignmentNeeded());
        Assert.assertEquals(Collections.singleton(this.tp), (Object)this.subscriptions.assignedPartitions());
    }

    @Test
    public void testRebalanceInProgressOnSyncGroup() {
        String consumerId = "consumer";
        this.subscriptions.subscribe(Arrays.asList(this.topicName), (ConsumerRebalanceListener)this.rebalanceListener);
        this.subscriptions.needReassignment();
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.coordinator.ensureCoordinatorReady();
        this.client.prepareResponse(this.joinGroupFollowerResponse(1, "consumer", "leader", Errors.NONE.code()));
        this.client.prepareResponse(this.syncGroupResponse(Collections.emptyList(), Errors.REBALANCE_IN_PROGRESS.code()));
        this.client.prepareResponse(this.joinGroupFollowerResponse(2, "consumer", "leader", Errors.NONE.code()));
        this.client.prepareResponse(this.syncGroupResponse(Arrays.asList(this.tp), Errors.NONE.code()));
        this.coordinator.ensurePartitionAssignment();
        Assert.assertFalse((boolean)this.subscriptions.partitionAssignmentNeeded());
        Assert.assertEquals(Collections.singleton(this.tp), (Object)this.subscriptions.assignedPartitions());
    }

    @Test
    public void testIllegalGenerationOnSyncGroup() {
        String consumerId = "consumer";
        this.subscriptions.subscribe(Arrays.asList(this.topicName), (ConsumerRebalanceListener)this.rebalanceListener);
        this.subscriptions.needReassignment();
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.coordinator.ensureCoordinatorReady();
        this.client.prepareResponse(this.joinGroupFollowerResponse(1, "consumer", "leader", Errors.NONE.code()));
        this.client.prepareResponse(this.syncGroupResponse(Collections.emptyList(), Errors.ILLEGAL_GENERATION.code()));
        this.client.prepareResponse(new MockClient.RequestMatcher(){

            @Override
            public boolean matches(ClientRequest request) {
                JoinGroupRequest joinRequest = new JoinGroupRequest(request.request().body());
                return joinRequest.memberId().equals("");
            }
        }, this.joinGroupFollowerResponse(2, "consumer", "leader", Errors.NONE.code()));
        this.client.prepareResponse(this.syncGroupResponse(Arrays.asList(this.tp), Errors.NONE.code()));
        this.coordinator.ensurePartitionAssignment();
        Assert.assertFalse((boolean)this.subscriptions.partitionAssignmentNeeded());
        Assert.assertEquals(Collections.singleton(this.tp), (Object)this.subscriptions.assignedPartitions());
    }

    @Test
    public void testMetadataChangeTriggersRebalance() {
        String consumerId = "consumer";
        this.subscriptions.subscribe(Arrays.asList(this.topicName), (ConsumerRebalanceListener)this.rebalanceListener);
        this.subscriptions.needReassignment();
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.coordinator.ensureCoordinatorReady();
        this.client.prepareResponse(this.joinGroupFollowerResponse(1, "consumer", "leader", Errors.NONE.code()));
        this.client.prepareResponse(this.syncGroupResponse(Arrays.asList(this.tp), Errors.NONE.code()));
        this.coordinator.ensurePartitionAssignment();
        Assert.assertFalse((boolean)this.subscriptions.partitionAssignmentNeeded());
        this.metadata.update(TestUtils.singletonCluster(this.topicName, 2), this.time.milliseconds());
        Assert.assertTrue((boolean)this.subscriptions.partitionAssignmentNeeded());
    }

    @Test
    public void testUpdateMetadataDuringRebalance() {
        String topic1 = "topic1";
        String topic2 = "topic2";
        TopicPartition tp1 = new TopicPartition("topic1", 0);
        TopicPartition tp2 = new TopicPartition("topic2", 0);
        String consumerId = "leader";
        List<String> topics = Arrays.asList("topic1", "topic2");
        this.subscriptions.subscribe(topics, (ConsumerRebalanceListener)this.rebalanceListener);
        this.metadata.setTopics(topics);
        this.subscriptions.needReassignment();
        this.metadata.update(TestUtils.singletonCluster("topic1", 1), this.time.milliseconds());
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.coordinator.ensureCoordinatorReady();
        Map<String, List<String>> memberSubscriptions = Collections.singletonMap("leader", topics);
        this.partitionAssignor.prepare(Collections.singletonMap("leader", Arrays.asList(tp1)));
        this.client.prepareResponse(this.joinGroupLeaderResponse(1, "leader", memberSubscriptions, Errors.NONE.code()));
        this.client.prepareResponse(new MockClient.RequestMatcher(){

            @Override
            public boolean matches(ClientRequest request) {
                SyncGroupRequest sync = new SyncGroupRequest(request.request().body());
                if (sync.memberId().equals("leader") && sync.generationId() == 1 && sync.groupAssignment().containsKey("leader")) {
                    HashMap<String, Integer> topicPartitionCounts = new HashMap<String, Integer>();
                    topicPartitionCounts.put("topic1", 1);
                    topicPartitionCounts.put("topic2", 1);
                    ConsumerCoordinatorTest.this.metadata.update(TestUtils.singletonCluster(topicPartitionCounts), ConsumerCoordinatorTest.this.time.milliseconds());
                    return true;
                }
                return false;
            }
        }, this.syncGroupResponse(Arrays.asList(tp1), Errors.NONE.code()));
        this.client.prepareResponse(this.joinGroupLeaderResponse(2, "leader", memberSubscriptions, Errors.NONE.code()));
        this.client.prepareResponse(this.syncGroupResponse(Arrays.asList(tp1, tp2), Errors.NONE.code()));
        this.coordinator.ensurePartitionAssignment();
        Assert.assertFalse((boolean)this.subscriptions.partitionAssignmentNeeded());
        Assert.assertEquals(new HashSet<TopicPartition>(Arrays.asList(tp1, tp2)), (Object)this.subscriptions.assignedPartitions());
    }

    @Test
    public void testExcludeInternalTopicsConfigOption() {
        this.subscriptions.subscribe(Pattern.compile(".*"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.metadata.update(TestUtils.singletonCluster("__consumer_offsets", 2), this.time.milliseconds());
        Assert.assertFalse((boolean)this.subscriptions.partitionAssignmentNeeded());
    }

    @Test
    public void testIncludeInternalTopicsConfigOption() {
        this.coordinator = this.buildCoordinator(new Metrics(), this.assignors, false, false);
        this.subscriptions.subscribe(Pattern.compile(".*"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.metadata.update(TestUtils.singletonCluster("__consumer_offsets", 2), this.time.milliseconds());
        Assert.assertTrue((boolean)this.subscriptions.partitionAssignmentNeeded());
    }

    @Test
    public void testRejoinGroup() {
        this.subscriptions.subscribe(Arrays.asList(this.topicName), (ConsumerRebalanceListener)this.rebalanceListener);
        this.subscriptions.needReassignment();
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.coordinator.ensureCoordinatorReady();
        this.client.prepareResponse(this.joinGroupFollowerResponse(1, "consumer", "leader", Errors.NONE.code()));
        this.client.prepareResponse(this.syncGroupResponse(Arrays.asList(this.tp), Errors.NONE.code()));
        this.coordinator.ensurePartitionAssignment();
        Assert.assertEquals((long)1L, (long)this.rebalanceListener.revokedCount);
        Assert.assertEquals((long)1L, (long)this.rebalanceListener.assignedCount);
        this.subscriptions.needReassignment();
        this.client.prepareResponse(this.joinGroupFollowerResponse(2, "consumer", "leader", Errors.NONE.code()));
        this.client.prepareResponse(this.syncGroupResponse(Arrays.asList(this.tp), Errors.NONE.code()));
        this.coordinator.ensurePartitionAssignment();
        Assert.assertEquals((long)2L, (long)this.rebalanceListener.revokedCount);
        Assert.assertEquals(Collections.singleton(this.tp), this.rebalanceListener.revoked);
        Assert.assertEquals((long)2L, (long)this.rebalanceListener.assignedCount);
        Assert.assertEquals(Collections.singleton(this.tp), this.rebalanceListener.assigned);
    }

    @Test
    public void testDisconnectInJoin() {
        this.subscriptions.subscribe(Arrays.asList(this.topicName), (ConsumerRebalanceListener)this.rebalanceListener);
        this.subscriptions.needReassignment();
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.coordinator.ensureCoordinatorReady();
        this.client.prepareResponse(this.joinGroupFollowerResponse(1, "consumer", "leader", Errors.NONE.code()), true);
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.client.prepareResponse(this.joinGroupFollowerResponse(1, "consumer", "leader", Errors.NONE.code()));
        this.client.prepareResponse(this.syncGroupResponse(Arrays.asList(this.tp), Errors.NONE.code()));
        this.coordinator.ensurePartitionAssignment();
        Assert.assertFalse((boolean)this.subscriptions.partitionAssignmentNeeded());
        Assert.assertEquals(Collections.singleton(this.tp), (Object)this.subscriptions.assignedPartitions());
        Assert.assertEquals((long)1L, (long)this.rebalanceListener.revokedCount);
        Assert.assertEquals((long)1L, (long)this.rebalanceListener.assignedCount);
        Assert.assertEquals(Collections.singleton(this.tp), this.rebalanceListener.assigned);
    }

    @Test(expected=ApiException.class)
    public void testInvalidSessionTimeout() {
        this.subscriptions.subscribe(Arrays.asList(this.topicName), (ConsumerRebalanceListener)this.rebalanceListener);
        this.subscriptions.needReassignment();
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.coordinator.ensureCoordinatorReady();
        this.client.prepareResponse(this.joinGroupFollowerResponse(0, "consumer", "", Errors.INVALID_SESSION_TIMEOUT.code()));
        this.coordinator.ensurePartitionAssignment();
    }

    @Test
    public void testCommitOffsetOnly() {
        this.subscriptions.assignFromUser(Arrays.asList(this.tp));
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.coordinator.ensureCoordinatorReady();
        this.client.prepareResponse(this.offsetCommitResponse(Collections.singletonMap(this.tp, Errors.NONE.code())));
        AtomicBoolean success = new AtomicBoolean(false);
        this.coordinator.commitOffsetsAsync(Collections.singletonMap(this.tp, new OffsetAndMetadata(100L)), this.callback(success));
        Assert.assertTrue((boolean)success.get());
        Assert.assertEquals((long)100L, (long)this.subscriptions.committed(this.tp).offset());
    }

    @Test
    public void testAutoCommitDynamicAssignment() {
        String consumerId = "consumer";
        ConsumerCoordinator coordinator = this.buildCoordinator(new Metrics(), this.assignors, true, true);
        this.subscriptions.subscribe(Arrays.asList(this.topicName), (ConsumerRebalanceListener)this.rebalanceListener);
        this.subscriptions.needReassignment();
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        coordinator.ensureCoordinatorReady();
        this.client.prepareResponse(this.joinGroupFollowerResponse(1, "consumer", "leader", Errors.NONE.code()));
        this.client.prepareResponse(this.syncGroupResponse(Arrays.asList(this.tp), Errors.NONE.code()));
        coordinator.ensurePartitionAssignment();
        this.subscriptions.seek(this.tp, 100L);
        this.client.prepareResponse(this.offsetCommitResponse(Collections.singletonMap(this.tp, Errors.NONE.code())));
        this.time.sleep(this.autoCommitIntervalMs);
        this.consumerClient.poll(0L);
        Assert.assertEquals((long)100L, (long)this.subscriptions.committed(this.tp).offset());
    }

    @Test
    public void testAutoCommitDynamicAssignmentRebalance() {
        String consumerId = "consumer";
        ConsumerCoordinator coordinator = this.buildCoordinator(new Metrics(), this.assignors, true, true);
        this.subscriptions.subscribe(Arrays.asList(this.topicName), (ConsumerRebalanceListener)this.rebalanceListener);
        this.subscriptions.needReassignment();
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        coordinator.ensureCoordinatorReady();
        this.time.sleep(this.autoCommitIntervalMs);
        this.consumerClient.poll(0L);
        this.client.prepareResponse(this.joinGroupFollowerResponse(1, "consumer", "leader", Errors.NONE.code()));
        this.client.prepareResponse(this.syncGroupResponse(Arrays.asList(this.tp), Errors.NONE.code()));
        coordinator.ensurePartitionAssignment();
        this.subscriptions.seek(this.tp, 100L);
        this.client.prepareResponse(this.offsetCommitResponse(Collections.singletonMap(this.tp, Errors.NONE.code())));
        this.time.sleep(this.autoCommitIntervalMs);
        this.consumerClient.poll(0L);
        Assert.assertEquals((long)100L, (long)this.subscriptions.committed(this.tp).offset());
    }

    @Test
    public void testAutoCommitManualAssignment() {
        ConsumerCoordinator coordinator = this.buildCoordinator(new Metrics(), this.assignors, true, true);
        this.subscriptions.assignFromUser(Arrays.asList(this.tp));
        this.subscriptions.seek(this.tp, 100L);
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        coordinator.ensureCoordinatorReady();
        this.client.prepareResponse(this.offsetCommitResponse(Collections.singletonMap(this.tp, Errors.NONE.code())));
        this.time.sleep(this.autoCommitIntervalMs);
        this.consumerClient.poll(0L);
        Assert.assertEquals((long)100L, (long)this.subscriptions.committed(this.tp).offset());
    }

    @Test
    public void testAutoCommitManualAssignmentCoordinatorUnknown() {
        ConsumerCoordinator coordinator = this.buildCoordinator(new Metrics(), this.assignors, true, true);
        this.subscriptions.assignFromUser(Arrays.asList(this.tp));
        this.subscriptions.seek(this.tp, 100L);
        this.consumerClient.poll(0L);
        this.time.sleep(this.autoCommitIntervalMs);
        this.consumerClient.poll(0L);
        Assert.assertNull((Object)this.subscriptions.committed(this.tp));
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        coordinator.ensureCoordinatorReady();
        this.time.sleep(this.retryBackoffMs);
        this.client.prepareResponse(this.offsetCommitResponse(Collections.singletonMap(this.tp, Errors.NONE.code())));
        this.consumerClient.poll(0L);
        Assert.assertEquals((long)100L, (long)this.subscriptions.committed(this.tp).offset());
    }

    @Test
    public void testCommitOffsetMetadata() {
        this.subscriptions.assignFromUser(Arrays.asList(this.tp));
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.coordinator.ensureCoordinatorReady();
        this.client.prepareResponse(this.offsetCommitResponse(Collections.singletonMap(this.tp, Errors.NONE.code())));
        AtomicBoolean success = new AtomicBoolean(false);
        this.coordinator.commitOffsetsAsync(Collections.singletonMap(this.tp, new OffsetAndMetadata(100L, "hello")), this.callback(success));
        Assert.assertTrue((boolean)success.get());
        Assert.assertEquals((long)100L, (long)this.subscriptions.committed(this.tp).offset());
        Assert.assertEquals((Object)"hello", (Object)this.subscriptions.committed(this.tp).metadata());
    }

    @Test
    public void testCommitOffsetAsyncWithDefaultCallback() {
        int invokedBeforeTest = this.defaultOffsetCommitCallback.invoked;
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.coordinator.ensureCoordinatorReady();
        this.client.prepareResponse(this.offsetCommitResponse(Collections.singletonMap(this.tp, Errors.NONE.code())));
        this.coordinator.commitOffsetsAsync(Collections.singletonMap(this.tp, new OffsetAndMetadata(100L)), null);
        Assert.assertEquals((long)(invokedBeforeTest + 1), (long)this.defaultOffsetCommitCallback.invoked);
        Assert.assertNull((Object)this.defaultOffsetCommitCallback.exception);
    }

    @Test
    public void testCommitAfterLeaveGroup() {
        this.subscriptions.subscribe(Arrays.asList(this.topicName), (ConsumerRebalanceListener)this.rebalanceListener);
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.coordinator.ensureCoordinatorReady();
        this.client.prepareResponse(this.joinGroupFollowerResponse(1, "consumer", "leader", Errors.NONE.code()));
        this.client.prepareResponse(this.syncGroupResponse(Arrays.asList(this.tp), Errors.NONE.code()));
        this.coordinator.ensurePartitionAssignment();
        this.client.prepareResponse(new LeaveGroupResponse(Errors.NONE.code()).toStruct());
        this.subscriptions.unsubscribe();
        this.coordinator.maybeLeaveGroup();
        this.subscriptions.assignFromUser(Arrays.asList(this.tp));
        this.client.prepareResponse(new MockClient.RequestMatcher(){

            @Override
            public boolean matches(ClientRequest request) {
                OffsetCommitRequest commitRequest = new OffsetCommitRequest(request.request().body());
                return commitRequest.memberId().equals("") && commitRequest.generationId() == -1;
            }
        }, this.offsetCommitResponse(Collections.singletonMap(this.tp, Errors.NONE.code())));
        AtomicBoolean success = new AtomicBoolean(false);
        this.coordinator.commitOffsetsAsync(Collections.singletonMap(this.tp, new OffsetAndMetadata(100L)), this.callback(success));
        Assert.assertTrue((boolean)success.get());
    }

    @Test
    public void testCommitOffsetAsyncFailedWithDefaultCallback() {
        int invokedBeforeTest = this.defaultOffsetCommitCallback.invoked;
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.coordinator.ensureCoordinatorReady();
        this.client.prepareResponse(this.offsetCommitResponse(Collections.singletonMap(this.tp, Errors.GROUP_COORDINATOR_NOT_AVAILABLE.code())));
        this.coordinator.commitOffsetsAsync(Collections.singletonMap(this.tp, new OffsetAndMetadata(100L)), null);
        Assert.assertEquals((long)(invokedBeforeTest + 1), (long)this.defaultOffsetCommitCallback.invoked);
        Assert.assertTrue((boolean)(this.defaultOffsetCommitCallback.exception instanceof RetriableCommitFailedException));
    }

    @Test
    public void testCommitOffsetAsyncCoordinatorNotAvailable() {
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.coordinator.ensureCoordinatorReady();
        MockCommitCallback cb = new MockCommitCallback();
        this.client.prepareResponse(this.offsetCommitResponse(Collections.singletonMap(this.tp, Errors.GROUP_COORDINATOR_NOT_AVAILABLE.code())));
        this.coordinator.commitOffsetsAsync(Collections.singletonMap(this.tp, new OffsetAndMetadata(100L)), (OffsetCommitCallback)cb);
        Assert.assertTrue((boolean)this.coordinator.coordinatorUnknown());
        Assert.assertEquals((long)1L, (long)cb.invoked);
        Assert.assertTrue((boolean)(cb.exception instanceof RetriableCommitFailedException));
    }

    @Test
    public void testCommitOffsetAsyncNotCoordinator() {
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.coordinator.ensureCoordinatorReady();
        MockCommitCallback cb = new MockCommitCallback();
        this.client.prepareResponse(this.offsetCommitResponse(Collections.singletonMap(this.tp, Errors.NOT_COORDINATOR_FOR_GROUP.code())));
        this.coordinator.commitOffsetsAsync(Collections.singletonMap(this.tp, new OffsetAndMetadata(100L)), (OffsetCommitCallback)cb);
        Assert.assertTrue((boolean)this.coordinator.coordinatorUnknown());
        Assert.assertEquals((long)1L, (long)cb.invoked);
        Assert.assertTrue((boolean)(cb.exception instanceof RetriableCommitFailedException));
    }

    @Test
    public void testCommitOffsetAsyncDisconnected() {
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.coordinator.ensureCoordinatorReady();
        MockCommitCallback cb = new MockCommitCallback();
        this.client.prepareResponse(this.offsetCommitResponse(Collections.singletonMap(this.tp, Errors.NONE.code())), true);
        this.coordinator.commitOffsetsAsync(Collections.singletonMap(this.tp, new OffsetAndMetadata(100L)), (OffsetCommitCallback)cb);
        Assert.assertTrue((boolean)this.coordinator.coordinatorUnknown());
        Assert.assertEquals((long)1L, (long)cb.invoked);
        Assert.assertTrue((boolean)(cb.exception instanceof RetriableCommitFailedException));
    }

    @Test
    public void testCommitOffsetSyncNotCoordinator() {
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.coordinator.ensureCoordinatorReady();
        this.client.prepareResponse(this.offsetCommitResponse(Collections.singletonMap(this.tp, Errors.NOT_COORDINATOR_FOR_GROUP.code())));
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.client.prepareResponse(this.offsetCommitResponse(Collections.singletonMap(this.tp, Errors.NONE.code())));
        this.coordinator.commitOffsetsSync(Collections.singletonMap(this.tp, new OffsetAndMetadata(100L)));
    }

    @Test
    public void testCommitOffsetSyncCoordinatorNotAvailable() {
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.coordinator.ensureCoordinatorReady();
        this.client.prepareResponse(this.offsetCommitResponse(Collections.singletonMap(this.tp, Errors.GROUP_COORDINATOR_NOT_AVAILABLE.code())));
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.client.prepareResponse(this.offsetCommitResponse(Collections.singletonMap(this.tp, Errors.NONE.code())));
        this.coordinator.commitOffsetsSync(Collections.singletonMap(this.tp, new OffsetAndMetadata(100L)));
    }

    @Test
    public void testCommitOffsetSyncCoordinatorDisconnected() {
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.coordinator.ensureCoordinatorReady();
        this.client.prepareResponse(this.offsetCommitResponse(Collections.singletonMap(this.tp, Errors.NONE.code())), true);
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.client.prepareResponse(this.offsetCommitResponse(Collections.singletonMap(this.tp, Errors.NONE.code())));
        this.coordinator.commitOffsetsSync(Collections.singletonMap(this.tp, new OffsetAndMetadata(100L)));
    }

    @Test(expected=OffsetMetadataTooLarge.class)
    public void testCommitOffsetMetadataTooLarge() {
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.coordinator.ensureCoordinatorReady();
        this.client.prepareResponse(this.offsetCommitResponse(Collections.singletonMap(this.tp, Errors.OFFSET_METADATA_TOO_LARGE.code())));
        this.coordinator.commitOffsetsSync(Collections.singletonMap(this.tp, new OffsetAndMetadata(100L, "metadata")));
    }

    @Test(expected=CommitFailedException.class)
    public void testCommitOffsetIllegalGeneration() {
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.coordinator.ensureCoordinatorReady();
        this.client.prepareResponse(this.offsetCommitResponse(Collections.singletonMap(this.tp, Errors.ILLEGAL_GENERATION.code())));
        this.coordinator.commitOffsetsSync(Collections.singletonMap(this.tp, new OffsetAndMetadata(100L, "metadata")));
    }

    @Test(expected=CommitFailedException.class)
    public void testCommitOffsetUnknownMemberId() {
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.coordinator.ensureCoordinatorReady();
        this.client.prepareResponse(this.offsetCommitResponse(Collections.singletonMap(this.tp, Errors.UNKNOWN_MEMBER_ID.code())));
        this.coordinator.commitOffsetsSync(Collections.singletonMap(this.tp, new OffsetAndMetadata(100L, "metadata")));
    }

    @Test(expected=CommitFailedException.class)
    public void testCommitOffsetRebalanceInProgress() {
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.coordinator.ensureCoordinatorReady();
        this.client.prepareResponse(this.offsetCommitResponse(Collections.singletonMap(this.tp, Errors.REBALANCE_IN_PROGRESS.code())));
        this.coordinator.commitOffsetsSync(Collections.singletonMap(this.tp, new OffsetAndMetadata(100L, "metadata")));
    }

    @Test(expected=KafkaException.class)
    public void testCommitOffsetSyncCallbackWithNonRetriableException() {
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.coordinator.ensureCoordinatorReady();
        this.client.prepareResponse(this.offsetCommitResponse(Collections.singletonMap(this.tp, Errors.UNKNOWN.code())), false);
        this.coordinator.commitOffsetsSync(Collections.singletonMap(this.tp, new OffsetAndMetadata(100L)));
    }

    @Test
    public void testRefreshOffset() {
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.coordinator.ensureCoordinatorReady();
        this.subscriptions.assignFromUser(Arrays.asList(this.tp));
        this.subscriptions.needRefreshCommits();
        this.client.prepareResponse(this.offsetFetchResponse(this.tp, Errors.NONE.code(), "", 100L));
        this.coordinator.refreshCommittedOffsetsIfNeeded();
        Assert.assertFalse((boolean)this.subscriptions.refreshCommitsNeeded());
        Assert.assertEquals((long)100L, (long)this.subscriptions.committed(this.tp).offset());
    }

    @Test
    public void testRefreshOffsetLoadInProgress() {
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.coordinator.ensureCoordinatorReady();
        this.subscriptions.assignFromUser(Arrays.asList(this.tp));
        this.subscriptions.needRefreshCommits();
        this.client.prepareResponse(this.offsetFetchResponse(this.tp, Errors.GROUP_LOAD_IN_PROGRESS.code(), "", 100L));
        this.client.prepareResponse(this.offsetFetchResponse(this.tp, Errors.NONE.code(), "", 100L));
        this.coordinator.refreshCommittedOffsetsIfNeeded();
        Assert.assertFalse((boolean)this.subscriptions.refreshCommitsNeeded());
        Assert.assertEquals((long)100L, (long)this.subscriptions.committed(this.tp).offset());
    }

    @Test
    public void testRefreshOffsetNotCoordinatorForConsumer() {
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.coordinator.ensureCoordinatorReady();
        this.subscriptions.assignFromUser(Arrays.asList(this.tp));
        this.subscriptions.needRefreshCommits();
        this.client.prepareResponse(this.offsetFetchResponse(this.tp, Errors.NOT_COORDINATOR_FOR_GROUP.code(), "", 100L));
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.client.prepareResponse(this.offsetFetchResponse(this.tp, Errors.NONE.code(), "", 100L));
        this.coordinator.refreshCommittedOffsetsIfNeeded();
        Assert.assertFalse((boolean)this.subscriptions.refreshCommitsNeeded());
        Assert.assertEquals((long)100L, (long)this.subscriptions.committed(this.tp).offset());
    }

    @Test
    public void testRefreshOffsetWithNoFetchableOffsets() {
        this.client.prepareResponse(this.consumerMetadataResponse(this.node, Errors.NONE.code()));
        this.coordinator.ensureCoordinatorReady();
        this.subscriptions.assignFromUser(Arrays.asList(this.tp));
        this.subscriptions.needRefreshCommits();
        this.client.prepareResponse(this.offsetFetchResponse(this.tp, Errors.NONE.code(), "", -1L));
        this.coordinator.refreshCommittedOffsetsIfNeeded();
        Assert.assertFalse((boolean)this.subscriptions.refreshCommitsNeeded());
        Assert.assertEquals(null, (Object)this.subscriptions.committed(this.tp));
    }

    @Test
    public void testProtocolMetadataOrder() {
        List metadata;
        ConsumerCoordinator coordinator;
        RoundRobinAssignor roundRobin = new RoundRobinAssignor();
        RangeAssignor range = new RangeAssignor();
        try (Metrics metrics = new Metrics((Time)this.time);){
            coordinator = this.buildCoordinator(metrics, Arrays.asList(roundRobin, range), true, false);
            metadata = coordinator.metadata();
            Assert.assertEquals((long)2L, (long)metadata.size());
            Assert.assertEquals((Object)roundRobin.name(), (Object)((JoinGroupRequest.ProtocolMetadata)metadata.get(0)).name());
            Assert.assertEquals((Object)range.name(), (Object)((JoinGroupRequest.ProtocolMetadata)metadata.get(1)).name());
        }
        metrics = new Metrics((Time)this.time);
        var4_4 = null;
        try {
            coordinator = this.buildCoordinator(metrics, Arrays.asList(range, roundRobin), true, false);
            metadata = coordinator.metadata();
            Assert.assertEquals((long)2L, (long)metadata.size());
            Assert.assertEquals((Object)range.name(), (Object)((JoinGroupRequest.ProtocolMetadata)metadata.get(0)).name());
            Assert.assertEquals((Object)roundRobin.name(), (Object)((JoinGroupRequest.ProtocolMetadata)metadata.get(1)).name());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (metrics != null) {
                if (var4_4 != null) {
                    try {
                        metrics.close();
                    }
                    catch (Throwable x2) {
                        var4_4.addSuppressed(x2);
                    }
                } else {
                    metrics.close();
                }
            }
        }
    }

    private ConsumerCoordinator buildCoordinator(Metrics metrics, List<PartitionAssignor> assignors, boolean excludeInternalTopics, boolean autoCommitEnabled) {
        return new ConsumerCoordinator(this.consumerClient, this.groupId, this.sessionTimeoutMs, this.heartbeatIntervalMs, assignors, this.metadata, this.subscriptions, metrics, "consumer" + this.groupId, (Time)this.time, this.retryBackoffMs, (OffsetCommitCallback)this.defaultOffsetCommitCallback, autoCommitEnabled, this.autoCommitIntervalMs, null, excludeInternalTopics);
    }

    private Struct consumerMetadataResponse(Node node, short error) {
        GroupCoordinatorResponse response = new GroupCoordinatorResponse(error, node);
        return response.toStruct();
    }

    private Struct heartbeatResponse(short error) {
        HeartbeatResponse response = new HeartbeatResponse(error);
        return response.toStruct();
    }

    private Struct joinGroupLeaderResponse(int generationId, String memberId, Map<String, List<String>> subscriptions, short error) {
        HashMap<String, ByteBuffer> metadata = new HashMap<String, ByteBuffer>();
        for (Map.Entry<String, List<String>> subscriptionEntry : subscriptions.entrySet()) {
            PartitionAssignor.Subscription subscription = new PartitionAssignor.Subscription(subscriptionEntry.getValue());
            ByteBuffer buf = ConsumerProtocol.serializeSubscription((PartitionAssignor.Subscription)subscription);
            metadata.put(subscriptionEntry.getKey(), buf);
        }
        return new JoinGroupResponse(error, generationId, this.partitionAssignor.name(), memberId, memberId, metadata).toStruct();
    }

    private Struct joinGroupFollowerResponse(int generationId, String memberId, String leaderId, short error) {
        return new JoinGroupResponse(error, generationId, this.partitionAssignor.name(), memberId, leaderId, Collections.emptyMap()).toStruct();
    }

    private Struct syncGroupResponse(List<TopicPartition> partitions, short error) {
        ByteBuffer buf = ConsumerProtocol.serializeAssignment((PartitionAssignor.Assignment)new PartitionAssignor.Assignment(partitions));
        return new SyncGroupResponse(error, buf).toStruct();
    }

    private Struct offsetCommitResponse(Map<TopicPartition, Short> responseData) {
        OffsetCommitResponse response = new OffsetCommitResponse(responseData);
        return response.toStruct();
    }

    private Struct offsetFetchResponse(TopicPartition tp, Short error, String metadata, long offset) {
        OffsetFetchResponse.PartitionData data = new OffsetFetchResponse.PartitionData(offset, metadata, error.shortValue());
        OffsetFetchResponse response = new OffsetFetchResponse(Collections.singletonMap(tp, data));
        return response.toStruct();
    }

    private OffsetCommitCallback callback(final AtomicBoolean success) {
        return new OffsetCommitCallback(){

            public void onComplete(Map<TopicPartition, OffsetAndMetadata> offsets, Exception exception) {
                if (exception == null) {
                    success.set(true);
                }
            }
        };
    }

    private static class MockRebalanceListener
    implements ConsumerRebalanceListener {
        public Collection<TopicPartition> revoked;
        public Collection<TopicPartition> assigned;
        public int revokedCount = 0;
        public int assignedCount = 0;

        private MockRebalanceListener() {
        }

        public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
            this.assigned = partitions;
            ++this.assignedCount;
        }

        public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            this.revoked = partitions;
            ++this.revokedCount;
        }
    }

    private static class MockCommitCallback
    implements OffsetCommitCallback {
        public int invoked = 0;
        public Exception exception = null;

        private MockCommitCallback() {
        }

        public void onComplete(Map<TopicPartition, OffsetAndMetadata> offsets, Exception exception) {
            ++this.invoked;
            this.exception = exception;
        }
    }
}

