/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.consumer.internals.AbstractCoordinator;
import org.apache.kafka.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.GroupCoordinatorResponse;
import org.apache.kafka.common.requests.JoinGroupRequest;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AbstractCoordinatorTest {
    private static final ByteBuffer EMPTY_DATA = ByteBuffer.wrap(new byte[0]);
    private static final int SESSION_TIMEOUT_MS = 30000;
    private static final int HEARTBEAT_INTERVAL_MS = 3000;
    private static final long RETRY_BACKOFF_MS = 100L;
    private static final long REQUEST_TIMEOUT_MS = 40000L;
    private static final String GROUP_ID = "dummy-group";
    private static final String METRIC_GROUP_PREFIX = "consumer";
    private MockClient mockClient;
    private MockTime mockTime;
    private Node node;
    private Node coordinatorNode;
    private ConsumerNetworkClient consumerClient;
    private DummyCoordinator coordinator;

    @Before
    public void setupCoordinator() {
        this.mockTime = new MockTime();
        this.mockClient = new MockClient(this.mockTime);
        Metadata metadata = new Metadata();
        this.consumerClient = new ConsumerNetworkClient((KafkaClient)this.mockClient, metadata, (Time)this.mockTime, 100L, 40000L);
        Metrics metrics = new Metrics();
        Cluster cluster = TestUtils.singletonCluster("topic", 1);
        metadata.update(cluster, this.mockTime.milliseconds());
        this.node = (Node)cluster.nodes().get(0);
        this.mockClient.setNode(this.node);
        this.coordinatorNode = new Node(Integer.MAX_VALUE - this.node.id(), this.node.host(), this.node.port());
        this.coordinator = new DummyCoordinator(this.consumerClient, metrics, this.mockTime);
    }

    @Test
    public void testCoordinatorDiscoveryBackoff() {
        this.mockClient.prepareResponse(this.groupCoordinatorResponse(this.node, Errors.NONE.code()));
        this.mockClient.prepareResponse(this.groupCoordinatorResponse(this.node, Errors.NONE.code()));
        this.mockClient.blackout(this.coordinatorNode, 50L);
        long initialTime = this.mockTime.milliseconds();
        this.coordinator.ensureCoordinatorReady();
        long endTime = this.mockTime.milliseconds();
        Assert.assertTrue((endTime - initialTime >= 100L ? 1 : 0) != 0);
    }

    private Struct groupCoordinatorResponse(Node node, short error) {
        GroupCoordinatorResponse response = new GroupCoordinatorResponse(error, node);
        return response.toStruct();
    }

    public class DummyCoordinator
    extends AbstractCoordinator {
        public DummyCoordinator(ConsumerNetworkClient client, Metrics metrics, Time time) {
            super(client, AbstractCoordinatorTest.GROUP_ID, 30000, 3000, metrics, AbstractCoordinatorTest.METRIC_GROUP_PREFIX, time, 100L);
        }

        protected String protocolType() {
            return "dummy";
        }

        protected List<JoinGroupRequest.ProtocolMetadata> metadata() {
            return Collections.singletonList(new JoinGroupRequest.ProtocolMetadata("dummy-subprotocol", EMPTY_DATA));
        }

        protected Map<String, ByteBuffer> performAssignment(String leaderId, String protocol, Map<String, ByteBuffer> allMemberMetadata) {
            HashMap<String, ByteBuffer> assignment = new HashMap<String, ByteBuffer>();
            for (Map.Entry<String, ByteBuffer> metadata : allMemberMetadata.entrySet()) {
                assignment.put(metadata.getKey(), EMPTY_DATA);
            }
            return assignment;
        }

        protected void onJoinPrepare(int generation, String memberId) {
        }

        protected void onJoinComplete(int generation, String memberId, String protocol, ByteBuffer memberAssignment) {
        }
    }
}

