/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.message;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.message.FieldSpec;
import org.apache.kafka.message.Versions;

public final class StructSpec {
    private final String name;
    private final Versions versions;
    private final Versions deprecatedVersions;
    private final List<FieldSpec> fields;
    private final boolean hasKeys;

    @JsonCreator
    public StructSpec(@JsonProperty(value="name") String name, @JsonProperty(value="versions") String versions, @JsonProperty(value="deprecatedVersions") String deprecatedVersions, @JsonProperty(value="fields") List<FieldSpec> fields) {
        this.name = Objects.requireNonNull(name);
        this.versions = Versions.parse(versions, null);
        if (this.versions == null) {
            throw new RuntimeException("You must specify the version of the " + name + " structure.");
        }
        this.deprecatedVersions = Versions.parse(deprecatedVersions, Versions.NONE);
        ArrayList<FieldSpec> newFields = new ArrayList<FieldSpec>();
        if (fields != null) {
            HashSet<Integer> tags = new HashSet<Integer>();
            for (FieldSpec field : fields) {
                if (field.tag().isPresent()) {
                    if (tags.contains(field.tag().get())) {
                        throw new RuntimeException("In " + name + ", field " + field.name() + " has a duplicate tag ID " + field.tag().get() + ".  All tags IDs must be unique.");
                    }
                    tags.add(field.tag().get());
                }
                newFields.add(field);
            }
            for (int i = 0; i < tags.size(); ++i) {
                if (tags.contains(i)) continue;
                throw new RuntimeException("In " + name + ", the tag IDs are not contiguous.  Make use of tag " + i + " before using any higher tag IDs.");
            }
        }
        this.fields = Collections.unmodifiableList(newFields);
        this.hasKeys = this.fields.stream().anyMatch(f -> f.mapKey());
    }

    @JsonProperty
    public String name() {
        return this.name;
    }

    public Versions versions() {
        return this.versions;
    }

    @JsonProperty
    public String versionsString() {
        return this.versions.toString();
    }

    public Versions deprecatedVersions() {
        return this.deprecatedVersions;
    }

    @JsonProperty
    public List<FieldSpec> fields() {
        return this.fields;
    }

    boolean hasKeys() {
        return this.hasKeys;
    }
}

