/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.runtime.ConnectorConfig;
import org.apache.kafka.connect.runtime.TopicCreationConfig;
import org.apache.kafka.connect.runtime.isolation.Plugins;
import org.apache.kafka.connect.source.SourceTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceConnectorConfig
extends ConnectorConfig {
    private static final Logger log = LoggerFactory.getLogger(SourceConnectorConfig.class);
    protected static final String TOPIC_CREATION_GROUP = "Topic Creation";
    public static final String TOPIC_CREATION_PREFIX = "topic.creation.";
    public static final String TOPIC_CREATION_GROUPS_CONFIG = "topic.creation.groups";
    private static final String TOPIC_CREATION_GROUPS_DOC = "Groups of configurations for topics created by source connectors";
    private static final String TOPIC_CREATION_GROUPS_DISPLAY = "Topic Creation Groups";
    protected static final String EXACTLY_ONCE_SUPPORT_GROUP = "Exactly Once Support";
    public static final String EXACTLY_ONCE_SUPPORT_CONFIG = "exactly.once.support";
    private static final String EXACTLY_ONCE_SUPPORT_DOC = "Permitted values are " + String.join((CharSequence)", ", Utils.enumOptions(ExactlyOnceSupportLevel.class)) + ". If set to \"" + (Object)((Object)ExactlyOnceSupportLevel.REQUIRED) + "\", forces a preflight check for the connector to ensure that it can provide exactly-once semantics with the given configuration. Some connectors may be capable of providing exactly-once semantics but not signal to Connect that they support this; in that case, documentation for the connector should be consulted carefully before creating it, and the value for this property should be set to \"" + (Object)((Object)ExactlyOnceSupportLevel.REQUESTED) + "\". Additionally, if the value is set to \"" + (Object)((Object)ExactlyOnceSupportLevel.REQUIRED) + "\" but the worker that performs preflight validation does not have exactly-once support enabled for source connectors, requests to create or validate the connector will fail.";
    private static final String EXACTLY_ONCE_SUPPORT_DISPLAY = "Exactly once support";
    public static final String TRANSACTION_BOUNDARY_CONFIG = "transaction.boundary";
    private static final String TRANSACTION_BOUNDARY_DOC = "Permitted values are: " + String.join((CharSequence)", ", Utils.enumOptions(SourceTask.TransactionBoundary.class)) + ". If set to '" + SourceTask.TransactionBoundary.POLL + "', a new producer transaction will be started and committed for every batch of records that each task from this connector provides to Connect. If set to '" + SourceTask.TransactionBoundary.CONNECTOR + "', relies on connector-defined transaction boundaries; note that not all connectors are capable of defining their own transaction boundaries, and in that case, attempts to instantiate a connector with this value will fail. Finally, if set to '" + SourceTask.TransactionBoundary.INTERVAL + "', commits transactions only after a user-defined time interval has passed.";
    private static final String TRANSACTION_BOUNDARY_DISPLAY = "Transaction Boundary";
    public static final String TRANSACTION_BOUNDARY_INTERVAL_CONFIG = "transaction.boundary.interval.ms";
    private static final String TRANSACTION_BOUNDARY_INTERVAL_DOC = "If 'transaction.boundary' is set to '" + SourceTask.TransactionBoundary.INTERVAL + "', determines the interval for producer transaction commits by connector tasks. If unset, defaults to the value of the worker-level '" + "offset.flush.interval.ms" + "' property. It has no effect if a different " + "transaction.boundary" + " is specified.";
    private static final String TRANSACTION_BOUNDARY_INTERVAL_DISPLAY = "Transaction boundary interval";
    protected static final String OFFSETS_TOPIC_GROUP = "offsets.topic";
    public static final String OFFSETS_TOPIC_CONFIG = "offsets.storage.topic";
    private static final String OFFSETS_TOPIC_DOC = "The name of a separate offsets topic to use for this connector. If empty or not specified, the worker\u2019s global offsets topic name will be used. If specified, the offsets topic will be created if it does not already exist on the Kafka cluster targeted by this connector (which may be different from the one used for the worker's global offsets topic if the bootstrap.servers property of the connector's producer has been overridden from the worker's). Only applicable in distributed mode; in standalone mode, setting this property will have no effect.";
    private static final String OFFSETS_TOPIC_DISPLAY = "Offsets topic";
    private final SourceTask.TransactionBoundary transactionBoundary;
    private final Long transactionBoundaryInterval;
    private final EnrichedSourceConnectorConfig enrichedSourceConfig;
    private final String offsetsTopic;

    public static ConfigDef configDef() {
        ConfigDef.Range atLeastZero = ConfigDef.Range.atLeast((Number)0);
        int orderInGroup = 0;
        ConfigDef configDef = new ConfigDef(ConnectorConfig.configDef()).define(TOPIC_CREATION_GROUPS_CONFIG, ConfigDef.Type.LIST, Collections.emptyList(), (ConfigDef.Validator)ConfigDef.CompositeValidator.of((ConfigDef.Validator[])new ConfigDef.Validator[]{new ConfigDef.NonNullValidator(), ConfigDef.LambdaValidator.with((name, value) -> {
            List groupAliases = (List)value;
            if (groupAliases.size() > new HashSet(groupAliases).size()) {
                throw new ConfigException(name, value, "Duplicate alias provided.");
            }
        }, () -> "unique topic creation groups")}), ConfigDef.Importance.LOW, TOPIC_CREATION_GROUPS_DOC, TOPIC_CREATION_GROUP, ++orderInGroup, ConfigDef.Width.LONG, TOPIC_CREATION_GROUPS_DISPLAY).define(EXACTLY_ONCE_SUPPORT_CONFIG, ConfigDef.Type.STRING, (Object)ExactlyOnceSupportLevel.REQUESTED.toString(), (ConfigDef.Validator)ConfigDef.CaseInsensitiveValidString.in((String[])Utils.enumOptions(ExactlyOnceSupportLevel.class)), ConfigDef.Importance.MEDIUM, EXACTLY_ONCE_SUPPORT_DOC, EXACTLY_ONCE_SUPPORT_GROUP, ++orderInGroup, ConfigDef.Width.SHORT, EXACTLY_ONCE_SUPPORT_DISPLAY).define(TRANSACTION_BOUNDARY_CONFIG, ConfigDef.Type.STRING, (Object)SourceTask.TransactionBoundary.DEFAULT.toString(), (ConfigDef.Validator)ConfigDef.CaseInsensitiveValidString.in((String[])Utils.enumOptions(SourceTask.TransactionBoundary.class)), ConfigDef.Importance.MEDIUM, TRANSACTION_BOUNDARY_DOC, EXACTLY_ONCE_SUPPORT_GROUP, ++orderInGroup, ConfigDef.Width.SHORT, TRANSACTION_BOUNDARY_DISPLAY);
        ConfigDef configDef2 = configDef.define(TRANSACTION_BOUNDARY_INTERVAL_CONFIG, ConfigDef.Type.LONG, null, (ConfigDef.Validator)ConfigDef.LambdaValidator.with((arg_0, arg_1) -> SourceConnectorConfig.lambda$configDef$2((ConfigDef.Validator)atLeastZero, arg_0, arg_1), ((ConfigDef.Validator)atLeastZero)::toString), ConfigDef.Importance.LOW, TRANSACTION_BOUNDARY_INTERVAL_DOC, EXACTLY_ONCE_SUPPORT_GROUP, ++orderInGroup, ConfigDef.Width.SHORT, TRANSACTION_BOUNDARY_INTERVAL_DISPLAY);
        orderInGroup = 1;
        return configDef2.define(OFFSETS_TOPIC_CONFIG, ConfigDef.Type.STRING, null, (ConfigDef.Validator)new ConfigDef.NonEmptyString(), ConfigDef.Importance.LOW, OFFSETS_TOPIC_DOC, OFFSETS_TOPIC_GROUP, 1, ConfigDef.Width.LONG, OFFSETS_TOPIC_DISPLAY);
    }

    public static ConfigDef embedDefaultGroup(ConfigDef baseConfigDef) {
        String defaultGroup = "default";
        ConfigDef newDefaultDef = new ConfigDef(baseConfigDef);
        newDefaultDef.embed("topic.creation.default.", defaultGroup, 0, TopicCreationConfig.defaultGroupConfigDef());
        return newDefaultDef;
    }

    public static ConfigDef enrich(ConfigDef baseConfigDef, Map<String, String> props, AbstractConfig defaultGroupConfig) {
        ArrayList topicCreationGroups = new ArrayList();
        Object aliases = ConfigDef.parseType((String)TOPIC_CREATION_GROUPS_CONFIG, (Object)props.get(TOPIC_CREATION_GROUPS_CONFIG), (ConfigDef.Type)ConfigDef.Type.LIST);
        if (aliases instanceof List) {
            topicCreationGroups.addAll((List)aliases);
        }
        if (topicCreationGroups.contains("default")) {
            log.warn("'{}' topic creation group always exists and does not need to be listed explicitly", (Object)"default");
            topicCreationGroups.removeAll(Collections.singleton("default"));
        }
        ConfigDef newDef = new ConfigDef(baseConfigDef);
        String defaultGroupPrefix = "topic.creation.default.";
        short defaultGroupReplicationFactor = defaultGroupConfig.getShort(defaultGroupPrefix + "replication.factor");
        int defaultGroupPartitions = defaultGroupConfig.getInt(defaultGroupPrefix + "partitions");
        topicCreationGroups.stream().distinct().forEach(group -> {
            if (!(group instanceof String)) {
                throw new ConfigException("Item in topic.creation.groups property is not of type String");
            }
            String alias = (String)group;
            String prefix = TOPIC_CREATION_PREFIX + alias + ".";
            String configGroup = "Topic Creation: " + alias;
            newDef.embed(prefix, configGroup, 0, TopicCreationConfig.configDef(configGroup, defaultGroupReplicationFactor, defaultGroupPartitions));
        });
        return newDef;
    }

    public SourceConnectorConfig(Plugins plugins, Map<String, String> props, boolean createTopics) {
        super(plugins, SourceConnectorConfig.configDef(), props);
        if (createTopics && props.entrySet().stream().anyMatch(e -> ((String)e.getKey()).startsWith(TOPIC_CREATION_PREFIX))) {
            ConfigDef defaultConfigDef = SourceConnectorConfig.embedDefaultGroup(SourceConnectorConfig.configDef());
            AbstractConfig defaultGroup = new AbstractConfig(defaultConfigDef, props, false);
            HashMap<String, String> propsWithoutRegexForDefaultGroup = new HashMap<String, String>(props);
            propsWithoutRegexForDefaultGroup.entrySet().removeIf(e -> ((String)e.getKey()).equals("topic.creation.default.include") || ((String)e.getKey()).equals("topic.creation.default.exclude"));
            this.enrichedSourceConfig = new EnrichedSourceConnectorConfig(plugins, SourceConnectorConfig.enrich(defaultConfigDef, props, defaultGroup), propsWithoutRegexForDefaultGroup);
        } else {
            this.enrichedSourceConfig = null;
        }
        this.transactionBoundary = SourceTask.TransactionBoundary.fromProperty((String)this.getString(TRANSACTION_BOUNDARY_CONFIG));
        this.transactionBoundaryInterval = this.getLong(TRANSACTION_BOUNDARY_INTERVAL_CONFIG);
        this.offsetsTopic = this.getString(OFFSETS_TOPIC_CONFIG);
    }

    public static boolean usesTopicCreation(Map<String, String> props) {
        return props.entrySet().stream().anyMatch(e -> ((String)e.getKey()).startsWith(TOPIC_CREATION_PREFIX));
    }

    @Override
    public Object get(String key) {
        return this.enrichedSourceConfig != null ? this.enrichedSourceConfig.get(key) : super.get(key);
    }

    public SourceTask.TransactionBoundary transactionBoundary() {
        return this.transactionBoundary;
    }

    public Long transactionBoundaryInterval() {
        return this.transactionBoundaryInterval;
    }

    public String offsetsTopic() {
        return this.offsetsTopic;
    }

    public boolean usesTopicCreation() {
        return this.enrichedSourceConfig != null;
    }

    public List<String> topicCreationInclude(String group) {
        return this.getList(TOPIC_CREATION_PREFIX + group + '.' + "include");
    }

    public List<String> topicCreationExclude(String group) {
        return this.getList(TOPIC_CREATION_PREFIX + group + '.' + "exclude");
    }

    public Short topicCreationReplicationFactor(String group) {
        return this.getShort(TOPIC_CREATION_PREFIX + group + '.' + "replication.factor");
    }

    public Integer topicCreationPartitions(String group) {
        return this.getInt(TOPIC_CREATION_PREFIX + group + '.' + "partitions");
    }

    public Map<String, Object> topicCreationOtherConfigs(String group) {
        if (this.enrichedSourceConfig == null) {
            return Collections.emptyMap();
        }
        return this.enrichedSourceConfig.originalsWithPrefix(TOPIC_CREATION_PREFIX + group + '.').entrySet().stream().filter(e -> {
            String key = (String)e.getKey();
            return !"include".equals(key) && !"exclude".equals(key) && !"replication.factor".equals(key) && !"partitions".equals(key);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static void main(String[] args) {
        System.out.println(SourceConnectorConfig.configDef().toHtml(4, config -> "sourceconnectorconfigs_" + config));
    }

    private static /* synthetic */ void lambda$configDef$2(ConfigDef.Validator atLeastZero, String name, Object value) {
        if (value == null) {
            return;
        }
        atLeastZero.ensureValid(name, value);
    }

    private static class EnrichedSourceConnectorConfig
    extends ConnectorConfig {
        EnrichedSourceConnectorConfig(Plugins plugins, ConfigDef configDef, Map<String, String> props) {
            super(plugins, configDef, props);
        }

        @Override
        public Object get(String key) {
            return super.get(key);
        }
    }

    public static enum ExactlyOnceSupportLevel {
        REQUESTED,
        REQUIRED;


        public static ExactlyOnceSupportLevel fromProperty(String property) {
            return ExactlyOnceSupportLevel.valueOf(property.toUpperCase(Locale.ROOT).trim());
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

