/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.runtime.errors.RetryWithToleranceOperator;
import org.apache.kafka.connect.runtime.errors.Stage;
import org.apache.kafka.connect.transforms.Transformation;

public class TransformationChain<R extends ConnectRecord<R>> {
    private final List<Transformation<R>> transformations;
    private final RetryWithToleranceOperator retryWithToleranceOperator;

    public TransformationChain(List<Transformation<R>> transformations, RetryWithToleranceOperator retryWithToleranceOperator) {
        this.transformations = transformations;
        this.retryWithToleranceOperator = retryWithToleranceOperator;
    }

    public R apply(R record) {
        R current;
        Transformation<R> transformation;
        if (this.transformations.isEmpty()) {
            return record;
        }
        Iterator<Transformation<R>> iterator = this.transformations.iterator();
        while (iterator.hasNext() && (record = (ConnectRecord)this.retryWithToleranceOperator.execute(() -> TransformationChain.lambda$apply$0(transformation = iterator.next(), current = record), Stage.TRANSFORMATION, transformation.getClass())) != null) {
        }
        return record;
    }

    public void close() {
        for (Transformation<R> transformation : this.transformations) {
            transformation.close();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransformationChain that = (TransformationChain)o;
        return Objects.equals(this.transformations, that.transformations);
    }

    public int hashCode() {
        return Objects.hash(this.transformations);
    }

    private static /* synthetic */ ConnectRecord lambda$apply$0(Transformation transformation, ConnectRecord connectRecord) throws Exception {
        return transformation.apply(connectRecord);
    }
}

