/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.isolation;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import org.apache.kafka.connect.runtime.isolation.PluginDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginUtils {
    private static final Logger log = LoggerFactory.getLogger(PluginUtils.class);
    private static final String BLACKLIST = "^(?:java|javax\\.accessibility|javax\\.activation|javax\\.activity|javax\\.annotation|javax\\.batch\\.api|javax\\.batch\\.operations|javax\\.batch\\.runtime|javax\\.crypto|javax\\.decorator|javax\\.ejb|javax\\.el|javax\\.enterprise\\.concurrent|javax\\.enterprise\\.context|javax\\.enterprise\\.context\\.spi|javax\\.enterprise\\.deploy\\.model|javax\\.enterprise\\.deploy\\.shared|javax\\.enterprise\\.deploy\\.spi|javax\\.enterprise\\.event|javax\\.enterprise\\.inject|javax\\.enterprise\\.inject\\.spi|javax\\.enterprise\\.util|javax\\.faces|javax\\.imageio|javax\\.inject|javax\\.interceptor|javax\\.jms|javax\\.json|javax\\.jws|javax\\.lang\\.model|javax\\.mail|javax\\.management|javax\\.management\\.j2ee|javax\\.naming|javax\\.net|javax\\.persistence|javax\\.print|javax\\.resource|javax\\.rmi|javax\\.script|javax\\.security\\.auth|javax\\.security\\.auth\\.message|javax\\.security\\.cert|javax\\.security\\.jacc|javax\\.security\\.sasl|javax\\.servlet|javax\\.sound\\.midi|javax\\.sound\\.sampled|javax\\.sql|javax\\.swing|javax\\.tools|javax\\.transaction|javax\\.validation|javax\\.websocket|javax\\.ws\\.rs|javax\\.xml|javax\\.xml\\.bind|javax\\.xml\\.registry|javax\\.xml\\.rpc|javax\\.xml\\.soap|javax\\.xml\\.ws|org\\.ietf\\.jgss|org\\.omg\\.CORBA|org\\.omg\\.CosNaming|org\\.omg\\.Dynamic|org\\.omg\\.DynamicAny|org\\.omg\\.IOP|org\\.omg\\.Messaging|org\\.omg\\.PortableInterceptor|org\\.omg\\.PortableServer|org\\.omg\\.SendingContext|org\\.omg\\.stub\\.java\\.rmi|org\\.w3c\\.dom|org\\.xml\\.sax|org\\.apache\\.kafka|org\\.slf4j)\\..*$";
    private static final String WHITELIST = "^org\\.apache\\.kafka\\.(?:connect\\.(?:transforms\\.(?!Transformation$).*|json\\..*|file\\..*|converters\\..*|storage\\.StringConverter|storage\\.SimpleHeaderConverter|rest\\.basic\\.auth\\.extension\\.BasicAuthSecurityRestExtension)|common\\.config\\.provider\\.(?!ConfigProvider$).*)$";
    private static final DirectoryStream.Filter<Path> PLUGIN_PATH_FILTER = new DirectoryStream.Filter<Path>(){

        @Override
        public boolean accept(Path path) {
            return Files.isDirectory(path, new LinkOption[0]) || PluginUtils.isArchive(path) || PluginUtils.isClassFile(path);
        }
    };

    public static boolean shouldLoadInIsolation(String name) {
        return !name.matches(BLACKLIST) || name.matches(WHITELIST);
    }

    public static boolean isConcrete(Class<?> klass) {
        int mod = klass.getModifiers();
        return !Modifier.isAbstract(mod) && !Modifier.isInterface(mod);
    }

    public static boolean isArchive(Path path) {
        String archivePath = path.toString().toLowerCase(Locale.ROOT);
        return archivePath.endsWith(".jar") || archivePath.endsWith(".zip");
    }

    public static boolean isClassFile(Path path) {
        return path.toString().toLowerCase(Locale.ROOT).endsWith(".class");
    }

    public static List<Path> pluginLocations(Path topPath) throws IOException {
        ArrayList<Path> locations = new ArrayList<Path>();
        try (DirectoryStream<Path> listing = Files.newDirectoryStream(topPath, PLUGIN_PATH_FILTER);){
            for (Path dir : listing) {
                locations.add(dir);
            }
        }
        return locations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Path> pluginUrls(Path topPath) throws IOException {
        boolean containsClassFiles = false;
        TreeSet<Path> archives = new TreeSet<Path>();
        LinkedList<DirectoryEntry> dfs = new LinkedList<DirectoryEntry>();
        HashSet<Path> visited = new HashSet<Path>();
        if (PluginUtils.isArchive(topPath)) {
            return Collections.singletonList(topPath);
        }
        DirectoryStream<Path> topListing = Files.newDirectoryStream(topPath, PLUGIN_PATH_FILTER);
        dfs.push(new DirectoryEntry(topListing));
        visited.add(topPath);
        try {
            while (!dfs.isEmpty()) {
                Iterator<Path> neighbors = ((DirectoryEntry)dfs.peek()).iterator;
                if (!neighbors.hasNext()) {
                    ((DirectoryEntry)dfs.pop()).stream.close();
                    continue;
                }
                Path adjacent = neighbors.next();
                if (Files.isSymbolicLink(adjacent)) {
                    try {
                        Path absolute;
                        Path symlink = Files.readSymbolicLink(adjacent);
                        Path parent = adjacent.getParent();
                        if (parent == null || !Files.exists(absolute = parent.resolve(symlink).toRealPath(new LinkOption[0]), new LinkOption[0])) continue;
                        adjacent = absolute;
                    }
                    catch (IOException e) {
                        log.warn("Resolving symbolic link '{}' failed. Ignoring this path.", (Object)adjacent, (Object)e);
                        continue;
                    }
                }
                if (visited.contains(adjacent)) continue;
                visited.add(adjacent);
                if (PluginUtils.isArchive(adjacent)) {
                    archives.add(adjacent);
                    continue;
                }
                if (PluginUtils.isClassFile(adjacent)) {
                    containsClassFiles = true;
                    continue;
                }
                DirectoryStream<Path> listing = Files.newDirectoryStream(adjacent, PLUGIN_PATH_FILTER);
                dfs.push(new DirectoryEntry(listing));
            }
        }
        finally {
            while (!dfs.isEmpty()) {
                ((DirectoryEntry)dfs.pop()).stream.close();
            }
        }
        if (containsClassFiles) {
            if (archives.isEmpty()) {
                return Collections.singletonList(topPath);
            }
            log.warn("Plugin path contains both java archives and class files. Returning only the archives");
        }
        return Arrays.asList(archives.toArray(new Path[0]));
    }

    public static String simpleName(PluginDesc<?> plugin) {
        return plugin.pluginClass().getSimpleName();
    }

    public static String prunedName(PluginDesc<?> plugin) {
        switch (plugin.type()) {
            case SOURCE: 
            case SINK: 
            case CONNECTOR: {
                return PluginUtils.prunePluginName(plugin, "Connector");
            }
        }
        return PluginUtils.prunePluginName(plugin, plugin.type().simpleName());
    }

    public static <U> boolean isAliasUnique(PluginDesc<U> alias, Collection<PluginDesc<U>> plugins) {
        boolean matched = false;
        for (PluginDesc<U> plugin : plugins) {
            if (!PluginUtils.simpleName(alias).equals(PluginUtils.simpleName(plugin)) && !PluginUtils.prunedName(alias).equals(PluginUtils.prunedName(plugin))) continue;
            if (matched) {
                return false;
            }
            matched = true;
        }
        return true;
    }

    private static String prunePluginName(PluginDesc<?> plugin, String suffix) {
        String simple = plugin.pluginClass().getSimpleName();
        int pos = simple.lastIndexOf(suffix);
        if (pos > 0) {
            return simple.substring(0, pos);
        }
        return simple;
    }

    private static class DirectoryEntry {
        final DirectoryStream<Path> stream;
        final Iterator<Path> iterator;

        DirectoryEntry(DirectoryStream<Path> stream) {
            this.stream = stream;
            this.iterator = stream.iterator();
        }
    }
}

