/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.errors;

import org.apache.kafka.connect.runtime.ConnectorConfig;
import org.apache.kafka.connect.runtime.errors.ErrorHandlingMetrics;
import org.apache.kafka.connect.runtime.errors.ErrorReporter;
import org.apache.kafka.connect.runtime.errors.ProcessingContext;
import org.apache.kafka.connect.util.ConnectorTaskId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogReporter
implements ErrorReporter {
    private static final Logger log = LoggerFactory.getLogger(LogReporter.class);
    private final ConnectorTaskId id;
    private final ConnectorConfig connConfig;
    private ErrorHandlingMetrics errorHandlingMetrics;

    public LogReporter(ConnectorTaskId id, ConnectorConfig connConfig) {
        this.id = id;
        this.connConfig = connConfig;
    }

    @Override
    public void report(ProcessingContext context) {
        if (!this.connConfig.enableErrorLog()) {
            return;
        }
        if (!context.failed()) {
            return;
        }
        log.error(this.message(context), context.error());
        this.errorHandlingMetrics.recordErrorLogged();
    }

    @Override
    public void metrics(ErrorHandlingMetrics errorHandlingMetrics) {
        this.errorHandlingMetrics = errorHandlingMetrics;
    }

    String message(ProcessingContext context) {
        return String.format("Error encountered in task %s. %s", String.valueOf(this.id), context.toString(this.connConfig.includeRecordDetailsInErrorLog()));
    }
}

