/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.storage;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.connect.runtime.AbstractStatus;
import org.apache.kafka.connect.runtime.ConnectorStatus;
import org.apache.kafka.connect.runtime.TaskStatus;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.storage.StatusBackingStore;
import org.apache.kafka.connect.util.ConnectorTaskId;
import org.apache.kafka.connect.util.Table;

public class MemoryStatusBackingStore
implements StatusBackingStore {
    private final Table<String, Integer, TaskStatus> tasks = new Table();
    private final Map<String, ConnectorStatus> connectors = new HashMap<String, ConnectorStatus>();

    @Override
    public void configure(WorkerConfig config) {
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public synchronized void put(ConnectorStatus status) {
        if (status.state() == AbstractStatus.State.DESTROYED) {
            this.connectors.remove(status.id());
        } else {
            this.connectors.put((String)status.id(), status);
        }
    }

    @Override
    public synchronized void putSafe(ConnectorStatus status) {
        this.put(status);
    }

    @Override
    public synchronized void put(TaskStatus status) {
        if (status.state() == AbstractStatus.State.DESTROYED) {
            this.tasks.remove(((ConnectorTaskId)status.id()).connector(), ((ConnectorTaskId)status.id()).task());
        } else {
            this.tasks.put(((ConnectorTaskId)status.id()).connector(), ((ConnectorTaskId)status.id()).task(), status);
        }
    }

    @Override
    public synchronized void putSafe(TaskStatus status) {
        this.put(status);
    }

    @Override
    public synchronized TaskStatus get(ConnectorTaskId id) {
        return this.tasks.get(id.connector(), id.task());
    }

    @Override
    public synchronized ConnectorStatus get(String connector) {
        return this.connectors.get(connector);
    }

    @Override
    public synchronized Collection<TaskStatus> getAll(String connector) {
        return new HashSet<TaskStatus>(this.tasks.row(connector).values());
    }

    @Override
    public synchronized Set<String> connectors() {
        return new HashSet<String>(this.connectors.keySet());
    }

    @Override
    public void flush() {
    }
}

