/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.isolation;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.connector.Connector;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.runtime.isolation.DelegatingClassLoader;
import org.apache.kafka.connect.runtime.isolation.PluginDesc;
import org.apache.kafka.connect.storage.Converter;
import org.apache.kafka.connect.storage.ConverterType;
import org.apache.kafka.connect.storage.HeaderConverter;
import org.apache.kafka.connect.transforms.Transformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Plugins {
    private static final Logger log = LoggerFactory.getLogger(Plugins.class);
    private final DelegatingClassLoader delegatingLoader;

    public Plugins(Map<String, String> props) {
        List<String> pluginLocations = WorkerConfig.pluginLocations(props);
        this.delegatingLoader = Plugins.newDelegatingClassLoader(pluginLocations);
        this.delegatingLoader.initLoaders();
    }

    private static DelegatingClassLoader newDelegatingClassLoader(final List<String> paths) {
        return (DelegatingClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new DelegatingClassLoader(paths);
            }
        });
    }

    private static <T> String pluginNames(Collection<PluginDesc<T>> plugins) {
        return Utils.join(plugins, (String)", ");
    }

    protected static <T> T newPlugin(Class<T> klass) {
        try {
            return (T)Utils.newInstance(klass);
        }
        catch (Throwable t) {
            throw new ConnectException("Instantiation error", t);
        }
    }

    protected static <U> Class<? extends U> pluginClass(DelegatingClassLoader loader, String classOrAlias, Class<U> pluginClass) throws ClassNotFoundException {
        Class<?> klass = loader.loadClass(classOrAlias, false);
        if (pluginClass.isAssignableFrom(klass)) {
            return klass;
        }
        throw new ClassNotFoundException("Requested class: " + classOrAlias + " does not extend " + pluginClass.getSimpleName());
    }

    public static ClassLoader compareAndSwapLoaders(ClassLoader loader) {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        if (!current.equals(loader)) {
            Thread.currentThread().setContextClassLoader(loader);
        }
        return current;
    }

    public ClassLoader currentThreadLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public ClassLoader compareAndSwapWithDelegatingLoader() {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        if (!current.equals(this.delegatingLoader)) {
            Thread.currentThread().setContextClassLoader(this.delegatingLoader);
        }
        return current;
    }

    public ClassLoader compareAndSwapLoaders(Connector connector) {
        ClassLoader connectorLoader = this.delegatingLoader.connectorLoader(connector);
        return Plugins.compareAndSwapLoaders(connectorLoader);
    }

    public DelegatingClassLoader delegatingLoader() {
        return this.delegatingLoader;
    }

    public Set<PluginDesc<Connector>> connectors() {
        return this.delegatingLoader.connectors();
    }

    public Set<PluginDesc<Converter>> converters() {
        return this.delegatingLoader.converters();
    }

    public Set<PluginDesc<Transformation>> transformations() {
        return this.delegatingLoader.transformations();
    }

    public Connector newConnector(String connectorClassOrAlias) {
        Class<Object> klass;
        try {
            klass = Plugins.pluginClass(this.delegatingLoader, connectorClassOrAlias, Connector.class);
        }
        catch (ClassNotFoundException e) {
            ArrayList matches = new ArrayList();
            for (PluginDesc<Connector> plugin : this.delegatingLoader.connectors()) {
                Class<Connector> pluginClass = plugin.pluginClass();
                String simpleName = pluginClass.getSimpleName();
                if (!simpleName.equals(connectorClassOrAlias) && !simpleName.equals(connectorClassOrAlias + "Connector")) continue;
                matches.add(plugin);
            }
            if (matches.isEmpty()) {
                throw new ConnectException("Failed to find any class that implements Connector and which name matches " + connectorClassOrAlias + ", available connectors are: " + Plugins.pluginNames(this.delegatingLoader.connectors()));
            }
            if (matches.size() > 1) {
                throw new ConnectException("More than one connector matches alias " + connectorClassOrAlias + ". Please use full package and class name instead. Classes found: " + Plugins.pluginNames(matches));
            }
            PluginDesc entry = (PluginDesc)matches.get(0);
            klass = entry.pluginClass();
        }
        return Plugins.newPlugin(klass);
    }

    public Task newTask(Class<? extends Task> taskClass) {
        return Plugins.newPlugin(taskClass);
    }

    public Converter newConverter(AbstractConfig config, String classPropertyName, ClassLoaderUsage classLoaderUsage) {
        if (!config.originals().containsKey(classPropertyName)) {
            return null;
        }
        Converter plugin = null;
        switch (classLoaderUsage) {
            case CURRENT_CLASSLOADER: {
                plugin = this.getInstance(config, classPropertyName, Converter.class);
                break;
            }
            case PLUGINS: {
                Class<Converter> klass;
                String converterClassOrAlias = config.getClass(classPropertyName).getName();
                try {
                    klass = Plugins.pluginClass(this.delegatingLoader, converterClassOrAlias, Converter.class);
                }
                catch (ClassNotFoundException e) {
                    throw new ConnectException("Failed to find any class that implements Converter and which name matches " + converterClassOrAlias + ", available converters are: " + Plugins.pluginNames(this.delegatingLoader.converters()));
                }
                plugin = Plugins.newPlugin(klass);
            }
        }
        if (plugin == null) {
            throw new ConnectException("Unable to instantiate the Converter specified in '" + classPropertyName + "'");
        }
        boolean isKeyConverter = "key.converter".equals(classPropertyName) || "internal.key.converter".equals(classPropertyName);
        String configPrefix = classPropertyName + ".";
        Map converterConfig = config.originalsWithPrefix(configPrefix);
        log.debug("Configuring the {} converter with configuration:{}{}", new Object[]{isKeyConverter ? "key" : "value", System.lineSeparator(), converterConfig});
        plugin.configure(converterConfig, isKeyConverter);
        return plugin;
    }

    public HeaderConverter newHeaderConverter(AbstractConfig config, String classPropertyName, ClassLoaderUsage classLoaderUsage) {
        HeaderConverter plugin = null;
        switch (classLoaderUsage) {
            case CURRENT_CLASSLOADER: {
                if (!config.originals().containsKey(classPropertyName)) {
                    return null;
                }
                plugin = this.getInstance(config, classPropertyName, HeaderConverter.class);
                break;
            }
            case PLUGINS: {
                Class<HeaderConverter> klass;
                String converterClassOrAlias = config.getClass(classPropertyName).getName();
                try {
                    klass = Plugins.pluginClass(this.delegatingLoader, converterClassOrAlias, HeaderConverter.class);
                }
                catch (ClassNotFoundException e) {
                    throw new ConnectException("Failed to find any class that implements HeaderConverter and which name matches " + converterClassOrAlias + ", available header converters are: " + Plugins.pluginNames(this.delegatingLoader.headerConverters()));
                }
                plugin = Plugins.newPlugin(klass);
            }
        }
        if (plugin == null) {
            throw new ConnectException("Unable to instantiate the Converter specified in '" + classPropertyName + "'");
        }
        String configPrefix = classPropertyName + ".";
        Map converterConfig = config.originalsWithPrefix(configPrefix);
        converterConfig.put("converter.type", ConverterType.HEADER.getName());
        log.debug("Configuring the header converter with configuration:{}{}", (Object)System.lineSeparator(), (Object)converterConfig);
        plugin.configure(converterConfig);
        return plugin;
    }

    private <T> T getInstance(AbstractConfig config, String key, Class<T> t) {
        Class c = config.getClass(key);
        if (c == null) {
            return null;
        }
        Object o = Utils.newInstance((Class)c);
        if (!t.isInstance(o)) {
            throw new KafkaException(c.getName() + " is not an instance of " + t.getName());
        }
        return t.cast(o);
    }

    public <R extends ConnectRecord<R>> Transformation<R> newTranformations(String transformationClassOrAlias) {
        return null;
    }

    public static enum ClassLoaderUsage {
        CURRENT_CLASSLOADER,
        PLUGINS;

    }
}

