/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.rest.resources;

import java.util.List;
import java.util.Map;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.kafka.connect.runtime.Herder;
import org.apache.kafka.connect.runtime.PluginDiscovery;
import org.apache.kafka.connect.runtime.rest.entities.ConfigInfos;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorPluginInfo;

@Path(value="/connector-plugins")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ConnectorPluginsResource {
    private static final String ALIAS_SUFFIX = "Connector";
    private final Herder herder;

    public ConnectorPluginsResource(Herder herder) {
        this.herder = herder;
    }

    @PUT
    @Path(value="/{connectorType}/config/validate")
    public ConfigInfos validateConfigs(@PathParam(value="connectorType") String connType, Map<String, String> connectorConfig) throws Throwable {
        String includedConnType = connectorConfig.get("connector.class");
        if (includedConnType != null && !this.normalizedPluginName(includedConnType).endsWith(this.normalizedPluginName(connType))) {
            throw new BadRequestException("Included connector type " + includedConnType + " does not match request type " + connType);
        }
        return this.herder.validateConnectorConfig(connectorConfig);
    }

    @GET
    @Path(value="/")
    public List<ConnectorPluginInfo> listConnectorPlugins() {
        return PluginDiscovery.connectorPlugins();
    }

    private String normalizedPluginName(String pluginName) {
        return pluginName.endsWith(ALIAS_SUFFIX) && pluginName.length() > ALIAS_SUFFIX.length() ? pluginName.substring(0, pluginName.length() - ALIAS_SUFFIX.length()) : pluginName;
    }
}

