/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;

public class ConnectorConfig
extends AbstractConfig {
    protected static final String COMMON_GROUP = "Common";
    public static final String NAME_CONFIG = "name";
    private static final String NAME_DOC = "Globally unique name to use for this connector.";
    private static final String NAME_DISPLAY = "Connector name";
    public static final String CONNECTOR_CLASS_CONFIG = "connector.class";
    private static final String CONNECTOR_CLASS_DOC = "Name or alias of the class for this connector. Must be a subclass of org.apache.kafka.connect.connector.Connector. If the connector is org.apache.kafka.connect.file.FileStreamSinkConnector, you can either specify this full name,  or use \"FileStreamSink\" or \"FileStreamSinkConnector\" to make the configuration a bit shorter";
    private static final String CONNECTOR_CLASS_DISPLAY = "Connector class";
    public static final String KEY_CONVERTER_CLASS_CONFIG = "key.converter";
    public static final String KEY_CONVERTER_CLASS_DOC = "Converter class used to convert between Kafka Connect format and the serialized form that is written to Kafka. This controls the format of the keys in messages written to or read from Kafka, and since this is independent of connectors it allows any connector to work with any serialization format. Examples of common formats include JSON and Avro.";
    public static final String KEY_CONVERTER_CLASS_DISPLAY = "Key converter class";
    public static final String VALUE_CONVERTER_CLASS_CONFIG = "value.converter";
    public static final String VALUE_CONVERTER_CLASS_DOC = "Converter class used to convert between Kafka Connect format and the serialized form that is written to Kafka. This controls the format of the values in messages written to or read from Kafka, and since this is independent of connectors it allows any connector to work with any serialization format. Examples of common formats include JSON and Avro.";
    public static final String VALUE_CONVERTER_CLASS_DISPLAY = "Value converter class";
    public static final String TASKS_MAX_CONFIG = "tasks.max";
    private static final String TASKS_MAX_DOC = "Maximum number of tasks to use for this connector.";
    public static final int TASKS_MAX_DEFAULT = 1;
    private static final int TASKS_MIN_CONFIG = 1;
    private static final String TASK_MAX_DISPLAY = "Tasks max";

    public static ConfigDef configDef() {
        return new ConfigDef().define(NAME_CONFIG, ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, NAME_DOC, COMMON_GROUP, 1, ConfigDef.Width.MEDIUM, NAME_DISPLAY).define(CONNECTOR_CLASS_CONFIG, ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, CONNECTOR_CLASS_DOC, COMMON_GROUP, 2, ConfigDef.Width.LONG, CONNECTOR_CLASS_DISPLAY).define(TASKS_MAX_CONFIG, ConfigDef.Type.INT, (Object)1, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, TASKS_MAX_DOC, COMMON_GROUP, 3, ConfigDef.Width.SHORT, TASK_MAX_DISPLAY).define(KEY_CONVERTER_CLASS_CONFIG, ConfigDef.Type.CLASS, null, ConfigDef.Importance.LOW, KEY_CONVERTER_CLASS_DOC, COMMON_GROUP, 4, ConfigDef.Width.SHORT, KEY_CONVERTER_CLASS_DISPLAY).define(VALUE_CONVERTER_CLASS_CONFIG, ConfigDef.Type.CLASS, null, ConfigDef.Importance.LOW, VALUE_CONVERTER_CLASS_DOC, COMMON_GROUP, 5, ConfigDef.Width.SHORT, VALUE_CONVERTER_CLASS_DISPLAY);
    }

    public ConnectorConfig() {
        this(new HashMap<String, String>());
    }

    public ConnectorConfig(Map<String, String> props) {
        super(ConnectorConfig.configDef(), props);
    }

    public ConnectorConfig(ConfigDef subClassConfig, Map<String, String> props) {
        super(subClassConfig, props);
    }
}

