/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.config;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.v3.annotations.AnnotationProcessor;
import org.apache.juddi.v3.client.ClassUtil;
import org.apache.juddi.v3.client.Release;
import org.apache.juddi.v3.client.config.BackGroundRegistration;
import org.apache.juddi.v3.client.config.ClientConfig;
import org.apache.juddi.v3.client.config.UDDIClerk;
import org.apache.juddi.v3.client.config.UDDIClientContainer;
import org.apache.juddi.v3.client.config.UDDINode;
import org.apache.juddi.v3.client.config.XRegistration;
import org.apache.juddi.v3.client.embed.EmbeddedRegistry;
import org.apache.juddi.v3.client.mapping.ServiceLocator;
import org.apache.juddi.v3.client.mapping.URLLocalizerDefaultImpl;
import org.apache.juddi.v3.client.transport.InVMTransport;
import org.apache.juddi.v3.client.transport.Transport;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BusinessService;
import org.uddi.api_v3.CategoryBag;
import org.uddi.api_v3.KeyedReference;
import org.uddi.api_v3.TModelInstanceDetails;
import org.uddi.api_v3.TModelInstanceInfo;

public class UDDIClient {
    private static Log log = LogFactory.getLog(UDDIClient.class);
    private ClientConfig clientConfig = null;
    private String CONFIG_FILE = "META-INF/uddi.xml";
    private Properties properties = null;
    private static Map<String, ServiceLocator> serviceLocators = new HashMap<String, ServiceLocator>();

    public static void clearServiceLocatorCaches() {
        serviceLocators.clear();
    }

    public UDDIClient() throws ConfigurationException {
        log.info((Object)("jUDDI Client version - " + Release.getjUDDIClientVersion()));
        this.clientConfig = new ClientConfig(this.CONFIG_FILE, this.properties);
        UDDIClientContainer.addClient(this);
    }

    public UDDIClient(String configurationFile) throws ConfigurationException {
        log.info((Object)("jUDDI Client version - " + Release.getjUDDIClientVersion()));
        this.clientConfig = new ClientConfig(configurationFile);
        UDDIClientContainer.addClient(this);
    }

    public UDDIClient(String configurationFile, Properties properties) throws ConfigurationException {
        log.info((Object)("jUDDI Client version - " + Release.getjUDDIClientVersion()));
        this.clientConfig = new ClientConfig(configurationFile, properties);
        UDDIClientContainer.addClient(this);
    }

    public synchronized ServiceLocator getServiceLocator() throws ConfigurationException {
        return this.getServiceLocator(null);
    }

    public synchronized ServiceLocator getServiceLocator(String clerkName) throws ConfigurationException {
        UDDIClerk clerk = this.getClerk(clerkName);
        if (clerk == null) {
            throw new ConfigurationException("could not locate the UDDI Clerk '" + clerkName + "'.");
        }
        if (!serviceLocators.containsKey(clerk.getName())) {
            ServiceLocator serviceLocator = new ServiceLocator(clerk, new URLLocalizerDefaultImpl(), this.properties);
            serviceLocators.put(clerk.getName(), serviceLocator);
        }
        return serviceLocators.get(clerk.getName());
    }

    public void stop() throws ConfigurationException {
        log.info((Object)("Stopping UDDI Client " + this.clientConfig.getClientName()));
        this.releaseResources();
        if (UDDIClientContainer.contains(this.getName())) {
            UDDIClientContainer.removeClerkManager(this.getName());
        }
        if (InVMTransport.class.getCanonicalName().equals(this.getClientConfig().getHomeNode().getProxyTransport())) {
            log.info((Object)"Shutting down embedded Server");
            this.stopEmbeddedServer();
        }
        log.info((Object)("UDDI Clerks shutdown completed for manager " + this.clientConfig.getClientName()));
    }

    private void releaseResources() {
        if (this.clientConfig.isRegisterOnStartup()) {
            this.unRegisterWSDLs();
            this.unRegisterBindingsOfAnnotatedServices(true);
        }
    }

    public void start() throws ConfigurationException {
        if (UDDIClientContainer.addClient(this)) {
            if (InVMTransport.class.getCanonicalName().equals(this.getClientConfig().getHomeNode().getProxyTransport())) {
                log.info((Object)"Starting embedded Server");
                this.startEmbeddedServer();
            }
            if (this.clientConfig.isRegisterOnStartup()) {
                BackGroundRegistration runnable = new BackGroundRegistration(this);
                Thread thread = new Thread(runnable);
                thread.setName("juddi background registration");
                thread.setDaemon(true);
                thread.start();
            }
        }
    }

    protected void startEmbeddedServer() throws ConfigurationException {
        try {
            String embeddedServerClass = this.getClientConfig().getHomeNode().getProperties().getProperty("embeddedServer", "org.apache.juddi.v3.client.embed.JUDDIRegistry");
            Class<?> clazz = ClassUtil.forName(embeddedServerClass, this.getClass());
            EmbeddedRegistry embeddedRegistry = (EmbeddedRegistry)clazz.newInstance();
            embeddedRegistry.start();
        }
        catch (Exception e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
    }

    protected void stopEmbeddedServer() throws ConfigurationException {
        try {
            String embeddedServerClass = this.getClientConfig().getHomeNode().getProperties().getProperty("embeddedServer", "org.apache.juddi.v3.client.embed.JUDDIRegistry");
            Class<?> clazz = ClassUtil.forName(embeddedServerClass, this.getClass());
            EmbeddedRegistry embeddedRegistry = (EmbeddedRegistry)clazz.newInstance();
            embeddedRegistry.stop();
        }
        catch (Exception e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
    }

    public void restart() throws ConfigurationException {
        this.stop();
        this.start();
    }

    public void saveClerkAndNodeInfo() {
        Map<String, UDDIClerk> uddiClerks = this.clientConfig.getUDDIClerks();
        if (uddiClerks.size() > 0) {
            UDDIClerk homeClerk = null;
            for (UDDIClerk clerk : uddiClerks.values()) {
                if (!clerk.getUDDINode().isHomeJUDDI()) continue;
                homeClerk = clerk;
            }
            if (homeClerk != null) {
                int numberOfHomeJUDDIs = 0;
                for (UDDINode uddiNode : this.clientConfig.getUDDINodes().values()) {
                    if (uddiNode.isHomeJUDDI()) {
                        ++numberOfHomeJUDDIs;
                    }
                    homeClerk.saveNode(uddiNode.getApiNode());
                }
                if (numberOfHomeJUDDIs == 1) {
                    for (UDDIClerk clerk : this.clientConfig.getUDDIClerks().values()) {
                        homeClerk.saveClerk(clerk);
                    }
                } else {
                    log.error((Object)("The client config needs to have one homeJUDDI node and found " + numberOfHomeJUDDIs));
                }
            } else {
                log.debug((Object)"No home clerk found.");
            }
        }
    }

    public void xRegister() {
        log.debug((Object)"Starting cross registration...");
        Set<XRegistration> xBusinessRegistrations = this.clientConfig.getXBusinessRegistrations();
        for (XRegistration xRegistration : xBusinessRegistrations) {
            xRegistration.xRegisterBusiness();
        }
        Set<XRegistration> xServiceBindingRegistrations = this.clientConfig.getXServiceBindingRegistrations();
        for (XRegistration xRegistration : xServiceBindingRegistrations) {
            xRegistration.xRegisterServiceBinding();
        }
        log.debug((Object)"Cross registration completed");
    }

    public void registerAnnotatedServices() {
        Map<String, UDDIClerk> uddiClerks = this.clientConfig.getUDDIClerks();
        if (uddiClerks.size() > 0) {
            AnnotationProcessor ap = new AnnotationProcessor();
            for (UDDIClerk uddiClerk : uddiClerks.values()) {
                Collection<BusinessService> services = ap.readServiceAnnotations(uddiClerk.getClassWithAnnotations(), uddiClerk.getUDDINode().getProperties());
                for (BusinessService businessService : services) {
                    log.info((Object)("Node=" + uddiClerk.getUDDINode().getApiNode().getName()));
                    uddiClerk.register(businessService, uddiClerk.getUDDINode().getApiNode());
                }
            }
        }
    }

    public void unRegisterAnnotatedServices() {
        Map<String, UDDIClerk> clerks = this.clientConfig.getUDDIClerks();
        if (clerks.size() > 0) {
            AnnotationProcessor ap = new AnnotationProcessor();
            for (UDDIClerk clerk : clerks.values()) {
                Collection<BusinessService> services = ap.readServiceAnnotations(clerk.getClassWithAnnotations(), clerk.getUDDINode().getProperties());
                for (BusinessService businessService : services) {
                    clerk.unRegisterService(businessService.getServiceKey(), clerk.getUDDINode().getApiNode());
                }
            }
        }
    }

    public void unRegisterBindingsOfAnnotatedServices(boolean removeServiceWithNoBindingTemplates) {
        Map<String, UDDIClerk> clerks = this.clientConfig.getUDDIClerks();
        if (clerks.size() > 0) {
            AnnotationProcessor ap = new AnnotationProcessor();
            for (UDDIClerk clerk : clerks.values()) {
                Collection<BusinessService> services = ap.readServiceAnnotations(clerk.getClassWithAnnotations(), clerk.getUDDINode().getProperties());
                for (BusinessService businessService : services) {
                    if (businessService.getBindingTemplates() != null) {
                        List bindingTemplates = businessService.getBindingTemplates().getBindingTemplate();
                        for (BindingTemplate bindingTemplate : bindingTemplates) {
                            clerk.unRegisterBinding(bindingTemplate.getBindingKey(), clerk.getUDDINode().getApiNode());
                        }
                    }
                    if (!removeServiceWithNoBindingTemplates) continue;
                    try {
                        BusinessService existingService = clerk.getServiceDetail(businessService.getServiceKey(), clerk.getUDDINode().getApiNode());
                        if (existingService.getBindingTemplates() != null && existingService.getBindingTemplates().getBindingTemplate().size() != 0) continue;
                        clerk.unRegisterService(businessService.getServiceKey(), clerk.getUDDINode().getApiNode());
                    }
                    catch (Exception e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public String getName() {
        return this.clientConfig.getClientName();
    }

    @Deprecated
    public String getClientCallbackUrl() {
        return this.clientConfig.getClientCallbackUrl();
    }

    public Transport getTransport() throws ConfigurationException {
        return this.getTransport("default");
    }

    public Transport getTransport(String nodeName) throws ConfigurationException {
        try {
            String clazz = this.clientConfig.getUDDINode(nodeName).getProxyTransport();
            String managerName = this.clientConfig.getClientName();
            Class<?> transportClass = ClassUtil.forName(clazz, UDDIClient.class);
            if (transportClass != null) {
                Transport transport = (Transport)transportClass.getConstructor(String.class, String.class).newInstance(managerName, nodeName);
                return transport;
            }
            throw new ConfigurationException("ProxyTransport was not defined in the " + this.clientConfig.getConfigurationFile());
        }
        catch (Exception e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
    }

    public UDDIClerk getClerk(String clerkName) {
        if (clerkName == null || clerkName.length() == 0) {
            return this.getClientConfig().getUDDIClerks().get("default");
        }
        return this.getClientConfig().getUDDIClerks().get(clerkName);
    }

    public void registerWSDLs() {
        Map<String, UDDIClerk> uddiClerks = this.clientConfig.getUDDIClerks();
        if (uddiClerks.size() > 0) {
            for (UDDIClerk uddiClerk : uddiClerks.values()) {
                uddiClerk.registerWsdls();
            }
        }
    }

    public void unRegisterWSDLs() {
        Map<String, UDDIClerk> uddiClerks = this.clientConfig.getUDDIClerks();
        if (uddiClerks.size() > 0) {
            for (UDDIClerk uddiClerk : uddiClerks.values()) {
                uddiClerk.unRegisterWsdls();
            }
        }
    }

    public static BindingTemplate addSOAPtModels(BindingTemplate bt) {
        if (bt.getCategoryBag() == null) {
            bt.setCategoryBag(new CategoryBag());
        }
        boolean found = false;
        for (int i = 0; i < bt.getCategoryBag().getKeyedReference().size(); ++i) {
            if (((KeyedReference)bt.getCategoryBag().getKeyedReference().get(i)).getTModelKey() == null || !((KeyedReference)bt.getCategoryBag().getKeyedReference().get(i)).getTModelKey().equalsIgnoreCase("uddi:uddi.org:categorization:types") || ((KeyedReference)bt.getCategoryBag().getKeyedReference().get(i)).getKeyName() == null || !((KeyedReference)bt.getCategoryBag().getKeyedReference().get(i)).getKeyName().equalsIgnoreCase("uddi-org:types:wsdl")) continue;
            found = true;
        }
        if (!found) {
            bt.getCategoryBag().getKeyedReference().add(new KeyedReference("uddi:uddi.org:categorization:types", "uddi-org:types:wsdl", "wsdlDeployment"));
        }
        if (bt.getCategoryBag().getKeyedReference().isEmpty() && bt.getCategoryBag().getKeyedReferenceGroup().isEmpty()) {
            bt.setCategoryBag(null);
        }
        if (bt.getTModelInstanceDetails() == null) {
            bt.setTModelInstanceDetails(new TModelInstanceDetails());
        }
        if (!UDDIClient.exists(bt.getTModelInstanceDetails().getTModelInstanceInfo(), "uddi:uddi.org:protocol:soap")) {
            TModelInstanceInfo tModelInstanceInfo = new TModelInstanceInfo();
            tModelInstanceInfo.setTModelKey("uddi:uddi.org:protocol:soap");
            bt.getTModelInstanceDetails().getTModelInstanceInfo().add(tModelInstanceInfo);
        }
        if (bt.getAccessPoint() != null && bt.getAccessPoint().getValue().startsWith("http:") && !UDDIClient.exists(bt.getTModelInstanceDetails().getTModelInstanceInfo(), "uddi:uddi.org:transport:http")) {
            TModelInstanceInfo tModelInstanceInfo = new TModelInstanceInfo();
            tModelInstanceInfo.setTModelKey("uddi:uddi.org:transport:http");
            bt.getTModelInstanceDetails().getTModelInstanceInfo().add(tModelInstanceInfo);
        }
        if (bt.getAccessPoint() != null && bt.getAccessPoint().getValue().startsWith("jms:") && !UDDIClient.exists(bt.getTModelInstanceDetails().getTModelInstanceInfo(), "uddi:uddi.org:transport:jms")) {
            TModelInstanceInfo tModelInstanceInfo = new TModelInstanceInfo();
            tModelInstanceInfo.setTModelKey("uddi:uddi.org:transport:jms");
            bt.getTModelInstanceDetails().getTModelInstanceInfo().add(tModelInstanceInfo);
        }
        if (bt.getAccessPoint() != null && bt.getAccessPoint().getValue().startsWith("rmi:") && !UDDIClient.exists(bt.getTModelInstanceDetails().getTModelInstanceInfo(), "uddi:uddi.org:transport:rmi")) {
            TModelInstanceInfo tModelInstanceInfo = new TModelInstanceInfo();
            tModelInstanceInfo.setTModelKey("uddi:uddi.org:transport:rmi");
            bt.getTModelInstanceDetails().getTModelInstanceInfo().add(tModelInstanceInfo);
        }
        if (bt.getAccessPoint() != null && bt.getAccessPoint().getValue().startsWith("udp:") && !UDDIClient.exists(bt.getTModelInstanceDetails().getTModelInstanceInfo(), "uddi:uddi.org:transport:udp")) {
            TModelInstanceInfo tModelInstanceInfo = new TModelInstanceInfo();
            tModelInstanceInfo.setTModelKey("uddi:uddi.org:transport:udp");
            bt.getTModelInstanceDetails().getTModelInstanceInfo().add(tModelInstanceInfo);
        }
        if (bt.getAccessPoint() != null && bt.getAccessPoint().getValue().startsWith("amqp:") && !UDDIClient.exists(bt.getTModelInstanceDetails().getTModelInstanceInfo(), "uddi:uddi.org:transport:amqp")) {
            TModelInstanceInfo tModelInstanceInfo = new TModelInstanceInfo();
            tModelInstanceInfo.setTModelKey("uddi:uddi.org:transport:amqp");
            bt.getTModelInstanceDetails().getTModelInstanceInfo().add(tModelInstanceInfo);
        }
        if (bt.getAccessPoint() != null && bt.getAccessPoint().getValue().startsWith("mailto:") && !UDDIClient.exists(bt.getTModelInstanceDetails().getTModelInstanceInfo(), "uddi:uddi.org:transport:smtp")) {
            TModelInstanceInfo tModelInstanceInfo = new TModelInstanceInfo();
            tModelInstanceInfo.setTModelKey("uddi:uddi.org:transport:smtp");
            bt.getTModelInstanceDetails().getTModelInstanceInfo().add(tModelInstanceInfo);
        }
        if (bt.getAccessPoint() != null && bt.getAccessPoint().getValue().startsWith("ftp:") && !UDDIClient.exists(bt.getTModelInstanceDetails().getTModelInstanceInfo(), "uddi:uddi.org:transport:ftp")) {
            TModelInstanceInfo tModelInstanceInfo = new TModelInstanceInfo();
            tModelInstanceInfo.setTModelKey("uddi:uddi.org:transport:ftp");
            bt.getTModelInstanceDetails().getTModelInstanceInfo().add(tModelInstanceInfo);
        }
        if (bt.getAccessPoint() != null && bt.getAccessPoint().getValue().startsWith("https:") && !UDDIClient.exists(bt.getTModelInstanceDetails().getTModelInstanceInfo(), "uddi:uddi.org:protocol:serverauthenticatedssl3")) {
            TModelInstanceInfo tModelInstanceInfo = new TModelInstanceInfo();
            tModelInstanceInfo.setTModelKey("uddi:uddi.org:protocol:serverauthenticatedssl3");
            bt.getTModelInstanceDetails().getTModelInstanceInfo().add(tModelInstanceInfo);
        }
        if (bt.getAccessPoint() != null && bt.getAccessPoint().getValue().startsWith("ftps:") && !UDDIClient.exists(bt.getTModelInstanceDetails().getTModelInstanceInfo(), "uddi:uddi.org:protocol:serverauthenticatedssl3")) {
            TModelInstanceInfo tModelInstanceInfo = new TModelInstanceInfo();
            tModelInstanceInfo.setTModelKey("uddi:uddi.org:protocol:serverauthenticatedssl3");
            bt.getTModelInstanceDetails().getTModelInstanceInfo().add(tModelInstanceInfo);
        }
        if (bt.getAccessPoint() != null && bt.getAccessPoint().getValue().startsWith("jndi:") && !UDDIClient.exists(bt.getTModelInstanceDetails().getTModelInstanceInfo(), "uddi:uddi.org:transport:jndi-rmi")) {
            TModelInstanceInfo tModelInstanceInfo = new TModelInstanceInfo();
            tModelInstanceInfo.setTModelKey("uddi:uddi.org:transport:jndi-rmi");
            bt.getTModelInstanceDetails().getTModelInstanceInfo().add(tModelInstanceInfo);
        }
        return bt;
    }

    public static BindingTemplate addRESTtModels(BindingTemplate bt) {
        TModelInstanceInfo tModelInstanceInfo;
        if (bt.getTModelInstanceDetails() == null) {
            bt.setTModelInstanceDetails(new TModelInstanceDetails());
        }
        if (!UDDIClient.exists(bt.getTModelInstanceDetails().getTModelInstanceInfo(), "uddi:uddi.org:protocol:rest")) {
            tModelInstanceInfo = new TModelInstanceInfo();
            tModelInstanceInfo.setTModelKey("uddi:uddi.org:protocol:rest");
            bt.getTModelInstanceDetails().getTModelInstanceInfo().add(tModelInstanceInfo);
        }
        if (bt.getAccessPoint() != null && bt.getAccessPoint().getValue().startsWith("http:") && !UDDIClient.exists(bt.getTModelInstanceDetails().getTModelInstanceInfo(), "uddi:uddi.org:transport:http")) {
            tModelInstanceInfo = new TModelInstanceInfo();
            tModelInstanceInfo.setTModelKey("uddi:uddi.org:transport:http");
            bt.getTModelInstanceDetails().getTModelInstanceInfo().add(tModelInstanceInfo);
        }
        if (bt.getAccessPoint() != null && bt.getAccessPoint().getValue().startsWith("https:") && !UDDIClient.exists(bt.getTModelInstanceDetails().getTModelInstanceInfo(), "uddi:uddi.org:protocol:serverauthenticatedssl3")) {
            tModelInstanceInfo = new TModelInstanceInfo();
            tModelInstanceInfo.setTModelKey("uddi:uddi.org:protocol:serverauthenticatedssl3");
            bt.getTModelInstanceDetails().getTModelInstanceInfo().add(tModelInstanceInfo);
        }
        return bt;
    }

    private static boolean exists(List<TModelInstanceInfo> items, String key) {
        for (int i = 0; i < items.size(); ++i) {
            if (items.get(i).getTModelKey() == null || !items.get(i).getTModelKey().equalsIgnoreCase(key)) continue;
            return true;
        }
        return false;
    }
}

