/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.exec;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.jorphan.exec.StreamCopier;
import org.apache.jorphan.util.JOrphanUtils;

public class SystemCommand {
    public static final int POLL_INTERVAL = 100;
    private final File directory;
    private final Map<String, String> env;
    private Map<String, String> executionEnvironment;
    private final InputStream stdin;
    private final OutputStream stdout;
    private final boolean stdoutWasNull;
    private final OutputStream stderr;
    private final long timeoutMillis;
    private final int pollInterval;

    public SystemCommand(File directory, Map<String, String> env) {
        this(directory, 0L, 100, env, (InputStream)null, (OutputStream)null, (OutputStream)null);
    }

    public SystemCommand(File directory, long timeoutMillis, int pollInterval, Map<String, String> env, String stdin, String stdout, String stderr) throws IOException {
        this(directory, timeoutMillis, pollInterval, env, SystemCommand.checkIn(stdin), SystemCommand.checkOut(stdout), SystemCommand.checkOut(stderr));
    }

    private static InputStream checkIn(String stdin) throws FileNotFoundException {
        String in = JOrphanUtils.nullifyIfEmptyTrimmed(stdin);
        if (in == null) {
            return null;
        }
        return new FileInputStream(in);
    }

    private static OutputStream checkOut(String path) throws IOException {
        String in = JOrphanUtils.nullifyIfEmptyTrimmed(path);
        if (in == null) {
            return null;
        }
        return new FileOutputStream(path);
    }

    public SystemCommand(File directory, long timeoutMillis, int pollInterval, Map<String, String> env, InputStream stdin, OutputStream stdout, OutputStream stderr) {
        this.timeoutMillis = timeoutMillis;
        this.directory = directory;
        this.env = env;
        this.pollInterval = pollInterval;
        this.stdin = stdin;
        this.stdoutWasNull = stdout == null;
        this.stdout = stdout == null ? new ByteArrayOutputStream() : stdout;
        this.stderr = stderr;
    }

    public int run(List<String> arguments) throws InterruptedException, IOException {
        return this.run(arguments, this.stdin, this.stdout, this.stderr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int run(List<String> arguments, InputStream in, OutputStream out, OutputStream err) throws InterruptedException, IOException {
        Process proc = null;
        ProcessBuilder procBuild = new ProcessBuilder(arguments);
        if (this.env != null) {
            procBuild.environment().putAll(this.env);
        }
        this.executionEnvironment = Collections.unmodifiableMap(procBuild.environment());
        procBuild.directory(this.directory);
        if (err == null) {
            procBuild.redirectErrorStream(true);
        }
        try {
            StreamCopier swin;
            StreamCopier swerr;
            proc = procBuild.start();
            OutputStream procOut = proc.getOutputStream();
            InputStream procErr = proc.getErrorStream();
            InputStream procIn = proc.getInputStream();
            if (err != null) {
                swerr = new StreamCopier(procErr, err);
                swerr.start();
            } else {
                swerr = null;
            }
            StreamCopier swout = new StreamCopier(procIn, out);
            swout.start();
            if (in != null) {
                swin = new StreamCopier(in, procOut);
                swin.start();
            } else {
                swin = null;
                procOut.close();
            }
            int exitVal = this.waitForEndWithTimeout(proc, this.timeoutMillis);
            swout.join();
            if (swerr != null) {
                swerr.join();
            }
            if (swin != null) {
                swin.interrupt();
                swin.join();
            }
            procErr.close();
            procIn.close();
            procOut.close();
            int n = exitVal;
            return n;
        }
        finally {
            if (proc != null) {
                try {
                    proc.destroy();
                }
                catch (Exception ignored) {}
            }
        }
    }

    public int run(List<String> arguments1, List<String> arguments2) throws InterruptedException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int exitCode = this.run(arguments1, this.stdin, out, this.stderr);
        if (exitCode == 0) {
            exitCode = this.run(arguments2, new ByteArrayInputStream(out.toByteArray()), this.stdout, this.stderr);
        }
        return exitCode;
    }

    private int waitForEndWithTimeout(Process proc, long timeoutInMillis) throws InterruptedException {
        if (timeoutInMillis <= 0L) {
            return proc.waitFor();
        }
        long now = System.currentTimeMillis();
        long finish = now + timeoutInMillis;
        while (System.currentTimeMillis() < finish) {
            try {
                return proc.exitValue();
            }
            catch (IllegalThreadStateException e) {
                Thread.sleep(this.pollInterval);
            }
        }
        try {
            return proc.exitValue();
        }
        catch (IllegalThreadStateException e) {
            throw new InterruptedException("Process timeout out after " + timeoutInMillis + " milliseconds");
        }
    }

    public String getOutResult() {
        if (this.stdoutWasNull) {
            return this.stdout.toString();
        }
        return "";
    }

    public Map<String, String> getExecutionEnvironment() {
        return this.executionEnvironment;
    }
}

