/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.smtp.sampler.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

public class SecuritySettingsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String USE_SSL = "SMTPSampler.useSSL";
    public static final String USE_STARTTLS = "SMTPSampler.useStartTLS";
    public static final String SSL_TRUST_ALL_CERTS = "SMTPSampler.trustAllCerts";
    public static final String ENFORCE_STARTTLS = "SMTPSampler.enforceStartTLS";
    public static final String USE_LOCAL_TRUSTSTORE = "SMTPSampler.useLocalTrustStore";
    public static final String TRUSTSTORE_TO_USE = "SMTPSampler.trustStoreToUse";
    private ButtonGroup bgSecuritySettings;
    private JRadioButton rbUseNone;
    private JRadioButton rbUseSSL;
    private JRadioButton rbUseStartTLS;
    private JCheckBox cbTrustAllCerts;
    private JCheckBox cbEnforceStartTLS;
    private JCheckBox cbUseLocalTrustStore;
    private JLabel jlTrustStoreToUse;
    private JTextField tfTrustStoreToUse;

    public SecuritySettingsPanel() {
        this.init();
    }

    public void init() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"smtp_security_settings")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        this.rbUseNone = new JRadioButton(JMeterUtils.getResString((String)"smtp_usenone"));
        this.rbUseSSL = new JRadioButton(JMeterUtils.getResString((String)"smtp_usessl"));
        this.rbUseStartTLS = new JRadioButton(JMeterUtils.getResString((String)"smtp_usestarttls"));
        this.cbTrustAllCerts = new JCheckBox(JMeterUtils.getResString((String)"smtp_trustall"));
        this.cbEnforceStartTLS = new JCheckBox(JMeterUtils.getResString((String)"smtp_enforcestarttls"));
        this.cbUseLocalTrustStore = new JCheckBox(JMeterUtils.getResString((String)"smtp_usetruststore"));
        this.jlTrustStoreToUse = new JLabel(JMeterUtils.getResString((String)"smtp_truststore"));
        this.tfTrustStoreToUse = new JTextField(20);
        this.rbUseNone.setSelected(true);
        this.bgSecuritySettings = new ButtonGroup();
        this.bgSecuritySettings.add(this.rbUseNone);
        this.bgSecuritySettings.add(this.rbUseSSL);
        this.bgSecuritySettings.add(this.rbUseStartTLS);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.rbUseNone, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.rbUseSSL, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.rbUseStartTLS, gridBagConstraints);
        this.rbUseNone.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                SecuritySettingsPanel.this.rbSecuritySettingsItemStateChanged(evt);
            }
        });
        this.rbUseSSL.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                SecuritySettingsPanel.this.rbSecuritySettingsItemStateChanged(evt);
            }
        });
        this.rbUseStartTLS.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                SecuritySettingsPanel.this.rbSecuritySettingsItemStateChanged(evt);
            }
        });
        this.cbTrustAllCerts.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbTrustAllCerts.setMargin(new Insets(0, 0, 0, 0));
        this.cbTrustAllCerts.setEnabled(false);
        this.cbTrustAllCerts.setToolTipText(JMeterUtils.getResString((String)"smtp_trustall_tooltip"));
        this.cbTrustAllCerts.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SecuritySettingsPanel.this.cbTrustAllCertsActionPerformed(evt);
            }
        });
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.cbTrustAllCerts, gridBagConstraints);
        this.cbEnforceStartTLS.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbEnforceStartTLS.setMargin(new Insets(0, 0, 0, 0));
        this.cbEnforceStartTLS.setEnabled(false);
        this.cbEnforceStartTLS.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SecuritySettingsPanel.this.cbEnforceStartTLSActionPerformed(evt);
            }
        });
        this.cbEnforceStartTLS.setToolTipText(JMeterUtils.getResString((String)"smtp_enforcestarttls_tooltip"));
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.cbEnforceStartTLS, gridBagConstraints);
        this.cbUseLocalTrustStore.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbUseLocalTrustStore.setMargin(new Insets(0, 0, 0, 0));
        this.cbUseLocalTrustStore.setEnabled(false);
        this.cbUseLocalTrustStore.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SecuritySettingsPanel.this.cbUseLocalTrustStoreActionPerformed(evt);
            }
        });
        this.cbUseLocalTrustStore.setToolTipText(JMeterUtils.getResString((String)"smtp_usetruststore_tooltip"));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)this.cbUseLocalTrustStore, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        this.jlTrustStoreToUse.setToolTipText(JMeterUtils.getResString((String)"smtp_truststore_tooltip"));
        this.add((Component)this.jlTrustStoreToUse, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.tfTrustStoreToUse.setToolTipText(JMeterUtils.getResString((String)"smtp_truststore_tooltip"));
        this.add((Component)this.tfTrustStoreToUse, gridBagConstraints);
    }

    private void cbUseLocalTrustStoreActionPerformed(ActionEvent evt) {
        boolean selected = this.cbUseLocalTrustStore.isSelected();
        this.tfTrustStoreToUse.setEditable(selected);
        if (selected) {
            this.cbTrustAllCerts.setSelected(false);
        }
    }

    private void cbTrustAllCertsActionPerformed(ActionEvent evt) {
        boolean selected = this.cbTrustAllCerts.isSelected();
        if (selected) {
            this.cbUseLocalTrustStore.setSelected(false);
            this.tfTrustStoreToUse.setEditable(false);
        }
    }

    private void cbEnforceStartTLSActionPerformed(ActionEvent evt) {
    }

    private void rbSecuritySettingsItemStateChanged(ItemEvent evt) {
        Object source = evt.getSource();
        if (source == this.rbUseNone) {
            this.cbTrustAllCerts.setEnabled(false);
            this.cbTrustAllCerts.setSelected(false);
            this.cbEnforceStartTLS.setEnabled(false);
            this.cbEnforceStartTLS.setSelected(false);
            this.cbUseLocalTrustStore.setSelected(false);
            this.cbUseLocalTrustStore.setEnabled(false);
            this.tfTrustStoreToUse.setEditable(false);
        } else if (source == this.rbUseSSL) {
            this.cbTrustAllCerts.setEnabled(true);
            this.cbEnforceStartTLS.setEnabled(false);
            this.cbEnforceStartTLS.setSelected(false);
            this.cbUseLocalTrustStore.setEnabled(true);
            this.tfTrustStoreToUse.setEditable(false);
        } else if (source == this.rbUseStartTLS) {
            this.cbTrustAllCerts.setEnabled(true);
            this.cbTrustAllCerts.setSelected(false);
            this.cbEnforceStartTLS.setEnabled(true);
            this.cbUseLocalTrustStore.setEnabled(true);
            this.cbUseLocalTrustStore.setSelected(false);
            this.tfTrustStoreToUse.setEditable(false);
        }
    }

    public boolean isUseSSL() {
        return this.rbUseSSL.isSelected();
    }

    public void setUseSSL(boolean useSSL) {
        this.rbUseSSL.setSelected(useSSL);
    }

    public boolean isUseStartTLS() {
        return this.rbUseStartTLS.isSelected();
    }

    public void setUseStartTLS(boolean useStartTLS) {
        this.rbUseStartTLS.setSelected(useStartTLS);
    }

    public boolean isEnforceStartTLS() {
        return this.cbEnforceStartTLS.isSelected();
    }

    public void setEnforceStartTLS(boolean enforceStartTLS) {
        this.cbEnforceStartTLS.setSelected(enforceStartTLS);
    }

    public boolean isUseLocalTrustStore() {
        return this.cbUseLocalTrustStore.isSelected();
    }

    public void setUseLocalTrustStore(boolean useLocalTrustStore) {
        this.cbUseLocalTrustStore.setSelected(useLocalTrustStore);
        this.tfTrustStoreToUse.setEditable(useLocalTrustStore);
    }

    public String getTrustStoreToUse() {
        return this.tfTrustStoreToUse.getText();
    }

    public void setTrustStoreToUse(String trustStoreToUse) {
        this.tfTrustStoreToUse.setText(trustStoreToUse);
    }

    public void setUseNoSecurity(boolean selected) {
        this.rbUseNone.setSelected(selected);
    }

    public boolean isTrustAllCerts() {
        return this.cbTrustAllCerts.isSelected();
    }

    public void setTrustAllCerts(boolean trustAllCerts) {
        this.cbTrustAllCerts.setSelected(trustAllCerts);
    }

    public void clear() {
        this.tfTrustStoreToUse.setText("");
        this.rbUseNone.setSelected(true);
    }

    public void configure(TestElement element) {
        this.setUseSSL(element.getPropertyAsBoolean(USE_SSL));
        this.setUseStartTLS(element.getPropertyAsBoolean(USE_STARTTLS));
        if (!element.getPropertyAsBoolean(USE_STARTTLS) && !element.getPropertyAsBoolean(USE_SSL)) {
            this.setUseNoSecurity(true);
        }
        this.setTrustAllCerts(element.getPropertyAsBoolean(SSL_TRUST_ALL_CERTS));
        this.setEnforceStartTLS(element.getPropertyAsBoolean(ENFORCE_STARTTLS));
        this.setUseLocalTrustStore(element.getPropertyAsBoolean(USE_LOCAL_TRUSTSTORE));
        this.setTrustStoreToUse(element.getPropertyAsString(TRUSTSTORE_TO_USE));
    }

    public void modifyTestElement(TestElement te) {
        te.setProperty(USE_SSL, Boolean.toString(this.isUseSSL()));
        te.setProperty(USE_STARTTLS, Boolean.toString(this.isUseStartTLS()));
        te.setProperty(SSL_TRUST_ALL_CERTS, Boolean.toString(this.isTrustAllCerts()));
        te.setProperty(ENFORCE_STARTTLS, Boolean.toString(this.isEnforceStartTLS()));
        te.setProperty(USE_LOCAL_TRUSTSTORE, Boolean.toString(this.isUseLocalTrustStore()));
        te.setProperty(TRUSTSTORE_TO_USE, this.getTrustStoreToUse());
    }
}

