/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.control;

import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosManager
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final Logger log = LoggerFactory.getLogger(KerberosManager.class);
    private static final String JAAS_APPLICATION = JMeterUtils.getPropDefault((String)"kerberos_jaas_application", (String)"JMeter");
    private final ConcurrentMap<String, Future<Subject>> subjects = new ConcurrentHashMap<String, Future<Subject>>();

    void clearSubjects() {
        this.subjects.clear();
    }

    public Subject getSubjectForUser(String username, String password) {
        FutureTask<Subject> subjectFuture;
        FutureTask<Subject> task = new FutureTask<Subject>(() -> {
            try {
                LoginContext loginCtx = new LoginContext(JAAS_APPLICATION, new LoginCallbackHandler(username, password));
                loginCtx.login();
                return loginCtx.getSubject();
            }
            catch (LoginException e) {
                log.warn("Could not log in user {}", (Object)username, (Object)e);
                return null;
            }
        });
        if (log.isDebugEnabled()) {
            log.debug("Subject cached:{} before:{}", this.subjects.keySet(), (Object)username);
        }
        if ((subjectFuture = (FutureTask<Subject>)this.subjects.putIfAbsent(username, task)) == null) {
            subjectFuture = task;
            task.run();
        }
        try {
            return (Subject)subjectFuture.get();
        }
        catch (InterruptedException e1) {
            log.warn("Interrupted while getting subject for {}", (Object)username, (Object)e1);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e1) {
            log.warn("Execution of getting subject for {} failed", (Object)username, (Object)e1);
        }
        return null;
    }

    public String getKrb5Conf() {
        return System.getProperty("java.security.krb5.conf");
    }

    public boolean getKrb5Debug() {
        return Boolean.getBoolean("java.security.krb5.debug");
    }

    public String getJaasConf() {
        return System.getProperty("java.security.auth.login.config");
    }

    public String toString() {
        return "KerberosManager[jaas: " + this.getJaasConf() + ", krb5: " + this.getKrb5Conf() + ", debug: " + this.getKrb5Debug() + "]";
    }

    static class LoginCallbackHandler
    implements CallbackHandler {
        private final String password;
        private final String username;

        public LoginCallbackHandler(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback && this.username != null) {
                    NameCallback nc = (NameCallback)callback;
                    nc.setName(this.username);
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)callback;
                    pc.setPassword(this.password.toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "Unrecognized Callback");
            }
        }
    }
}

