/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.config.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.config.ConfigElement;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.gui.GUIMenuSortOrder;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.protocol.http.config.gui.UrlConfigGui;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBaseSchema;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerFactory;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JFactory;

@GUIMenuSortOrder(value=5)
@TestElementMetadata(labelResource="url_config_title")
public class HttpDefaultsGui
extends AbstractConfigGui {
    private static final long serialVersionUID = 242L;
    private UrlConfigGui urlConfigGui;
    private JCheckBox retrieveEmbeddedResources;
    private JCheckBox concurrentDwn;
    private JTextField concurrentPool;
    private JCheckBox useMD5;
    private JTextField embeddedAllowRE;
    private JTextField embeddedExcludeRE;
    private JTextField sourceIpAddr;
    private final JComboBox<String> sourceIpType = new JComboBox<String>(HTTPSamplerBase.getSourceTypeList());
    private JTextField proxyScheme;
    private JTextField proxyHost;
    private JTextField proxyPort;
    private JTextField proxyUser;
    private JPasswordField proxyPass;
    private final JComboBox<String> httpImplementation = new JComboBox<String>(HTTPSamplerFactory.getImplementations());
    private JTextField connectTimeOut;
    private JTextField responseTimeOut;

    public HttpDefaultsGui() {
        this.init();
    }

    public String getLabelResource() {
        return "url_config_title";
    }

    public TestElement createTestElement() {
        ConfigTestElement config = new ConfigTestElement();
        this.modifyTestElement((TestElement)config);
        return config;
    }

    private static Boolean nullIfUnset(JCheckBox checkBox) {
        return checkBox.isSelected() ? Boolean.valueOf(true) : null;
    }

    public void modifyTestElement(TestElement config) {
        ConfigTestElement cfg = (ConfigTestElement)config;
        ConfigTestElement el = (ConfigTestElement)this.urlConfigGui.createTestElement();
        cfg.clear();
        cfg.addConfigElement((ConfigElement)el);
        super.configureTestElement(config);
        HTTPSamplerBaseSchema.INSTANCE httpSchema = HTTPSamplerBaseSchema.INSTANCE;
        config.set(httpSchema.getRetrieveEmbeddedResources(), HttpDefaultsGui.nullIfUnset(this.retrieveEmbeddedResources));
        this.enableConcurrentDwn(this.retrieveEmbeddedResources.isSelected());
        if (this.concurrentDwn.isSelected()) {
            config.set(httpSchema.getConcurrentDownload(), Boolean.valueOf(true));
            config.set(httpSchema.getConcurrentDownloadPoolSize(), this.concurrentPool.getText());
        } else {
            config.removeProperty(httpSchema.getConcurrentDownload());
            config.removeProperty(httpSchema.getConcurrentDownloadPoolSize());
        }
        config.set(httpSchema.getStoreAsMD5(), HttpDefaultsGui.nullIfUnset(this.useMD5));
        config.set(httpSchema.getEmbeddedUrlAllowRegex(), this.embeddedAllowRE.getText());
        config.set(httpSchema.getEmbeddedUrlExcludeRegex(), this.embeddedExcludeRE.getText());
        if (!StringUtils.isEmpty((CharSequence)this.sourceIpAddr.getText())) {
            config.set(httpSchema.getIpSource(), this.sourceIpAddr.getText());
            config.set(httpSchema.getIpSourceType(), this.sourceIpType.getSelectedIndex());
        } else {
            config.removeProperty(httpSchema.getIpSource());
            config.removeProperty(httpSchema.getIpSourceType());
        }
        config.set(httpSchema.getProxy().getScheme(), this.proxyScheme.getText());
        config.set(httpSchema.getProxy().getHost(), this.proxyHost.getText());
        config.set(httpSchema.getProxy().getPort(), this.proxyPort.getText());
        config.set(httpSchema.getProxy().getUsername(), this.proxyUser.getText());
        config.set(httpSchema.getProxy().getPassword(), String.valueOf(this.proxyPass.getPassword()));
        config.set(httpSchema.getImplementation(), String.valueOf(this.httpImplementation.getSelectedItem()));
        config.set(httpSchema.getConnectTimeout(), this.connectTimeOut.getText());
        config.set(httpSchema.getResponseTimeout(), this.responseTimeOut.getText());
    }

    public void clearGui() {
        super.clearGui();
        this.retrieveEmbeddedResources.setSelected(false);
        this.concurrentDwn.setSelected(false);
        this.concurrentPool.setText(String.valueOf(6));
        this.enableConcurrentDwn(false);
        this.useMD5.setSelected(false);
        this.urlConfigGui.clear();
        this.embeddedAllowRE.setText("");
        this.embeddedExcludeRE.setText("");
        this.sourceIpAddr.setText("");
        this.sourceIpType.setSelectedIndex(HTTPSamplerBase.SourceType.HOSTNAME.ordinal());
        this.proxyScheme.setText("");
        this.proxyHost.setText("");
        this.proxyPort.setText("");
        this.proxyUser.setText("");
        this.proxyPass.setText("");
        this.httpImplementation.setSelectedItem("");
        this.connectTimeOut.setText("");
        this.responseTimeOut.setText("");
    }

    public void configure(TestElement el) {
        super.configure(el);
        AbstractTestElement samplerBase = (AbstractTestElement)el;
        this.urlConfigGui.configure(el);
        HTTPSamplerBaseSchema.INSTANCE httpSchema = HTTPSamplerBaseSchema.INSTANCE;
        this.retrieveEmbeddedResources.setSelected(samplerBase.get(httpSchema.getRetrieveEmbeddedResources()));
        this.concurrentDwn.setSelected(samplerBase.get(httpSchema.getConcurrentDownload()));
        this.concurrentPool.setText(samplerBase.getPropertyAsString(httpSchema.getConcurrentDownloadPoolSize().getName(), ""));
        this.useMD5.setSelected(samplerBase.get(httpSchema.getStoreAsMD5()));
        this.embeddedAllowRE.setText(samplerBase.get(httpSchema.getEmbeddedUrlAllowRegex()));
        this.embeddedExcludeRE.setText(samplerBase.get(httpSchema.getEmbeddedUrlExcludeRegex()));
        this.sourceIpAddr.setText(samplerBase.get(httpSchema.getIpSource()));
        this.sourceIpType.setSelectedIndex(samplerBase.get(httpSchema.getIpSourceType()));
        this.proxyScheme.setText(samplerBase.getString(httpSchema.getProxy().getScheme()));
        this.proxyHost.setText(samplerBase.getString(httpSchema.getProxy().getHost()));
        this.proxyPort.setText(samplerBase.getString(httpSchema.getProxy().getPort()));
        this.proxyUser.setText(samplerBase.getString(httpSchema.getProxy().getUsername()));
        this.proxyPass.setText(samplerBase.getString(httpSchema.getProxy().getPassword()));
        this.httpImplementation.setSelectedItem(samplerBase.getString(httpSchema.getImplementation()));
        this.connectTimeOut.setText(samplerBase.getString(httpSchema.getConnectTimeout()));
        this.responseTimeOut.setText(samplerBase.getString(httpSchema.getResponseTimeout()));
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.urlConfigGui = new UrlConfigGui(false, true, false);
        HorizontalPanel httpOptions = new HorizontalPanel();
        httpOptions.add(this.getImplementationPanel());
        httpOptions.add(this.getTimeOutPanel());
        VerticalPanel advancedPanel = new VerticalPanel();
        advancedPanel.add((Component)httpOptions);
        advancedPanel.add(this.createEmbeddedRsrcPanel());
        advancedPanel.add(this.createSourceAddrPanel());
        advancedPanel.add(this.getProxyServerPanel());
        advancedPanel.add(this.createOptionalTasksPanel());
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add(JMeterUtils.getResString((String)"web_testing_basic"), this.urlConfigGui);
        tabbedPane.add(JMeterUtils.getResString((String)"web_testing_advanced"), (Component)advancedPanel);
        JPanel emptyPanel = new JPanel();
        emptyPanel.setMaximumSize(new Dimension());
        this.add(this.makeTitlePanel(), "North");
        this.add(tabbedPane, "Center");
        this.add(emptyPanel, "South");
    }

    private JPanel getTimeOutPanel() {
        HorizontalPanel timeOut = new HorizontalPanel();
        timeOut.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"web_server_timeout_title")));
        JPanel connPanel = this.getConnectTimeOutPanel();
        JPanel reqPanel = this.getResponseTimeOutPanel();
        timeOut.add(connPanel);
        timeOut.add(reqPanel);
        return timeOut;
    }

    private JPanel getConnectTimeOutPanel() {
        this.connectTimeOut = new JTextField(10);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"web_server_timeout_connect"));
        label.setLabelFor(this.connectTimeOut);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.connectTimeOut, "Center");
        return panel;
    }

    private JPanel getResponseTimeOutPanel() {
        this.responseTimeOut = new JTextField(10);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"web_server_timeout_response"));
        label.setLabelFor(this.responseTimeOut);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.responseTimeOut, "Center");
        return panel;
    }

    protected JPanel createEmbeddedRsrcPanel() {
        this.retrieveEmbeddedResources = new JCheckBox(JMeterUtils.getResString((String)"web_testing_retrieve_images"));
        this.retrieveEmbeddedResources.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.enableConcurrentDwn(true);
            } else {
                this.enableConcurrentDwn(false);
            }
        });
        this.concurrentDwn = new JCheckBox(JMeterUtils.getResString((String)"web_testing_concurrent_download"));
        this.concurrentDwn.addItemListener(e -> {
            if (this.retrieveEmbeddedResources.isSelected() && e.getStateChange() == 1) {
                this.concurrentPool.setEnabled(true);
            } else {
                this.concurrentPool.setEnabled(false);
            }
        });
        this.concurrentPool = new JTextField(2);
        this.concurrentPool.setMinimumSize(new Dimension(10, (int)this.concurrentPool.getPreferredSize().getHeight()));
        this.concurrentPool.setMaximumSize(new Dimension(60, (int)this.concurrentPool.getPreferredSize().getHeight()));
        JPanel embeddedRsrcPanel = new JPanel((LayoutManager)new MigLayout());
        embeddedRsrcPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"web_testing_retrieve_title")));
        embeddedRsrcPanel.add(this.retrieveEmbeddedResources);
        embeddedRsrcPanel.add(this.concurrentDwn);
        embeddedRsrcPanel.add((Component)this.concurrentPool, "wrap");
        this.embeddedAllowRE = HttpDefaultsGui.addTextFieldWithLabel(embeddedRsrcPanel, JMeterUtils.getResString((String)"web_testing_embedded_url_pattern"));
        this.embeddedExcludeRE = HttpDefaultsGui.addTextFieldWithLabel(embeddedRsrcPanel, JMeterUtils.getResString((String)"web_testing_embedded_url_exclude_pattern"));
        return embeddedRsrcPanel;
    }

    private static JTextField addTextFieldWithLabel(JPanel panel, String labelText) {
        JLabel label = new JLabel(labelText);
        JTextField field = new JTextField(100);
        label.setLabelFor(field);
        panel.add(label);
        panel.add((Component)field, "span");
        return field;
    }

    protected JPanel createSourceAddrPanel() {
        HorizontalPanel sourceAddrPanel = new HorizontalPanel();
        sourceAddrPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"web_testing_source_ip")));
        this.sourceIpType.setSelectedIndex(HTTPSamplerBase.SourceType.HOSTNAME.ordinal());
        sourceAddrPanel.add(this.sourceIpType);
        this.sourceIpAddr = new JTextField();
        sourceAddrPanel.add(this.sourceIpAddr);
        return sourceAddrPanel;
    }

    protected JPanel createOptionalTasksPanel() {
        VerticalPanel checkBoxPanel = new VerticalPanel();
        checkBoxPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"optional_tasks")));
        this.useMD5 = new JCheckBox(JMeterUtils.getResString((String)"response_save_as_md5"));
        checkBoxPanel.add(this.useMD5);
        return checkBoxPanel;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    private void enableConcurrentDwn(boolean enable) {
        this.concurrentDwn.setEnabled(enable);
        this.embeddedAllowRE.setEnabled(enable);
        this.embeddedExcludeRE.setEnabled(enable);
        this.concurrentPool.setEnabled(this.concurrentDwn.isSelected() && enable);
    }

    protected final JPanel getImplementationPanel() {
        HorizontalPanel implPanel = new HorizontalPanel();
        implPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"web_server_client")));
        implPanel.add(new JLabel(JMeterUtils.getResString((String)"http_implementation")));
        this.httpImplementation.addItem("");
        implPanel.add(this.httpImplementation);
        return implPanel;
    }

    protected final JPanel getProxyServerPanel() {
        HorizontalPanel proxyServer = new HorizontalPanel();
        proxyServer.add((Component)this.getProxySchemePanel(), "West");
        proxyServer.add((Component)this.getProxyHostPanel(), "Center");
        proxyServer.add((Component)this.getProxyPortPanel(), "East");
        HorizontalPanel proxyLogin = new HorizontalPanel();
        proxyLogin.add(this.getProxyUserPanel());
        proxyLogin.add(this.getProxyPassPanel());
        HorizontalPanel proxyServerPanel = new HorizontalPanel();
        proxyServerPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"web_proxy_server_title")));
        proxyServerPanel.add((Component)proxyServer);
        proxyServerPanel.add((Component)proxyLogin);
        return proxyServerPanel;
    }

    private JPanel getProxySchemePanel() {
        this.proxyScheme = new JTextField(5);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"web_proxy_scheme"));
        label.setLabelFor(this.proxyScheme);
        JFactory.small((JLabel)label);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.proxyScheme, "Center");
        return panel;
    }

    private JPanel getProxyHostPanel() {
        this.proxyHost = new JTextField(10);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"web_server_domain"));
        label.setLabelFor(this.proxyHost);
        JFactory.small((JLabel)label);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.proxyHost, "Center");
        return panel;
    }

    private JPanel getProxyPortPanel() {
        this.proxyPort = new JTextField(10);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"web_server_port"));
        label.setLabelFor(this.proxyPort);
        JFactory.small((JLabel)label);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.proxyPort, "Center");
        return panel;
    }

    private JPanel getProxyUserPanel() {
        this.proxyUser = new JTextField(5);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"username"));
        label.setLabelFor(this.proxyUser);
        JFactory.small((JLabel)label);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.proxyUser, "Center");
        return panel;
    }

    private JPanel getProxyPassPanel() {
        this.proxyPass = new JPasswordField(5);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"password"));
        label.setLabelFor(this.proxyPass);
        JFactory.small((JLabel)label);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.proxyPass, "Center");
        return panel;
    }
}

