/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.sampler;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSession;
import org.apache.http.HttpConnectionMetrics;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.conn.ClientConnectionOperator;
import org.apache.http.conn.ClientConnectionRequest;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.ManagedClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.jmeter.protocol.http.sampler.JMeterClientConnectionOperator;
import org.apache.jmeter.protocol.http.sampler.hc.JMeterPoolingClientConnectionManager;
import org.apache.jmeter.samplers.SampleResult;

public class MeasuringConnectionManager
extends JMeterPoolingClientConnectionManager {
    public MeasuringConnectionManager(SchemeRegistry schemeRegistry, DnsResolver resolver, int timeToLiveMs, int validateAfterInactivityMs) {
        super(schemeRegistry, timeToLiveMs, TimeUnit.MILLISECONDS, resolver, validateAfterInactivityMs);
    }

    @Override
    public ClientConnectionRequest requestConnection(HttpRoute route, Object state) {
        ClientConnectionRequest res = super.requestConnection(route, state);
        return new MeasuringConnectionRequest(res);
    }

    @Override
    protected ClientConnectionOperator createConnectionOperator(SchemeRegistry schreg) {
        return new JMeterClientConnectionOperator(schreg, this.getDnsResolver());
    }

    private static class MeasuredConnection
    implements ManagedClientConnection {
        private final ManagedClientConnection handler;

        public MeasuredConnection(ManagedClientConnection res) {
            this.handler = res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void open(HttpRoute route, HttpContext context, HttpParams params) throws IOException {
            try {
                this.handler.open(route, context, params);
            }
            finally {
                SampleResult sample = (SampleResult)context.getAttribute("__jmeter.SAMPLER_RESULT__");
                if (sample != null) {
                    sample.connectEnd();
                }
            }
        }

        public boolean isSecure() {
            return this.handler.isSecure();
        }

        public HttpRoute getRoute() {
            return this.handler.getRoute();
        }

        public SSLSession getSSLSession() {
            return this.handler.getSSLSession();
        }

        public void tunnelTarget(boolean secure, HttpParams params) throws IOException {
            this.handler.tunnelTarget(secure, params);
        }

        public void tunnelProxy(HttpHost next, boolean secure, HttpParams params) throws IOException {
            this.handler.tunnelProxy(next, secure, params);
        }

        public void layerProtocol(HttpContext context, HttpParams params) throws IOException {
            this.handler.layerProtocol(context, params);
        }

        public void markReusable() {
            this.handler.markReusable();
        }

        public void unmarkReusable() {
            this.handler.unmarkReusable();
        }

        public boolean isMarkedReusable() {
            return this.handler.isMarkedReusable();
        }

        public void setState(Object state) {
            this.handler.setState(state);
        }

        public Object getState() {
            return this.handler.getState();
        }

        public void setIdleDuration(long duration, TimeUnit unit) {
            this.handler.setIdleDuration(duration, unit);
        }

        public void releaseConnection() throws IOException {
            this.handler.releaseConnection();
        }

        public void abortConnection() throws IOException {
            this.handler.abortConnection();
        }

        public boolean isResponseAvailable(int timeout) throws IOException {
            return this.handler.isResponseAvailable(timeout);
        }

        public void sendRequestHeader(HttpRequest request) throws HttpException, IOException {
            this.handler.sendRequestHeader(request);
        }

        public void sendRequestEntity(HttpEntityEnclosingRequest request) throws HttpException, IOException {
            this.handler.sendRequestEntity(request);
        }

        public HttpResponse receiveResponseHeader() throws HttpException, IOException {
            return this.handler.receiveResponseHeader();
        }

        public void receiveResponseEntity(HttpResponse response) throws HttpException, IOException {
            this.handler.receiveResponseEntity(response);
        }

        public void flush() throws IOException {
            this.handler.flush();
        }

        public InetAddress getLocalAddress() {
            return this.handler.getLocalAddress();
        }

        public int getLocalPort() {
            return this.handler.getLocalPort();
        }

        public InetAddress getRemoteAddress() {
            return this.handler.getRemoteAddress();
        }

        public int getRemotePort() {
            return this.handler.getRemotePort();
        }

        public void close() throws IOException {
            this.handler.close();
        }

        public boolean isOpen() {
            return this.handler.isOpen();
        }

        public boolean isStale() {
            return this.handler.isStale();
        }

        public void setSocketTimeout(int timeout) {
            this.handler.setSocketTimeout(timeout);
        }

        public int getSocketTimeout() {
            return this.handler.getSocketTimeout();
        }

        public void shutdown() throws IOException {
            this.handler.shutdown();
        }

        public HttpConnectionMetrics getMetrics() {
            return this.handler.getMetrics();
        }

        public void bind(Socket arg0) throws IOException {
            this.handler.bind(arg0);
        }

        public String getId() {
            return this.handler.getId();
        }

        public Socket getSocket() {
            return this.handler.getSocket();
        }
    }

    private static class MeasuringConnectionRequest
    implements ClientConnectionRequest {
        private final ClientConnectionRequest handler;

        public MeasuringConnectionRequest(ClientConnectionRequest res) {
            this.handler = res;
        }

        public ManagedClientConnection getConnection(long timeout, TimeUnit tunit) throws InterruptedException, ConnectionPoolTimeoutException {
            ManagedClientConnection res = this.handler.getConnection(timeout, tunit);
            return new MeasuredConnection(res);
        }

        public void abortRequest() {
            this.handler.abortRequest();
        }
    }
}

