/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.modifier;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.processor.PreProcessor;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.threads.JMeterVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegExUserParameters
extends AbstractTestElement
implements Serializable,
PreProcessor {
    private static final String REGEX_GROUP_SUFFIX = "_g";
    private static final String MATCH_NR = "matchNr";
    private static final long serialVersionUID = 5486502839185386121L;
    private static final Logger log = LoggerFactory.getLogger(RegExUserParameters.class);
    public static final String REG_EX_REF_NAME = "RegExUserParameters.regex_ref_name";
    public static final String REG_EX_PARAM_NAMES_GR_NR = "RegExUserParameters.param_names_gr_nr";
    public static final String REG_EX_PARAM_VALUES_GR_NR = "RegExUserParameters.param_values_gr_nr";

    public void process() {
        Sampler entry;
        if (log.isDebugEnabled()) {
            log.debug(Thread.currentThread().getName() + " Running up named: " + this.getName());
        }
        if (!((entry = this.getThreadContext().getCurrentSampler()) instanceof HTTPSamplerBase)) {
            return;
        }
        Map<String, String> paramMap = this.buildParamsMap();
        if (paramMap == null || paramMap.isEmpty()) {
            log.info("RegExUserParameters element:" + this.getName() + " => Referenced RegExp was not found, no parameter will be changed");
            return;
        }
        HTTPSamplerBase sampler = (HTTPSamplerBase)entry;
        for (JMeterProperty jMeterProperty : sampler.getArguments()) {
            Argument arg = (Argument)jMeterProperty.getObjectValue();
            String oldValue = arg.getValue();
            String val = paramMap.get(arg.getName());
            if (val != null) {
                arg.setValue(val);
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("RegExUserParameters element:" + this.getName() + " => changed parameter: " + arg.getName() + " = " + arg.getValue() + ", was:" + oldValue);
        }
    }

    private Map<String, String> buildParamsMap() {
        String regExRefName = this.getRegExRefName() + "_";
        String grNames = this.getRegParamNamesGrNr();
        String grValues = this.getRegExParamValuesGrNr();
        JMeterVariables jmvars = this.getThreadContext().getVariables();
        if (jmvars.get(regExRefName + MATCH_NR) == null || jmvars.get(regExRefName + 1 + REGEX_GROUP_SUFFIX + grNames) == null || jmvars.get(regExRefName + 1 + REGEX_GROUP_SUFFIX + grValues) == null) {
            return null;
        }
        int n = Integer.parseInt(jmvars.get(regExRefName + MATCH_NR));
        HashMap<String, String> map = new HashMap<String, String>(n);
        for (int i = 1; i <= n; ++i) {
            map.put(jmvars.get(regExRefName + i + REGEX_GROUP_SUFFIX + grNames), jmvars.get(regExRefName + i + REGEX_GROUP_SUFFIX + grValues));
        }
        return map;
    }

    public Object clone() {
        RegExUserParameters up = (RegExUserParameters)super.clone();
        return up;
    }

    public void setRegExRefName(String str) {
        this.setProperty(REG_EX_REF_NAME, str);
    }

    public String getRegExRefName() {
        return this.getPropertyAsString(REG_EX_REF_NAME);
    }

    public void setRegExParamNamesGrNr(String str) {
        this.setProperty(REG_EX_PARAM_NAMES_GR_NR, str);
    }

    public String getRegParamNamesGrNr() {
        return this.getPropertyAsString(REG_EX_PARAM_NAMES_GR_NR);
    }

    public void setRegExParamValuesGrNr(String str) {
        this.setProperty(REG_EX_PARAM_VALUES_GR_NR, str);
    }

    public String getRegExParamValuesGrNr() {
        return this.getPropertyAsString(REG_EX_PARAM_VALUES_GR_NR);
    }
}

