/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.util.accesslog;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.protocol.http.util.accesslog.Filter;
import org.apache.jmeter.protocol.http.util.accesslog.LogParser;
import org.apache.jmeter.protocol.http.util.accesslog.NVPair;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCLogParser
implements LogParser {
    protected static final Logger log = LoggingManager.getLoggerForClass();
    public static final String GET = "GET";
    public static final String POST = "POST";
    public static final String HEAD = "HEAD";
    protected String RMETHOD = null;
    protected String URL_PATH = null;
    protected boolean useFILE = true;
    protected File SOURCE = null;
    protected String FILENAME = null;
    protected BufferedReader READER = null;
    protected Filter FILTER = null;
    protected boolean decode = true;

    public TCLogParser() {
    }

    public TCLogParser(String source) {
        this.setSourceFile(source);
    }

    public void setDecodeParameterValues(boolean decodeparams) {
        this.decode = decodeparams;
    }

    public boolean decodeParameterValue() {
        return this.decode;
    }

    public void setUseParsedFile(boolean file) {
        this.useFILE = file;
    }

    @Override
    public void setFilter(Filter filter) {
        this.FILTER = filter;
    }

    @Override
    public void setSourceFile(String source) {
        this.FILENAME = source;
    }

    public int parse(TestElement el, int parseCount) {
        if (this.SOURCE == null) {
            this.SOURCE = new File(this.FILENAME);
        }
        try {
            if (this.READER == null) {
                this.READER = TCLogParser.getReader(this.SOURCE);
            }
            return this.parse(this.READER, el, parseCount);
        }
        catch (Exception exception) {
            log.error("Problem creating samples", (Throwable)exception);
            return -1;
        }
    }

    private static BufferedReader getReader(File file) throws IOException {
        if (!TCLogParser.isGZIP(file)) {
            return new BufferedReader(new FileReader(file));
        }
        GZIPInputStream in = new GZIPInputStream(new FileInputStream(file));
        return new BufferedReader(new InputStreamReader(in));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isGZIP(File file) throws IOException {
        boolean bl;
        FileInputStream in = new FileInputStream(file);
        try {
            bl = in.read() == 31 && in.read() == 139;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            in.close();
            throw throwable;
        }
        in.close();
        return bl;
    }

    @Override
    public int parseAndConfigure(int count, TestElement el) {
        return this.parse(el, count);
    }

    protected int parse(BufferedReader breader, TestElement el, int parseCount) {
        int actualCount = 0;
        String line = null;
        try {
            line = breader.readLine();
            while (line != null) {
                if (line.length() > 0) {
                    actualCount += this.parseLine(line, el);
                }
                if (parseCount != -1 && actualCount >= parseCount) break;
                line = breader.readLine();
            }
            if (line == null) {
                breader.close();
                this.READER = null;
            }
        }
        catch (IOException ioe) {
            log.error("Error reading log file", (Throwable)ioe);
        }
        return actualCount;
    }

    protected int parseLine(String line, TestElement el) {
        int count = 0;
        String cleanedLine = this.cleanURL(line);
        log.debug("parsing line: " + line);
        el.setProperty("HTTPSampler.method", this.RMETHOD);
        if (this.FILTER != null) {
            log.debug("filter is not null");
            if (!this.FILTER.isFiltered(line, el)) {
                log.debug("line was not filtered");
                ++count;
                line = this.FILTER.filter(cleanedLine);
                if (line != null) {
                    this.createUrl(line, el);
                }
            } else {
                log.debug("Line was filtered");
            }
        } else {
            log.debug("filter was null");
            ++count;
            this.createUrl(cleanedLine, el);
        }
        return count;
    }

    private void createUrl(String line, TestElement el) {
        String paramString = null;
        paramString = this.stripFile(line, el);
        if (paramString != null) {
            this.checkParamFormat(line);
            this.convertStringToJMRequest(paramString, el);
        }
    }

    public String cleanURL(String entry) {
        String url = entry;
        if (entry.indexOf(34) > -1 && this.checkMethod(entry)) {
            StringTokenizer tokens = null;
            tokens = this.tokenize(entry, "\"");
            block0: while (tokens.hasMoreTokens()) {
                String toke = tokens.nextToken();
                if (!this.checkMethod(toke)) continue;
                StringTokenizer token2 = this.tokenize(toke, " ");
                while (token2.hasMoreTokens()) {
                    String t = (String)token2.nextElement();
                    if (t.equalsIgnoreCase(GET)) {
                        this.RMETHOD = GET;
                    } else if (t.equalsIgnoreCase(POST)) {
                        this.RMETHOD = POST;
                    } else if (t.equalsIgnoreCase(HEAD)) {
                        this.RMETHOD = HEAD;
                    }
                    if (!t.startsWith("/")) continue;
                    url = t;
                    break block0;
                }
                break block0;
            }
            return url;
        }
        return url;
    }

    public boolean checkMethod(String text) {
        if (text.indexOf(GET) > -1) {
            this.RMETHOD = GET;
            return true;
        }
        if (text.indexOf(POST) > -1) {
            this.RMETHOD = POST;
            return true;
        }
        if (text.indexOf(HEAD) > -1) {
            this.RMETHOD = HEAD;
            return true;
        }
        return false;
    }

    public String stripFile(String url, TestElement el) {
        if (url.indexOf(63) > -1) {
            StringTokenizer tokens = this.tokenize(url, "?");
            this.URL_PATH = tokens.nextToken();
            el.setProperty("HTTPSampler.path", this.URL_PATH);
            return tokens.hasMoreTokens() ? tokens.nextToken() : null;
        }
        el.setProperty("HTTPSampler.path", url);
        return null;
    }

    public boolean checkURL(String url) {
        return url.indexOf(63) > -1;
    }

    public boolean checkParamFormat(String text) {
        return text.indexOf(38) > -1 && text.indexOf(61) > -1;
    }

    public void convertStringToJMRequest(String text, TestElement el) {
        ((HTTPSamplerBase)el).parseArguments(text);
    }

    public NVPair[] convertStringtoNVPair(String stringparams) {
        List<String> vparams = this.parseParameters(stringparams);
        NVPair[] nvparams = new NVPair[vparams.size()];
        for (int idx = 0; idx < nvparams.length; ++idx) {
            nvparams[idx] = this.parseOneParameter(vparams.get(idx));
        }
        return nvparams;
    }

    protected NVPair parseOneParameter(String parameter) {
        String name = "";
        String value = null;
        try {
            StringTokenizer param = this.tokenize(parameter, "=");
            name = param.nextToken();
            value = param.nextToken();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (value == null) {
            value = "";
        } else if (this.decode) {
            try {
                value = URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.warn(e.getMessage());
            }
        }
        return new NVPair(name.trim(), value.trim());
    }

    protected List<String> parseParameters(String parameters) {
        ArrayList<String> parsedParams = new ArrayList<String>();
        StringTokenizer paramtokens = this.tokenize(parameters, "&");
        while (paramtokens.hasMoreElements()) {
            parsedParams.add(paramtokens.nextToken());
        }
        return parsedParams;
    }

    public StringTokenizer tokenize(String line, String delim) {
        return new StringTokenizer(line, delim);
    }

    @Override
    public void close() {
        try {
            this.READER.close();
            this.READER = null;
            this.SOURCE = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

