/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.proxy;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.protocol.http.config.MultipartUrlConfig;
import org.apache.jmeter.protocol.http.control.gui.HttpTestSampleGui;
import org.apache.jmeter.protocol.http.proxy.AbstractSamplerCreator;
import org.apache.jmeter.protocol.http.proxy.HttpRequestHdr;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerFactory;
import org.apache.jmeter.protocol.http.util.ConversionUtils;
import org.apache.jmeter.protocol.http.util.HTTPFileArg;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSamplerCreator
extends AbstractSamplerCreator {
    private static final Logger log = LoggingManager.getLoggerForClass();

    @Override
    public String[] getManagedContentTypes() {
        return new String[0];
    }

    @Override
    public HTTPSamplerBase createSampler(HttpRequestHdr request, Map<String, String> pageEncodings, Map<String, String> formEncodings) {
        HTTPSamplerBase sampler = HTTPSamplerFactory.newInstance(request.getHttpSamplerName());
        sampler.setProperty("TestElement.gui_class", HttpTestSampleGui.class.getName());
        sampler.setFollowRedirects(false);
        sampler.setUseKeepAlive(true);
        if (log.isDebugEnabled()) {
            log.debug("getSampler: sampler path = " + sampler.getPath());
        }
        return sampler;
    }

    @Override
    public final void populateSampler(HTTPSamplerBase sampler, HttpRequestHdr request, Map<String, String> pageEncodings, Map<String, String> formEncodings) throws Exception {
        this.computeFromHeader(sampler, request, pageEncodings, formEncodings);
        this.computeFromPostBody(sampler, request);
        if (log.isDebugEnabled()) {
            log.debug("sampler path = " + sampler.getPath());
        }
    }

    protected void computeFromHeader(HTTPSamplerBase sampler, HttpRequestHdr request, Map<String, String> pageEncodings, Map<String, String> formEncodings) throws Exception {
        this.computeDomain(sampler, request);
        this.computeMethod(sampler, request);
        this.computePort(sampler, request);
        this.computeProtocol(sampler, request);
        this.computeContentEncoding(sampler, request, pageEncodings, formEncodings);
        this.computePath(sampler, request);
        this.computeSamplerName(sampler, request);
    }

    protected void computeFromPostBody(HTTPSamplerBase sampler, HttpRequestHdr request) throws Exception {
        if (!"CONNECT".equals(request.getMethod()) && !"GET".equals(request.getMethod())) {
            String contentType = request.getContentType();
            MultipartUrlConfig urlConfig = request.getMultipartConfig(contentType);
            String contentEncoding = sampler.getContentEncoding();
            String postData = null;
            if (log.isDebugEnabled()) {
                if (!StringUtils.isEmpty((CharSequence)contentEncoding)) {
                    log.debug("Using encoding " + contentEncoding + " for request body");
                } else {
                    log.debug("No encoding found, using JRE default encoding for request body");
                }
            }
            postData = !StringUtils.isEmpty((CharSequence)contentEncoding) ? new String(request.getRawPostData(), contentEncoding) : new String(request.getRawPostData(), "ISO-8859-1");
            if (urlConfig != null) {
                urlConfig.parseArguments(postData);
                sampler.setDoMultipartPost(true);
                request.getHeaderManager().removeHeaderNamed("content-type");
                request.getHeaderManager().removeHeaderNamed("content-length");
                sampler.setArguments(urlConfig.getArguments());
                sampler.setHTTPFiles(urlConfig.getHTTPFileArgs().asArray());
            } else if (postData.trim().startsWith("<?") || "PUT".equals(sampler.getMethod())) {
                sampler.addNonEncodedArgument("", postData, "");
            } else if (contentType == null || contentType.startsWith("application/x-www-form-urlencoded")) {
                sampler.parseArguments(postData.trim(), contentEncoding);
            } else if (postData.length() > 0) {
                if (this.isBinaryContent(contentType)) {
                    try {
                        File tempDir = new File(this.getBinaryDirectory());
                        File out = File.createTempFile(request.getMethod(), this.getBinaryFileSuffix(), tempDir);
                        FileUtils.writeByteArrayToFile((File)out, (byte[])request.getRawPostData());
                        HTTPFileArg[] files = new HTTPFileArg[]{new HTTPFileArg(out.getPath(), "", contentType)};
                        sampler.setHTTPFiles(files);
                    }
                    catch (IOException e) {
                        log.warn("Could not create binary file: " + e);
                    }
                } else {
                    sampler.addNonEncodedArgument("", postData, "");
                }
            }
        }
    }

    protected void computeSamplerName(HTTPSamplerBase sampler, HttpRequestHdr request) {
        if (!"CONNECT".equals(request.getMethod()) && DefaultSamplerCreator.isNumberRequests()) {
            DefaultSamplerCreator.incrementRequestNumber();
            sampler.setName(DefaultSamplerCreator.getRequestNumber() + " " + sampler.getPath());
        } else {
            sampler.setName(sampler.getPath());
        }
    }

    protected void computePath(HTTPSamplerBase sampler, HttpRequestHdr request) {
        if (sampler.getContentEncoding() != null) {
            sampler.setPath(request.getPath(), sampler.getContentEncoding());
        } else {
            sampler.setPath(request.getPath(), null);
        }
        if (log.isDebugEnabled()) {
            log.debug("Proxy: setting path: " + sampler.getPath());
        }
    }

    protected void computeContentEncoding(HTTPSamplerBase sampler, HttpRequestHdr request, Map<String, String> pageEncodings, Map<String, String> formEncodings) throws MalformedURLException {
        URL pageUrl = null;
        pageUrl = sampler.isProtocolDefaultPort() ? new URL(sampler.getProtocol(), sampler.getDomain(), request.getPath()) : new URL(sampler.getProtocol(), sampler.getDomain(), sampler.getPort(), request.getPath());
        String urlWithoutQuery = request.getUrlWithoutQuery(pageUrl);
        String contentEncoding = this.computeContentEncoding(request, pageEncodings, formEncodings, urlWithoutQuery);
        if (!StringUtils.isEmpty((CharSequence)contentEncoding)) {
            sampler.setContentEncoding(contentEncoding);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String computeContentEncoding(HttpRequestHdr request, Map<String, String> pageEncodings, Map<String, String> formEncodings, String urlWithoutQuery) {
        String contentEncoding = null;
        String requestContentEncoding = ConversionUtils.getEncodingFromContentType(request.getContentType());
        if (requestContentEncoding != null) {
            contentEncoding = requestContentEncoding;
        } else {
            Map<String, String> map;
            if (pageEncodings != null) {
                map = pageEncodings;
                synchronized (map) {
                    contentEncoding = pageEncodings.get(urlWithoutQuery);
                }
            }
            if (formEncodings != null) {
                map = formEncodings;
                synchronized (map) {
                    String formEncoding = formEncodings.get(urlWithoutQuery);
                    if (formEncoding != null) {
                        contentEncoding = formEncoding;
                    }
                }
            }
        }
        return contentEncoding;
    }

    protected void computeProtocol(HTTPSamplerBase sampler, HttpRequestHdr request) {
        sampler.setProtocol(request.getProtocol(sampler));
    }

    protected void computePort(HTTPSamplerBase sampler, HttpRequestHdr request) {
        sampler.setPort(request.serverPort());
        if (log.isDebugEnabled()) {
            log.debug("Proxy: setting port: " + sampler.getPort());
        }
    }

    protected void computeMethod(HTTPSamplerBase sampler, HttpRequestHdr request) {
        sampler.setMethod(request.getMethod());
        log.debug("Proxy: setting method: " + sampler.getMethod());
    }

    protected void computeDomain(HTTPSamplerBase sampler, HttpRequestHdr request) {
        sampler.setDomain(request.serverName());
        if (log.isDebugEnabled()) {
            log.debug("Proxy: setting server: " + sampler.getDomain());
        }
    }
}

