/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.util;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.net.URL;
import org.apache.jmeter.protocol.http.sampler.HTTPSampleResult;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.SampleSaveConfiguration;
import org.apache.jmeter.save.converters.SampleResultConverter;

public class HTTPResultConverter
extends SampleResultConverter {
    public static String getVersion() {
        return "$Revision: 959057 $";
    }

    public HTTPResultConverter(Mapper arg0) {
        super(arg0);
    }

    public boolean canConvert(Class arg0) {
        return HTTPSampleResult.class.equals((Object)arg0);
    }

    public void marshal(Object obj, HierarchicalStreamWriter writer, MarshallingContext context) {
        HTTPSampleResult res = (HTTPSampleResult)((Object)obj);
        SampleSaveConfiguration save = res.getSaveConfig();
        this.setAttributes(writer, context, res, save);
        this.saveAssertions(writer, context, res, save);
        this.saveSubResults(writer, context, res, save);
        this.saveResponseHeaders(writer, context, res, save);
        this.saveRequestHeaders(writer, context, res, save);
        this.saveResponseData(writer, context, res, save);
        this.saveSamplerData(writer, context, res, save);
    }

    private void saveSamplerData(HierarchicalStreamWriter writer, MarshallingContext context, HTTPSampleResult res, SampleSaveConfiguration save) {
        if (save.saveSamplerData((SampleResult)res)) {
            this.writeString(writer, "cookies", res.getCookies());
            this.writeString(writer, "method", res.getHTTPMethod());
            this.writeString(writer, "queryString", res.getQueryString());
            this.writeString(writer, "redirectLocation", res.getRedirectLocation());
        }
        if (save.saveUrl()) {
            this.writeItem(res.getURL(), context, writer);
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        HTTPSampleResult res = (HTTPSampleResult)((Object)this.createCollection(context.getRequiredType()));
        this.retrieveAttributes(reader, context, res);
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            Object subItem = this.readItem(reader, context, (Object)res);
            if (!this.retrieveItem(reader, context, res, subItem)) {
                this.retrieveHTTPItem(reader, context, res, subItem);
            }
            reader.moveUp();
        }
        String resultFileName = res.getResultFileName();
        if (resultFileName.length() > 0 && res.getResponseData().length == 0) {
            this.readFile(resultFileName, res);
        }
        return res;
    }

    private void retrieveHTTPItem(HierarchicalStreamReader reader, UnmarshallingContext context, HTTPSampleResult res, Object subItem) {
        if (subItem instanceof URL) {
            res.setURL((URL)subItem);
        } else if (reader.getNodeName().equals("cookies")) {
            res.setCookies((String)subItem);
        } else if (reader.getNodeName().equals("method")) {
            res.setHTTPMethod((String)subItem);
        } else if (reader.getNodeName().equals("queryString")) {
            res.setQueryString((String)subItem);
        } else if (reader.getNodeName().equals("redirectLocation")) {
            res.setRedirectLocation((String)subItem);
        }
    }
}

