/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.protocol.http.control.CacheManager;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.layout.VerticalLayout;

public class CacheManagerGui
extends AbstractConfigGui {
    private static final long serialVersionUID = 240L;
    private JCheckBox clearEachIteration;
    private JCheckBox useExpires;
    private JTextField maxCacheSize;

    public CacheManagerGui() {
        this.init();
    }

    public String getLabelResource() {
        return "cache_manager_title";
    }

    public void configure(TestElement element) {
        super.configure(element);
        CacheManager cacheManager = (CacheManager)element;
        this.clearEachIteration.setSelected(cacheManager.getClearEachIteration());
        this.useExpires.setSelected(cacheManager.getUseExpires());
        this.maxCacheSize.setText(Integer.toString(cacheManager.getMaxSize()));
    }

    public TestElement createTestElement() {
        CacheManager element = new CacheManager();
        this.modifyTestElement((TestElement)element);
        return element;
    }

    public void modifyTestElement(TestElement element) {
        this.configureTestElement(element);
        CacheManager cacheManager = (CacheManager)element;
        cacheManager.setClearEachIteration(this.clearEachIteration.isSelected());
        cacheManager.setUseExpires(this.useExpires.isSelected());
        try {
            cacheManager.setMaxSize(Integer.parseInt(this.maxCacheSize.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void clearGui() {
        super.clearGui();
        this.clearEachIteration.setSelected(false);
        this.useExpires.setSelected(false);
        this.maxCacheSize.setText("");
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.clearEachIteration = new JCheckBox(JMeterUtils.getResString((String)"clear_cache_per_iter"), false);
        this.useExpires = new JCheckBox(JMeterUtils.getResString((String)"use_expires"), false);
        JPanel northPanel = new JPanel();
        northPanel.setLayout((LayoutManager)new VerticalLayout(5, 3));
        northPanel.add(this.makeTitlePanel());
        northPanel.add(this.clearEachIteration);
        northPanel.add(this.useExpires);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"cache_manager_size"));
        this.maxCacheSize = new JTextField(20);
        this.maxCacheSize.setName("maxSize");
        label.setLabelFor(this.maxCacheSize);
        JPanel maxCacheSizePanel = new JPanel(new BorderLayout(5, 0));
        maxCacheSizePanel.add((Component)label, "West");
        maxCacheSizePanel.add((Component)this.maxCacheSize, "Center");
        northPanel.add(maxCacheSizePanel);
        this.add(northPanel, "North");
    }
}

