/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongSum
extends AbstractFunction {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final List<String> desc = new LinkedList<String>();
    private static final String KEY = "__longSum";
    private Object[] values;

    public synchronized String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        JMeterVariables vars = this.getVariables();
        long sum = 0L;
        String varName = ((CompoundVariable)this.values[this.values.length - 1]).execute().trim();
        for (int i = 0; i < this.values.length - 1; ++i) {
            sum += Long.parseLong(((CompoundVariable)this.values[i]).execute());
        }
        try {
            sum += Long.parseLong(varName);
            varName = null;
        }
        catch (NumberFormatException ignored) {
            // empty catch block
        }
        String totalString = Long.toString(sum);
        if (vars != null && varName != null && varName.length() > 0) {
            vars.put(varName, totalString);
        }
        return totalString;
    }

    public synchronized void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkMinParameterCount(parameters, 2);
        this.values = parameters.toArray();
    }

    public String getReferenceKey() {
        return KEY;
    }

    public List<String> getArgumentDesc() {
        return desc;
    }

    static {
        desc.add(JMeterUtils.getResString((String)"longsum_param_1"));
        desc.add(JMeterUtils.getResString((String)"longsum_param_2"));
        desc.add(JMeterUtils.getResString((String)"function_name_paropt"));
    }
}

