/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.ftp.sampler;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.io.output.TeeOutputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.Interruptible;
import org.apache.jmeter.samplers.SampleResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FTPSampler
extends AbstractSampler
implements Interruptible {
    private static final long serialVersionUID = 240L;
    private static final Logger log = LoggerFactory.getLogger(FTPSampler.class);
    private static final Set<String> APPLIABLE_CONFIG_CLASSES = new HashSet<String>(Arrays.asList("org.apache.jmeter.config.gui.LoginConfigGui", "org.apache.jmeter.protocol.ftp.config.gui.FtpConfigGui", "org.apache.jmeter.config.gui.SimpleConfigGui"));
    public static final String SERVER = "FTPSampler.server";
    public static final String PORT = "FTPSampler.port";
    public static final String REMOTE_FILENAME = "FTPSampler.filename";
    public static final String LOCAL_FILENAME = "FTPSampler.localfilename";
    public static final String INPUT_DATA = "FTPSampler.inputdata";
    public static final String BINARY_MODE = "FTPSampler.binarymode";
    public static final String UPLOAD_FILE = "FTPSampler.upload";
    public static final String SAVE_RESPONSE = "FTPSampler.saveresponse";
    private volatile transient FTPClient savedClient;

    public String getUsername() {
        return this.getPropertyAsString("ConfigTestElement.username");
    }

    public String getPassword() {
        return this.getPropertyAsString("ConfigTestElement.password");
    }

    public void setServer(String newServer) {
        this.setProperty(SERVER, newServer);
    }

    public String getServer() {
        return this.getPropertyAsString(SERVER);
    }

    public void setPort(String newPort) {
        this.setProperty(PORT, newPort, "");
    }

    public String getPort() {
        return this.getPropertyAsString(PORT, "");
    }

    public int getPortAsInt() {
        return this.getPropertyAsInt(PORT, 0);
    }

    public String getRemoteFilename() {
        return this.getPropertyAsString(REMOTE_FILENAME);
    }

    public String getLocalFilename() {
        return this.getPropertyAsString(LOCAL_FILENAME);
    }

    private String getLocalFileContents() {
        return this.getPropertyAsString(INPUT_DATA);
    }

    public boolean isBinaryMode() {
        return this.getPropertyAsBoolean(BINARY_MODE, false);
    }

    public boolean isSaveResponse() {
        return this.getPropertyAsBoolean(SAVE_RESPONSE, false);
    }

    public boolean isUpload() {
        return this.getPropertyAsBoolean(UPLOAD_FILE, false);
    }

    public String getLabel() {
        StringBuilder sb = new StringBuilder();
        sb.append("ftp://");
        sb.append(this.getServer());
        String port = this.getPort();
        if (port.length() > 0) {
            sb.append(':');
            sb.append(port);
        }
        sb.append("/");
        sb.append(this.getRemoteFilename());
        sb.append(this.isBinaryMode() ? " (Binary) " : " (Ascii) ");
        sb.append(this.isUpload() ? " <- " : " -> ");
        sb.append(this.getLocalFilename());
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SampleResult sample(Entry e) {
        SampleResult res;
        block40: {
            res = new SampleResult();
            res.setSuccessful(false);
            String remote = this.getRemoteFilename();
            String local = this.getLocalFilename();
            boolean binaryTransfer = this.isBinaryMode();
            res.setSampleLabel(this.getName());
            String label = this.getLabel();
            res.setSamplerData(label);
            try {
                res.setURL(new URL(label));
            }
            catch (MalformedURLException e1) {
                log.warn("Cannot set URL: " + e1.getLocalizedMessage());
            }
            InputStream input = null;
            FileInputStream fileIS = null;
            res.sampleStart();
            FTPClient ftp = new FTPClient();
            try {
                this.savedClient = ftp;
                int port = this.getPortAsInt();
                if (port > 0) {
                    ftp.connect(this.getServer(), port);
                } else {
                    ftp.connect(this.getServer());
                }
                res.latencyEnd();
                int reply = ftp.getReplyCode();
                if (FTPReply.isPositiveCompletion((int)reply)) {
                    if (ftp.login(this.getUsername(), this.getPassword())) {
                        if (binaryTransfer) {
                            ftp.setFileType(2);
                        }
                        ftp.enterLocalPassiveMode();
                        boolean ftpOK = false;
                        if (this.isUpload()) {
                            String contents = this.getLocalFileContents();
                            if (contents.length() > 0) {
                                byte[] bytes = contents.getBytes();
                                input = new ByteArrayInputStream(bytes);
                                res.setBytes((long)bytes.length);
                            } else {
                                File infile = new File(local);
                                res.setBytes(infile.length());
                                fileIS = new FileInputStream(infile);
                                input = new BufferedInputStream(fileIS);
                            }
                            ftpOK = ftp.storeFile(remote, input);
                        } else {
                            FileOutputStream output;
                            OutputStream target;
                            block39: {
                                boolean saveResponse = this.isSaveResponse();
                                ByteArrayOutputStream baos = null;
                                target = null;
                                output = null;
                                try {
                                    if (saveResponse) {
                                        target = baos = new ByteArrayOutputStream();
                                    }
                                    if (local.length() > 0) {
                                        output = new FileOutputStream(local);
                                        target = target == null ? output : new TeeOutputStream((OutputStream)output, (OutputStream)baos);
                                    }
                                    if (target == null) {
                                        target = new NullOutputStream();
                                    }
                                    if ((input = ftp.retrieveFileStream(remote)) == null) {
                                        res.setResponseCode(Integer.toString(ftp.getReplyCode()));
                                        res.setResponseMessage(ftp.getReplyString());
                                        break block39;
                                    }
                                    long bytes = IOUtils.copy((InputStream)input, (OutputStream)target);
                                    boolean bl = ftpOK = bytes > 0L;
                                    if (saveResponse && baos != null) {
                                        res.setResponseData(baos.toByteArray());
                                        if (!binaryTransfer) {
                                            res.setDataType("text");
                                        }
                                        break block39;
                                    }
                                    res.setBytes(bytes);
                                }
                                catch (Throwable throwable) {
                                    IOUtils.closeQuietly(target);
                                    IOUtils.closeQuietly(output);
                                    throw throwable;
                                }
                            }
                            IOUtils.closeQuietly((OutputStream)target);
                            IOUtils.closeQuietly((OutputStream)output);
                        }
                        if (ftpOK) {
                            res.setResponseCodeOK();
                            res.setResponseMessageOK();
                            res.setSuccessful(true);
                            break block40;
                        } else {
                            res.setResponseCode(Integer.toString(ftp.getReplyCode()));
                            res.setResponseMessage(ftp.getReplyString());
                        }
                        break block40;
                    }
                    res.setResponseCode(Integer.toString(ftp.getReplyCode()));
                    res.setResponseMessage(ftp.getReplyString());
                    break block40;
                }
                res.setResponseCode("501");
                res.setResponseMessage("Could not connect");
                res.setResponseMessage(ftp.getReplyString());
            }
            catch (IOException ex) {
                res.setResponseCode("000");
                res.setResponseMessage(ex.toString());
            }
            finally {
                this.savedClient = null;
                if (ftp.isConnected()) {
                    try {
                        ftp.logout();
                    }
                    catch (IOException iOException) {}
                    try {
                        ftp.disconnect();
                    }
                    catch (IOException iOException) {}
                }
                IOUtils.closeQuietly(input);
                IOUtils.closeQuietly(fileIS);
            }
        }
        res.sampleEnd();
        return res;
    }

    public boolean interrupt() {
        FTPClient client = this.savedClient;
        if (client != null) {
            this.savedClient = null;
            try {
                client.abort();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                client.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return client != null;
    }

    public boolean applies(ConfigTestElement configElement) {
        String guiClass = configElement.getProperty("TestElement.gui_class").getStringValue();
        return APPLIABLE_CONFIG_CLASSES.contains(guiClass);
    }
}

