/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers.backend.graphite;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.jmeter.visualizers.backend.graphite.AbstractGraphiteMetricsSender;
import org.apache.jmeter.visualizers.backend.graphite.GraphiteMetricsSender;
import org.apache.jmeter.visualizers.backend.graphite.SocketConnectionInfos;
import org.apache.jmeter.visualizers.backend.graphite.SocketOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PickleGraphiteMetricsSender
extends AbstractGraphiteMetricsSender {
    private static final Logger log = LoggerFactory.getLogger(PickleGraphiteMetricsSender.class);
    private static final char APPEND = 'a';
    private static final char LIST = 'l';
    private static final char LONG = 'L';
    private static final char MARK = '(';
    private static final char STOP = '.';
    private static final char STRING = 'S';
    private static final char TUPLE = 't';
    private static final char QUOTE = '\'';
    private static final char LF = '\n';
    private final Object lock = new Object();
    private List<GraphiteMetricsSender.MetricTuple> metrics = new ArrayList<GraphiteMetricsSender.MetricTuple>();
    private SocketConnectionInfos socketConnectionInfos;
    private GenericKeyedObjectPool<? super SocketConnectionInfos, SocketOutputStream> socketOutputStreamPool;
    private String prefix;

    PickleGraphiteMetricsSender() {
    }

    @Override
    public void setup(String graphiteHost, int graphitePort, String prefix) {
        this.prefix = prefix;
        this.socketConnectionInfos = new SocketConnectionInfos(graphiteHost, graphitePort);
        this.socketOutputStreamPool = this.createSocketOutputStreamPool();
        log.info("Created PickleGraphiteMetricsSender with host: {}, port: {}, prefix: {}", new Object[]{graphiteHost, graphitePort, prefix});
    }

    public void setup(SocketConnectionInfos socketConnectionInfos, GenericKeyedObjectPool<? super SocketConnectionInfos, SocketOutputStream> socketOutputStreamPool, String prefix) {
        this.socketConnectionInfos = socketConnectionInfos;
        this.socketOutputStreamPool = socketOutputStreamPool;
        this.prefix = prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMetric(long timestamp, String contextName, String metricName, String metricValue) {
        String name = new StringBuilder(50).append(this.prefix).append(contextName).append(".").append(metricName).toString();
        Object object = this.lock;
        synchronized (object) {
            this.metrics.add(new GraphiteMetricsSender.MetricTuple(name, timestamp, metricValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeAndSendMetrics() {
        List<GraphiteMetricsSender.MetricTuple> currentMetrics;
        Object object = this.lock;
        synchronized (object) {
            if (this.metrics.isEmpty()) {
                return;
            }
            currentMetrics = this.metrics;
            this.metrics = new ArrayList<GraphiteMetricsSender.MetricTuple>();
        }
        this.writeMetrics(currentMetrics);
    }

    private void writeMetrics(List<GraphiteMetricsSender.MetricTuple> currentMetrics) {
        SocketOutputStream out = null;
        try {
            String payload = PickleGraphiteMetricsSender.convertMetricsToPickleFormat(currentMetrics);
            int length = payload.length();
            byte[] header = ByteBuffer.allocate(4).putInt(length).array();
            out = (SocketOutputStream)this.socketOutputStreamPool.borrowObject((Object)this.socketConnectionInfos);
            out.write(header);
            OutputStreamWriter pickleWriter = new OutputStreamWriter((OutputStream)out, CHARSET_NAME);
            pickleWriter.write(payload);
            ((Writer)pickleWriter).flush();
            this.socketOutputStreamPool.returnObject((Object)this.socketConnectionInfos, (Object)out);
        }
        catch (Exception e) {
            if (out != null) {
                try {
                    this.socketOutputStreamPool.invalidateObject((Object)this.socketConnectionInfos, out);
                }
                catch (Exception e1) {
                    log.warn("Exception invalidating socketOutputStream connected to graphite server {}:{}", new Object[]{this.socketConnectionInfos.getHost(), this.socketConnectionInfos.getPort(), e1});
                }
            }
            log.error("Error writing to Graphite: {}", (Object)e.getMessage(), (Object)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("Wrote {} metrics", (Object)currentMetrics.size());
        }
    }

    @Override
    public void destroy() {
        this.socketOutputStreamPool.close();
    }

    private static String convertMetricsToPickleFormat(List<GraphiteMetricsSender.MetricTuple> metrics) {
        StringBuilder pickled = new StringBuilder(metrics.size() * 75);
        pickled.append('(').append('l');
        for (GraphiteMetricsSender.MetricTuple tuple : metrics) {
            pickled.append('(').append('S').append('\'').append(tuple.name).append('\'').append('\n').append('(').append('L').append(tuple.timestamp).append('L').append('\n').append('S').append('\'').append(tuple.value).append('\'').append('\n').append('t').append('t').append('a');
        }
        pickled.append('.');
        return pickled.toString();
    }
}

