/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.extractor.json.jsonpath;

import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.extractor.json.jsonpath.JSONManager;
import org.apache.jmeter.processor.PostProcessor;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractScopedTestElement;
import org.apache.jmeter.testelement.ThreadListener;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.util.JOrphanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONPostProcessor
extends AbstractScopedTestElement
implements Serializable,
PostProcessor,
ThreadListener {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(JSONPostProcessor.class);
    private static final String JSON_PATH_EXPRESSIONS = "JSONPostProcessor.jsonPathExprs";
    private static final String REFERENCE_NAMES = "JSONPostProcessor.referenceNames";
    private static final String DEFAULT_VALUES = "JSONPostProcessor.defaultValues";
    private static final String MATCH_NUMBERS = "JSONPostProcessor.match_numbers";
    private static final String COMPUTE_CONCATENATION = "JSONPostProcessor.compute_concat";
    private static final String REF_MATCH_NR = "_matchNr";
    private static final String ALL_SUFFIX = "_ALL";
    private static final String JSON_CONCATENATION_SEPARATOR = ",";
    private static final String SEPARATOR = ";";
    public static final boolean COMPUTE_CONCATENATION_DEFAULT_VALUE = false;
    private static final ThreadLocal<JSONManager> localMatcher = ThreadLocal.withInitial(JSONManager::new);

    public void process() {
        JMeterContext context = this.getThreadContext();
        JMeterVariables vars = context.getVariables();
        List<String> jsonResponses = this.extractJsonResponse(context, vars);
        String[] refNames = this.getRefNames().split(SEPARATOR);
        String[] jsonPathExpressions = this.getJsonPathExpressions().split(SEPARATOR);
        String[] defaultValues = this.getDefaultValues().split(SEPARATOR);
        int[] matchNumbers = this.getMatchNumbersAsInt(defaultValues.length);
        JSONPostProcessor.validateSameLengthOfArguments(refNames, jsonPathExpressions, defaultValues);
        for (int i = 0; i < jsonPathExpressions.length; ++i) {
            int matchNumber = matchNumbers[i];
            String currentRefName = refNames[i].trim();
            String currentJsonPath = jsonPathExpressions[i].trim();
            JSONPostProcessor.clearOldRefVars(vars, currentRefName);
            try {
                if (jsonResponses.isEmpty()) {
                    this.handleEmptyResponse(vars, defaultValues[i], currentRefName);
                    continue;
                }
                List<Object> extractedValues = JSONPostProcessor.extractValues(jsonResponses, currentJsonPath);
                this.handleResult(vars, defaultValues[i], matchNumber, currentRefName, extractedValues);
                continue;
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.error("Error processing JSON content in {}, message: {}", new Object[]{this.getName(), e.getLocalizedMessage(), e});
                } else {
                    log.error("Error processing JSON content in {}, message: {}", (Object)this.getName(), (Object)e.getLocalizedMessage());
                }
                vars.put(currentRefName, defaultValues[i]);
            }
        }
    }

    private void handleResult(JMeterVariables vars, String defaultValue, int matchNumber, String currentRefName, List<Object> extractedValues) {
        if (extractedValues.isEmpty()) {
            this.handleEmptyResult(vars, defaultValue, matchNumber, currentRefName);
        } else {
            this.handleNonEmptyResult(vars, defaultValue, matchNumber, currentRefName, extractedValues);
        }
    }

    private static List<Object> extractValues(List<String> jsonResponses, String currentJsonPath) throws ParseException {
        ArrayList<Object> extractedValues = new ArrayList<Object>();
        for (String jsonResponse : jsonResponses) {
            extractedValues.addAll(localMatcher.get().extractWithJsonPath(jsonResponse, currentJsonPath));
        }
        return extractedValues;
    }

    private void handleNonEmptyResult(JMeterVariables vars, String defaultValue, int matchNumber, String currentRefName, List<Object> extractedValues) {
        if (extractedValues.size() > 1) {
            this.handleListResult(vars, defaultValue, matchNumber, currentRefName, extractedValues);
        } else {
            this.handleSingleResult(vars, defaultValue, matchNumber, currentRefName, extractedValues);
        }
        if (matchNumber != 0) {
            vars.put(currentRefName + REF_MATCH_NR, Integer.toString(extractedValues.size()));
        }
    }

    private static void validateSameLengthOfArguments(String[] refNames, String[] jsonPathExpressions, String[] defaultValues) {
        if (refNames.length != jsonPathExpressions.length || refNames.length != defaultValues.length) {
            log.error("Number of JSON Path variables must match number of default values and json-path expressions, check you use separator ';' if you have many values");
            throw new IllegalArgumentException(JMeterUtils.getResString((String)"jsonpp_error_number_arguments_mismatch_error"));
        }
    }

    private void handleSingleResult(JMeterVariables vars, String defaultValue, int matchNumber, String currentRefName, List<Object> extractedValues) {
        String suffix = matchNumber < 0 ? "_1" : "";
        JSONPostProcessor.placeObjectIntoVars(vars, currentRefName + suffix, extractedValues, 0, defaultValue);
        if (matchNumber < 0 && this.getComputeConcatenation()) {
            vars.put(currentRefName + ALL_SUFFIX, vars.get(currentRefName + suffix));
        }
    }

    private void handleListResult(JMeterVariables vars, String defaultValue, int matchNumber, String currentRefName, List<Object> extractedValues) {
        if (matchNumber < 0) {
            int index = 1;
            StringBuilder concat = new StringBuilder(this.getComputeConcatenation() ? extractedValues.size() * 20 : 1);
            for (Object extractedObject : extractedValues) {
                String extractedString = StringUtils.defaultString((String)JSONPostProcessor.stringify(extractedObject), (String)defaultValue);
                vars.put(currentRefName + "_" + index, extractedString);
                if (this.getComputeConcatenation()) {
                    concat.append(extractedString).append(JSON_CONCATENATION_SEPARATOR);
                }
                ++index;
            }
            if (this.getComputeConcatenation()) {
                concat.setLength(concat.length() - 1);
                vars.put(currentRefName + ALL_SUFFIX, concat.toString());
            }
            return;
        }
        if (matchNumber == 0) {
            int matchSize = extractedValues.size();
            int matchNr = JMeterUtils.getRandomInt((int)matchSize);
            JSONPostProcessor.placeObjectIntoVars(vars, currentRefName, extractedValues, matchNr, defaultValue);
            return;
        }
        if (matchNumber > extractedValues.size()) {
            if (log.isDebugEnabled()) {
                log.debug("matchNumber({}) exceeds number of items found({}), default value will be used", (Object)matchNumber, (Object)extractedValues.size());
            }
            vars.put(currentRefName, defaultValue);
        } else {
            JSONPostProcessor.placeObjectIntoVars(vars, currentRefName, extractedValues, matchNumber - 1, defaultValue);
        }
    }

    private void handleEmptyResult(JMeterVariables vars, String defaultValue, int matchNumber, String currentRefName) {
        vars.put(currentRefName, defaultValue);
        vars.put(currentRefName + REF_MATCH_NR, "0");
        if (matchNumber < 0 && this.getComputeConcatenation()) {
            log.debug("No value extracted, storing empty in: {}{}", (Object)currentRefName, (Object)ALL_SUFFIX);
            vars.put(currentRefName + ALL_SUFFIX, "");
        }
    }

    private void handleEmptyResponse(JMeterVariables vars, String defaultValue, String currentRefName) {
        if (log.isDebugEnabled()) {
            log.debug("Response or source variable is null or empty for {}", (Object)this.getName());
        }
        vars.put(currentRefName, defaultValue);
    }

    private List<String> extractJsonResponse(JMeterContext context, JMeterVariables vars) {
        String jsonResponse = "";
        if (this.isScopeVariable()) {
            if (log.isDebugEnabled()) {
                log.debug("JSON Extractor is using variable: {}, which content is: {}", (Object)this.getVariableName(), (Object)jsonResponse);
            }
            return Arrays.asList(vars.get(this.getVariableName()));
        }
        SampleResult previousResult = context.getPreviousResult();
        if (previousResult != null) {
            List<String> results = this.getSampleList(previousResult).stream().map(SampleResult::getResponseDataAsString).filter(StringUtils::isNotBlank).collect(Collectors.toList());
            if (log.isDebugEnabled()) {
                log.debug("JSON Extractor {} working on Responses: {}", (Object)this.getName(), results);
            }
            return results;
        }
        return Collections.emptyList();
    }

    private static void clearOldRefVars(JMeterVariables vars, String refName) {
        vars.remove(refName + REF_MATCH_NR);
        int i = 1;
        while (vars.get(refName + "_" + i) != null) {
            vars.remove(refName + "_" + i);
            ++i;
        }
    }

    private static void placeObjectIntoVars(JMeterVariables vars, String currentRefName, List<Object> extractedValues, int matchNr, String defaultValue) {
        vars.put(currentRefName, StringUtils.defaultString((String)JSONPostProcessor.stringify(extractedValues.get(matchNr)), (String)defaultValue));
    }

    private static String stringify(Object obj) {
        return obj == null ? null : obj.toString();
    }

    public String getJsonPathExpressions() {
        return this.getPropertyAsString(JSON_PATH_EXPRESSIONS);
    }

    public void setJsonPathExpressions(String jsonPath) {
        this.setProperty(JSON_PATH_EXPRESSIONS, jsonPath);
    }

    public String getRefNames() {
        return this.getPropertyAsString(REFERENCE_NAMES);
    }

    public void setRefNames(String refName) {
        this.setProperty(REFERENCE_NAMES, refName);
    }

    public String getDefaultValues() {
        return this.getPropertyAsString(DEFAULT_VALUES);
    }

    public void setDefaultValues(String defaultValue) {
        this.setProperty(DEFAULT_VALUES, defaultValue, "");
    }

    public boolean getComputeConcatenation() {
        return this.getPropertyAsBoolean(COMPUTE_CONCATENATION, false);
    }

    public void setComputeConcatenation(boolean computeConcatenation) {
        this.setProperty(COMPUTE_CONCATENATION, computeConcatenation, false);
    }

    public void threadStarted() {
    }

    public void threadFinished() {
        localMatcher.remove();
    }

    public void setMatchNumbers(String matchNumber) {
        this.setProperty(MATCH_NUMBERS, matchNumber);
    }

    public String getMatchNumbers() {
        return this.getPropertyAsString(MATCH_NUMBERS);
    }

    public int[] getMatchNumbersAsInt(int arraySize) {
        String matchNumbersAsString = this.getMatchNumbers();
        int[] result = new int[arraySize];
        if (JOrphanUtils.isBlank((String)matchNumbersAsString)) {
            Arrays.fill(result, 0);
        } else {
            String[] matchNumbersAsStringArray = matchNumbersAsString.split(SEPARATOR);
            for (int i = 0; i < matchNumbersAsStringArray.length; ++i) {
                result[i] = Integer.parseInt(matchNumbersAsStringArray[i].trim());
            }
        }
        return result;
    }
}

