/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.LongProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.tidy.Node;
import org.w3c.tidy.Tidy;

public class HTMLAssertion
extends AbstractTestElement
implements Serializable,
Assertion {
    private static final long serialVersionUID = 241L;
    private static final Logger log = LoggerFactory.getLogger(HTMLAssertion.class);
    public static final String DEFAULT_DOCTYPE = "omit";
    public static final String DOCTYPE_KEY = "html_assertion_doctype";
    public static final String ERRORS_ONLY_KEY = "html_assertion_errorsonly";
    public static final String ERROR_THRESHOLD_KEY = "html_assertion_error_threshold";
    public static final String WARNING_THRESHOLD_KEY = "html_assertion_warning_threshold";
    public static final String FORMAT_KEY = "html_assertion_format";
    public static final String FILENAME_KEY = "html_assertion_filename";

    public HTMLAssertion() {
        log.debug("HTMLAssertion(): called");
    }

    public AssertionResult getResult(SampleResult inResponse) {
        log.debug("HTMLAssertions.getResult() called");
        if (inResponse.getResponseData().length == 0) {
            return new AssertionResult(this.getName()).setResultForNull();
        }
        return this.runTidy(inResponse);
    }

    private AssertionResult runTidy(SampleResult inResponse) {
        AssertionResult result = new AssertionResult(this.getName());
        result.setFailure(false);
        Tidy tidy = this.getTidy();
        if (tidy == null) {
            result.setFailure(true);
            result.setFailureMessage("Unable to instantiate tidy parser");
            return result;
        }
        try {
            boolean warningsAboveThreshold;
            log.debug("HTMLAssertions.getResult(): start parsing with tidy ...");
            StringWriter errbuf = new StringWriter();
            tidy.setErrout(new PrintWriter(errbuf));
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            log.debug("Parsing with tidy starting...");
            Node node = tidy.parse((InputStream)new ByteArrayInputStream(inResponse.getResponseData()), (OutputStream)os);
            log.debug("Parsing with tidy done! node: {}, output: {}", (Object)node, (Object)os);
            this.writeOutput(errbuf.toString());
            boolean errorsAboveThreshold = (long)tidy.getParseErrors() > this.getErrorThreshold();
            boolean bl = warningsAboveThreshold = (long)tidy.getParseWarnings() > this.getWarningThreshold();
            if (errorsAboveThreshold || !this.isErrorsOnly() && warningsAboveThreshold) {
                log.debug("Errors/warnings detected while parsing with tidy: {}", (Object)errbuf);
                result.setFailure(true);
                result.setFailureMessage(MessageFormat.format("Tidy Parser errors:   " + tidy.getParseErrors() + " (allowed " + this.getErrorThreshold() + ") Tidy Parser warnings: " + tidy.getParseWarnings() + " (allowed " + this.getWarningThreshold() + ")", new Object[0]));
            } else if (tidy.getParseErrors() > 0 || tidy.getParseWarnings() > 0) {
                log.debug("HTMLAssertions.getResult(): there were errors/warnings but threshold to high");
                result.setFailure(false);
            } else {
                log.debug("HTMLAssertions.getResult(): no errors/warnings detected:");
                result.setFailure(false);
            }
        }
        catch (Exception e) {
            log.warn("Cannot parse result content", (Throwable)e);
            result.setFailure(true);
            result.setFailureMessage(e.getMessage());
        }
        return result;
    }

    private Tidy getTidy() {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Setting up tidy... doctype: {}, errors only: {}, error threshold: {},warning threshold: {}, html mode: {}, xhtml mode: {}, xml mode: {}.", new Object[]{this.getDoctype(), this.isErrorsOnly(), this.getErrorThreshold(), this.getWarningThreshold(), this.isHTML(), this.isXHTML(), this.isXML()});
            }
            Tidy tidy = new Tidy();
            tidy.setInputEncoding(StandardCharsets.UTF_8.name());
            tidy.setOutputEncoding(StandardCharsets.UTF_8.name());
            tidy.setQuiet(false);
            tidy.setShowWarnings(true);
            tidy.setOnlyErrors(this.isErrorsOnly());
            tidy.setDocType(this.getDoctype());
            if (this.isXHTML()) {
                tidy.setXHTML(true);
            } else if (this.isXML()) {
                tidy.setXmlTags(true);
            }
            tidy.setErrfile(this.getFilename());
            if (log.isDebugEnabled()) {
                log.debug("Tidy instance created... err file: {}, tidy parser: {}", (Object)this.getFilename(), (Object)tidy);
            }
            return tidy;
        }
        catch (Exception e) {
            log.error("Unable to instantiate tidy parser", (Throwable)e);
            return null;
        }
    }

    private void writeOutput(String inOutput) {
        String filename = this.getFilename();
        if (StringUtils.isNotBlank((CharSequence)filename)) {
            try (FileWriter writer = new FileWriter(filename, false);){
                writer.write(inOutput);
                log.debug("writeOutput() -> output successfully written to file: {}", (Object)filename);
            }
            catch (IOException ex) {
                log.warn("writeOutput() -> could not write output to file: {}", (Object)filename, (Object)ex);
            }
        }
    }

    public String getDoctype() {
        return this.getPropertyAsString(DOCTYPE_KEY);
    }

    public boolean isErrorsOnly() {
        return this.getPropertyAsBoolean(ERRORS_ONLY_KEY);
    }

    public long getErrorThreshold() {
        return this.getPropertyAsLong(ERROR_THRESHOLD_KEY);
    }

    public long getWarningThreshold() {
        return this.getPropertyAsLong(WARNING_THRESHOLD_KEY);
    }

    public void setDoctype(String inDoctype) {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{inDoctype})) {
            this.setProperty((JMeterProperty)new StringProperty(DOCTYPE_KEY, DEFAULT_DOCTYPE));
        } else {
            this.setProperty((JMeterProperty)new StringProperty(DOCTYPE_KEY, inDoctype));
        }
    }

    public void setErrorsOnly(boolean inErrorsOnly) {
        this.setProperty((JMeterProperty)new BooleanProperty(ERRORS_ONLY_KEY, inErrorsOnly));
    }

    private long capToZero(long value) {
        if (value == Long.MAX_VALUE) {
            return 0L;
        }
        return value;
    }

    public void setErrorThreshold(long inErrorThreshold) {
        if (inErrorThreshold < 0L) {
            throw new IllegalArgumentException(JMeterUtils.getResString((String)"argument_must_not_be_negative"));
        }
        this.setProperty((JMeterProperty)new LongProperty(ERROR_THRESHOLD_KEY, this.capToZero(inErrorThreshold)));
    }

    public void setWarningThreshold(long inWarningThreshold) {
        if (inWarningThreshold < 0L) {
            throw new IllegalArgumentException(JMeterUtils.getResString((String)"argument_must_not_be_negative"));
        }
        this.setProperty((JMeterProperty)new LongProperty(WARNING_THRESHOLD_KEY, this.capToZero(inWarningThreshold)));
    }

    public void setHTML() {
        this.setProperty((JMeterProperty)new LongProperty(FORMAT_KEY, 0L));
    }

    public boolean isHTML() {
        return this.getPropertyAsLong(FORMAT_KEY) == 0L;
    }

    public void setXHTML() {
        this.setProperty((JMeterProperty)new LongProperty(FORMAT_KEY, 1L));
    }

    public boolean isXHTML() {
        return this.getPropertyAsLong(FORMAT_KEY) == 1L;
    }

    public void setXML() {
        this.setProperty((JMeterProperty)new LongProperty(FORMAT_KEY, 2L));
    }

    public boolean isXML() {
        return this.getPropertyAsLong(FORMAT_KEY) == 2L;
    }

    public String getFilename() {
        return this.getPropertyAsString(FILENAME_KEY);
    }

    public void setFilename(String inName) {
        this.setProperty(FILENAME_KEY, inName);
    }
}

