/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import org.apache.jmeter.gui.action.KeyStrokes;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.utils.Colors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchTextExtension
implements ActionListener,
DocumentListener {
    private static final Logger log = LoggerFactory.getLogger(SearchTextExtension.class);
    private static final Font FONT_DEFAULT = UIManager.getDefaults().getFont("TextField.font");
    private static final Font FONT_SMALL = new Font("SansSerif", 0, (int)Math.round((double)FONT_DEFAULT.getSize() * 0.8));
    private static final String SEARCH_TEXT_COMMAND = "search_text";
    private JButton findButton;
    private JTextField textToFindField;
    private JCheckBox caseChkBox;
    private JCheckBox regexpChkBox;
    private String lastTextTofind;
    private ISearchTextExtensionProvider searchProvider;
    private JToolBar toolBar;

    public SearchTextExtension(ISearchTextExtensionProvider searchProvider) {
        this.searchProvider = searchProvider;
        searchProvider.resetTextToFind();
        this.createSearchToolBar();
    }

    private void executeAndShowTextFind() {
        String textToFind = this.textToFindField.getText();
        if (this.searchProvider != null) {
            if (this.lastTextTofind != null && !this.lastTextTofind.equals(textToFind)) {
                this.searchProvider.resetTextToFind();
                this.textToFindField.setBackground(Color.WHITE);
                this.textToFindField.setForeground(Color.BLACK);
            }
            try {
                Pattern pattern = this.createPattern(this.textToFindField.getText());
                boolean found = this.searchProvider.executeAndShowTextFind(pattern);
                if (found) {
                    this.findButton.setText(JMeterUtils.getResString((String)"search_text_button_find"));
                    this.lastTextTofind = textToFind;
                    this.textToFindField.setBackground(Color.WHITE);
                    this.textToFindField.setForeground(Color.BLACK);
                } else {
                    this.findButton.setText(JMeterUtils.getResString((String)"search_text_button_find"));
                    this.textToFindField.setBackground(Colors.LIGHT_RED);
                    this.textToFindField.setForeground(Color.WHITE);
                }
            }
            catch (PatternSyntaxException pse) {
                JOptionPane.showMessageDialog(null, pse.toString(), JMeterUtils.getResString((String)"error_title"), 2);
            }
        }
    }

    public JToolBar getSearchToolBar() {
        return this.toolBar;
    }

    private JToolBar createSearchToolBar() {
        this.textToFindField = new JTextField();
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        this.toolBar.setFont(FONT_SMALL);
        this.toolBar.add(this.textToFindField);
        this.textToFindField.getDocument().addDocumentListener(this);
        this.findButton = new JButton(JMeterUtils.getResString((String)"search_text_button_find"));
        this.findButton.setFont(FONT_SMALL);
        this.findButton.setActionCommand(SEARCH_TEXT_COMMAND);
        this.findButton.addActionListener(this);
        this.toolBar.add(this.findButton);
        this.caseChkBox = new JCheckBox(JMeterUtils.getResString((String)"search_text_chkbox_case"), false);
        this.caseChkBox.setFont(FONT_SMALL);
        this.toolBar.add(this.caseChkBox);
        this.regexpChkBox = new JCheckBox(JMeterUtils.getResString((String)"search_text_chkbox_regexp"), false);
        this.regexpChkBox.setFont(FONT_SMALL);
        this.toolBar.add(this.regexpChkBox);
        InputMap im = this.textToFindField.getInputMap(2);
        im.put(KeyStrokes.ENTER, SEARCH_TEXT_COMMAND);
        ActionMap am = this.textToFindField.getActionMap();
        am.put(SEARCH_TEXT_COMMAND, new EnterAction());
        return this.toolBar;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (SEARCH_TEXT_COMMAND.equals(command)) {
            this.executeAndShowTextFind();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.resetTextToFind();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.resetTextToFind();
    }

    public void resetTextToFind() {
        if (this.searchProvider != null) {
            this.searchProvider.resetTextToFind();
        }
        this.lastTextTofind = null;
        this.findButton.setText(JMeterUtils.getResString((String)"search_text_button_find"));
    }

    private Pattern createPattern(String textToFind) {
        String textToFindQ = this.regexpChkBox.isSelected() ? textToFind : Pattern.quote(textToFind);
        return this.caseChkBox.isSelected() ? Pattern.compile(textToFindQ) : Pattern.compile(textToFindQ, 2);
    }

    public static class JEditorPaneSearchProvider
    implements ISearchTextExtensionProvider {
        private static volatile int LAST_POSITION_DEFAULT = 0;
        private static final Color HIGHLIGHT_COLOR = Color.GREEN;
        private JEditorPane results;
        private Highlighter selection;
        private Highlighter.HighlightPainter painter;
        private int lastPosition = LAST_POSITION_DEFAULT;

        public JEditorPaneSearchProvider(JEditorPane results) {
            this.results = results;
            this.selection = new DefaultHighlighter();
            this.painter = new DefaultHighlighter.DefaultHighlightPainter(HIGHLIGHT_COLOR);
            results.setHighlighter(this.selection);
        }

        @Override
        public void resetTextToFind() {
            this.lastPosition = LAST_POSITION_DEFAULT;
            this.selection.removeAllHighlights();
            this.results.setCaretPosition(0);
        }

        @Override
        public boolean executeAndShowTextFind(Pattern pattern) {
            boolean found = false;
            if (this.results != null && this.results.getText().length() > 0 && pattern != null) {
                log.debug("lastPosition={}", (Object)this.lastPosition);
                Matcher matcher = null;
                try {
                    Document contentDoc = this.results.getDocument();
                    String body = contentDoc.getText(this.lastPosition, contentDoc.getLength() - this.lastPosition);
                    matcher = pattern.matcher(body);
                    if (matcher != null && matcher.find()) {
                        this.selection.removeAllHighlights();
                        this.selection.addHighlight(this.lastPosition + matcher.start(), this.lastPosition + matcher.end(), this.painter);
                        this.results.setCaretPosition(this.lastPosition + matcher.end());
                        this.lastPosition += matcher.end();
                        found = true;
                    } else {
                        this.lastPosition = LAST_POSITION_DEFAULT;
                        this.results.setCaretPosition(0);
                    }
                }
                catch (BadLocationException ble) {
                    log.error("Location exception in text find", (Throwable)ble);
                }
            }
            return found;
        }
    }

    public static interface ISearchTextExtensionProvider {
        public void resetTextToFind();

        public boolean executeAndShowTextFind(Pattern var1);
    }

    private class EnterAction
    extends AbstractAction {
        private static final long serialVersionUID = 2L;

        private EnterAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            SearchTextExtension.this.executeAndShowTextFind();
        }
    }
}

