/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers.backend.graphite;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.jmeter.visualizers.backend.graphite.AbstractGraphiteMetricsSender;
import org.apache.jmeter.visualizers.backend.graphite.GraphiteMetricsSender;
import org.apache.jmeter.visualizers.backend.graphite.SocketConnectionInfos;
import org.apache.jmeter.visualizers.backend.graphite.SocketOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TextGraphiteMetricsSender
extends AbstractGraphiteMetricsSender {
    private static final Logger log = LoggerFactory.getLogger(TextGraphiteMetricsSender.class);
    private String prefix;
    private final Object lock = new Object();
    private List<GraphiteMetricsSender.MetricTuple> metrics = new ArrayList<GraphiteMetricsSender.MetricTuple>();
    private GenericKeyedObjectPool<SocketConnectionInfos, SocketOutputStream> socketOutputStreamPool;
    private SocketConnectionInfos socketConnectionInfos;

    TextGraphiteMetricsSender() {
    }

    @Override
    public void setup(String graphiteHost, int graphitePort, String prefix) {
        this.prefix = prefix;
        this.socketConnectionInfos = new SocketConnectionInfos(graphiteHost, graphitePort);
        this.socketOutputStreamPool = this.createSocketOutputStreamPool();
        log.info("Created TextGraphiteMetricsSender with host: {}, port: {}, prefix: {}", new Object[]{graphiteHost, graphitePort, prefix});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMetric(long timestamp, String contextName, String metricName, String metricValue) {
        StringBuilder sb = new StringBuilder(50);
        sb.append(this.prefix).append(contextName).append(".").append(metricName);
        Object object = this.lock;
        synchronized (object) {
            this.metrics.add(new GraphiteMetricsSender.MetricTuple(sb.toString(), timestamp, metricValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeAndSendMetrics() {
        List<GraphiteMetricsSender.MetricTuple> tempMetrics;
        Object object = this.lock;
        synchronized (object) {
            if (this.metrics.isEmpty()) {
                return;
            }
            tempMetrics = this.metrics;
            this.metrics = new ArrayList<GraphiteMetricsSender.MetricTuple>(tempMetrics.size());
        }
        List<GraphiteMetricsSender.MetricTuple> copyMetrics = tempMetrics;
        if (!copyMetrics.isEmpty()) {
            SocketOutputStream out = null;
            try {
                out = (SocketOutputStream)this.socketOutputStreamPool.borrowObject((Object)this.socketConnectionInfos);
                PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)out, CHARSET_NAME), false);
                for (GraphiteMetricsSender.MetricTuple metric : copyMetrics) {
                    pw.printf("%s %s %d%n", metric.name, metric.value, metric.timestamp);
                }
                pw.flush();
                if (log.isDebugEnabled()) {
                    log.debug("Wrote {} metrics", (Object)copyMetrics.size());
                }
                this.socketOutputStreamPool.returnObject((Object)this.socketConnectionInfos, (Object)out);
            }
            catch (Exception e) {
                if (out != null) {
                    try {
                        this.socketOutputStreamPool.invalidateObject((Object)this.socketConnectionInfos, (Object)out);
                    }
                    catch (Exception e1) {
                        log.warn("Exception invalidating socketOutputStream connected to graphite server '{}':{}", new Object[]{this.socketConnectionInfos.getHost(), this.socketConnectionInfos.getPort(), e1});
                    }
                }
                log.error("Error writing to Graphite: {}", (Object)e.getMessage());
            }
            copyMetrics.clear();
        }
    }

    @Override
    public void destroy() {
        this.socketOutputStreamPool.close();
    }
}

