/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.extractor.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.jmeter.extractor.HtmlExtractor;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.processor.gui.AbstractPostProcessorGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledTextField;

public class HtmlExtractorGui
extends AbstractPostProcessorGui {
    private static final long serialVersionUID = 240L;
    private static final String USE_DEFAULT_EXTRACTOR_IMPL = "";
    private JLabeledTextField expressionField;
    private JLabeledTextField attributeField;
    private JLabeledTextField defaultField;
    private JLabeledTextField matchNumberField;
    private JLabeledTextField refNameField;
    private JComboBox<String> extractorImplName;
    private JCheckBox emptyDefaultValue;

    public HtmlExtractorGui() {
        this.init();
    }

    public String getLabelResource() {
        return "html_extractor_title";
    }

    public void configure(TestElement el) {
        super.configure(el);
        if (el instanceof HtmlExtractor) {
            HtmlExtractor htmlExtractor = (HtmlExtractor)el;
            this.showScopeSettings(htmlExtractor, true);
            this.expressionField.setText(htmlExtractor.getExpression());
            this.attributeField.setText(htmlExtractor.getAttribute());
            this.defaultField.setText(htmlExtractor.getDefaultValue());
            this.emptyDefaultValue.setSelected(htmlExtractor.isEmptyDefaultValue());
            this.matchNumberField.setText(htmlExtractor.getMatchNumberAsString());
            this.refNameField.setText(htmlExtractor.getRefName());
            this.extractorImplName.setSelectedItem(htmlExtractor.getExtractor());
        }
    }

    public TestElement createTestElement() {
        HtmlExtractor extractor = new HtmlExtractor();
        this.modifyTestElement((TestElement)extractor);
        return extractor;
    }

    public void modifyTestElement(TestElement extractor) {
        super.configureTestElement(extractor);
        if (extractor instanceof HtmlExtractor) {
            HtmlExtractor htmlExtractor = (HtmlExtractor)extractor;
            this.saveScopeSettings(htmlExtractor);
            htmlExtractor.setRefName(this.refNameField.getText());
            htmlExtractor.setExpression(this.expressionField.getText());
            htmlExtractor.setAttribute(this.attributeField.getText());
            htmlExtractor.setDefaultValue(this.defaultField.getText());
            htmlExtractor.setDefaultEmptyValue(this.emptyDefaultValue.isSelected());
            htmlExtractor.setMatchNumber(this.matchNumberField.getText());
            if (this.extractorImplName.getSelectedIndex() < HtmlExtractor.getImplementations().length) {
                htmlExtractor.setExtractor(HtmlExtractor.getImplementations()[this.extractorImplName.getSelectedIndex()]);
            } else {
                htmlExtractor.setExtractor(USE_DEFAULT_EXTRACTOR_IMPL);
            }
        }
    }

    public void clearGui() {
        super.clearGui();
        this.extractorImplName.setSelectedItem(USE_DEFAULT_EXTRACTOR_IMPL);
        this.expressionField.setText(USE_DEFAULT_EXTRACTOR_IMPL);
        this.attributeField.setText(USE_DEFAULT_EXTRACTOR_IMPL);
        this.defaultField.setText(USE_DEFAULT_EXTRACTOR_IMPL);
        this.refNameField.setText(USE_DEFAULT_EXTRACTOR_IMPL);
        this.emptyDefaultValue.setSelected(false);
        this.matchNumberField.setText(USE_DEFAULT_EXTRACTOR_IMPL);
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        Box box = Box.createVerticalBox();
        box.add(this.makeTitlePanel());
        box.add(this.createScopePanel(true));
        box.add(this.makeExtractorPanel());
        this.add(box, "North");
        this.add(this.makeParameterPanel(), "Center");
    }

    private Component makeExtractorPanel() {
        HorizontalPanel panel = new HorizontalPanel();
        panel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"html_extractor_type")));
        DefaultComboBoxModel<String> m = new DefaultComboBoxModel<String>();
        for (String s : HtmlExtractor.getImplementations()) {
            m.addElement(s);
        }
        m.addElement(USE_DEFAULT_EXTRACTOR_IMPL);
        this.extractorImplName = new JComboBox(m);
        this.extractorImplName.setSelectedItem(USE_DEFAULT_EXTRACTOR_IMPL);
        JLabel label2 = new JLabel(JMeterUtils.getResString((String)"html_extractor_type"));
        label2.setLabelFor(this.extractorImplName);
        panel.add(label2);
        panel.add(this.extractorImplName);
        return panel;
    }

    private JPanel makeParameterPanel() {
        this.expressionField = new JLabeledTextField(JMeterUtils.getResString((String)"expression_field"));
        this.attributeField = new JLabeledTextField(JMeterUtils.getResString((String)"attribute_field"));
        this.refNameField = new JLabeledTextField(JMeterUtils.getResString((String)"ref_name_field"));
        this.matchNumberField = new JLabeledTextField(JMeterUtils.getResString((String)"match_num_field"));
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.initConstraints(gbc);
        this.addField(panel, this.refNameField, gbc);
        this.resetContraints(gbc);
        this.addField(panel, this.expressionField, gbc);
        this.resetContraints(gbc);
        this.addField(panel, this.attributeField, gbc);
        this.resetContraints(gbc);
        this.addField(panel, this.matchNumberField, gbc);
        this.resetContraints(gbc);
        gbc.weighty = 1.0;
        this.defaultField = new JLabeledTextField(JMeterUtils.getResString((String)"default_value_field"));
        List item = this.defaultField.getComponentList();
        panel.add((Component)item.get(0), gbc.clone());
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)item.get(1), "West");
        this.emptyDefaultValue = new JCheckBox(JMeterUtils.getResString((String)"cssjquery_empty_default_value"));
        this.emptyDefaultValue.addItemListener(evt -> {
            if (this.emptyDefaultValue.isSelected()) {
                this.defaultField.setText(USE_DEFAULT_EXTRACTOR_IMPL);
            }
            this.defaultField.setEnabled(!this.emptyDefaultValue.isSelected());
        });
        p.add((Component)this.emptyDefaultValue, "Center");
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        panel.add((Component)p, gbc.clone());
        return panel;
    }

    private void addField(JPanel panel, JLabeledTextField field, GridBagConstraints gbc) {
        List item = field.getComponentList();
        panel.add((Component)item.get(0), gbc.clone());
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        panel.add((Component)item.get(1), gbc.clone());
    }

    private void resetContraints(GridBagConstraints gbc) {
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.fill = 0;
    }

    private void initConstraints(GridBagConstraints gbc) {
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
    }
}

