/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers.backend.graphite;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.jmeter.visualizers.backend.graphite.AbstractGraphiteMetricsSender;
import org.apache.jmeter.visualizers.backend.graphite.GraphiteMetricsSender;
import org.apache.jmeter.visualizers.backend.graphite.SocketConnectionInfos;
import org.apache.jmeter.visualizers.backend.graphite.SocketOutputStream;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

class TextGraphiteMetricsSender
extends AbstractGraphiteMetricsSender {
    private static final Logger LOG = LoggingManager.getLoggerForClass();
    private String prefix;
    private List<GraphiteMetricsSender.MetricTuple> metrics = new ArrayList<GraphiteMetricsSender.MetricTuple>();
    private GenericKeyedObjectPool<SocketConnectionInfos, SocketOutputStream> socketOutputStreamPool;
    private SocketConnectionInfos socketConnectionInfos;

    TextGraphiteMetricsSender() {
    }

    @Override
    public void setup(String graphiteHost, int graphitePort, String prefix) {
        this.prefix = prefix;
        this.socketConnectionInfos = new SocketConnectionInfos(graphiteHost, graphitePort);
        this.socketOutputStreamPool = this.createSocketOutputStreamPool();
        if (LOG.isInfoEnabled()) {
            LOG.info("Created TextGraphiteMetricsSender with host:" + graphiteHost + ", port:" + graphitePort + ", prefix:" + prefix);
        }
    }

    @Override
    public void addMetric(long timestamp, String contextName, String metricName, String metricValue) {
        StringBuilder sb = new StringBuilder(50);
        sb.append(this.prefix).append(contextName).append(".").append(metricName);
        this.metrics.add(new GraphiteMetricsSender.MetricTuple(sb.toString(), timestamp, metricValue));
    }

    @Override
    public void writeAndSendMetrics() {
        if (this.metrics.size() > 0) {
            SocketOutputStream out = null;
            try {
                out = (SocketOutputStream)this.socketOutputStreamPool.borrowObject((Object)this.socketConnectionInfos);
                PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)out, CHARSET_NAME), false);
                for (GraphiteMetricsSender.MetricTuple metric : this.metrics) {
                    pw.printf("%s %s %d%n", metric.name, metric.value, metric.timestamp);
                }
                pw.flush();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Wrote " + this.metrics.size() + " metrics");
                }
                this.socketOutputStreamPool.returnObject((Object)this.socketConnectionInfos, (Object)out);
            }
            catch (Exception e) {
                if (out != null) {
                    try {
                        this.socketOutputStreamPool.invalidateObject((Object)this.socketConnectionInfos, (Object)out);
                    }
                    catch (Exception e1) {
                        LOG.warn("Exception invalidating socketOutputStream connected to graphite server '" + this.socketConnectionInfos.getHost() + "':" + this.socketConnectionInfos.getPort(), (Throwable)e1);
                    }
                }
                LOG.error("Error writing to Graphite:" + e.getMessage());
            }
            this.metrics.clear();
        }
    }

    @Override
    public void destroy() {
        this.socketOutputStreamPool.close();
    }
}

