/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers.backend;

import java.util.Iterator;
import java.util.Map;
import org.apache.jmeter.config.Arguments;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class BackendListenerContext {
    private static final Logger LOGGER = LoggingManager.getLoggerForClass();
    private final Map<String, String> params;

    public BackendListenerContext(Arguments args) {
        this.params = args.getArgumentsAsMap();
    }

    public boolean containsParameter(String name) {
        return this.params.containsKey(name);
    }

    public Iterator<String> getParameterNamesIterator() {
        return this.params.keySet().iterator();
    }

    public String getParameter(String name) {
        return this.getParameter(name, null);
    }

    public String getParameter(String name, String defaultValue) {
        if (this.params == null || !this.params.containsKey(name)) {
            return defaultValue;
        }
        return this.params.get(name);
    }

    public int getIntParameter(String name) throws NumberFormatException {
        if (this.params == null || !this.params.containsKey(name)) {
            throw new IllegalArgumentException("No value for parameter named '" + name + "'.");
        }
        return Integer.parseInt(this.params.get(name));
    }

    public int getIntParameter(String name, int defaultValue) {
        if (this.params == null || !this.params.containsKey(name)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(this.params.get(name));
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Value for parameter '" + name + "' not an integer: '" + this.params.get(name) + "'.  Using default: '" + defaultValue + "'.", (Throwable)e);
            return defaultValue;
        }
    }

    public long getLongParameter(String name) throws NumberFormatException {
        if (this.params == null || !this.params.containsKey(name)) {
            throw new NumberFormatException("No value for parameter named '" + name + "'.");
        }
        return Long.parseLong(this.params.get(name));
    }

    public long getLongParameter(String name, long defaultValue) {
        if (this.params == null || !this.params.containsKey(name)) {
            return defaultValue;
        }
        try {
            return Long.decode(this.params.get(name));
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Value for parameter '" + name + "' not a long: '" + this.params.get(name) + "'.  Using default: '" + defaultValue + "'.", (Throwable)e);
            return defaultValue;
        }
    }

    public boolean getBooleanParameter(String name, boolean defaultValue) {
        if (this.params == null || !this.params.containsKey(name)) {
            return defaultValue;
        }
        return Boolean.parseBoolean(this.params.get(name));
    }
}

