/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.text.Format;
import java.text.SimpleDateFormat;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.jmeter.gui.util.HeaderAsPropertyRenderer;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.Calculator;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.TableSample;
import org.apache.jmeter.visualizers.gui.AbstractVisualizer;
import org.apache.jorphan.gui.ObjectTableModel;
import org.apache.jorphan.gui.RendererUtils;
import org.apache.jorphan.gui.RightAlignRenderer;
import org.apache.jorphan.gui.layout.VerticalLayout;
import org.apache.jorphan.reflect.Functor;

public class TableVisualizer
extends AbstractVisualizer
implements Clearable {
    private static final long serialVersionUID = 240L;
    private static final String iconSize = JMeterUtils.getPropDefault((String)"jmeter.tree.icons.size", (String)"19x19");
    private static final ImageIcon imageSuccess = JMeterUtils.getImage((String)JMeterUtils.getPropDefault((String)"viewResultsTree.success", (String)("vrt/" + iconSize + "/security-high-2.png")), (String)JMeterUtils.getResString((String)"table_visualizer_success"));
    private static final ImageIcon imageFailure = JMeterUtils.getImage((String)JMeterUtils.getPropDefault((String)"viewResultsTree.failure", (String)("vrt/" + iconSize + "/security-low-2.png")), (String)JMeterUtils.getResString((String)"table_visualizer_warning"));
    private static final String[] COLUMNS = new String[]{"table_visualizer_sample_num", "table_visualizer_start_time", "table_visualizer_thread_name", "sampler_label", "table_visualizer_sample_time", "table_visualizer_status", "table_visualizer_bytes", "table_visualizer_sent_bytes", "table_visualizer_latency", "table_visualizer_connect"};
    private ObjectTableModel model = null;
    private JTable table = null;
    private JTextField dataField = null;
    private JTextField averageField = null;
    private JTextField deviationField = null;
    private JTextField noSamplesField = null;
    private JScrollPane tableScrollPanel = null;
    private JCheckBox autoscroll = null;
    private JCheckBox childSamples = null;
    private final transient Calculator calc = new Calculator();
    private Format format = new SimpleDateFormat("HH:mm:ss.SSS");
    private static final TableCellRenderer[] RENDERERS = new TableCellRenderer[]{new RightAlignRenderer(), new RightAlignRenderer(), null, null, null, null, null};

    public TableVisualizer() {
        this.model = new ObjectTableModel(COLUMNS, TableSample.class, new Functor[]{new Functor("getSampleNumberString"), new Functor("getStartTimeFormatted", new Object[]{this.format}), new Functor("getThreadName"), new Functor("getLabel"), new Functor("getElapsed"), new SampleSuccessFunctor("isSuccess"), new Functor("getBytes"), new Functor("getSentBytes"), new Functor("getLatency"), new Functor("getConnectTime")}, new Functor[]{null, null, null, null, null, null, null, null, null, null}, new Class[]{String.class, String.class, String.class, String.class, Long.class, ImageIcon.class, Long.class, Long.class, Long.class, Long.class});
        this.init();
    }

    public static boolean testFunctors() {
        TableVisualizer instance = new TableVisualizer();
        return instance.model.checkFunctors(null, ((Object)((Object)instance)).getClass());
    }

    public String getLabelResource() {
        return "view_results_in_table";
    }

    protected synchronized void updateTextFields(SampleResult res) {
        this.noSamplesField.setText(Long.toString(this.calc.getCount()));
        if (res.getSampleCount() > 0) {
            this.dataField.setText(Long.toString(res.getTime() / (long)res.getSampleCount()));
        } else {
            this.dataField.setText("0");
        }
        this.averageField.setText(Long.toString((long)this.calc.getMean()));
        this.deviationField.setText(Long.toString((long)this.calc.getStandardDeviation()));
    }

    public void add(final SampleResult res) {
        JMeterUtils.runSafe((boolean)false, (Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SampleResult[] subResults;
                if (TableVisualizer.this.childSamples.isSelected() && (subResults = res.getSubResults()).length > 0) {
                    for (SampleResult sr : subResults) {
                        TableVisualizer.this.add(sr);
                    }
                    return;
                }
                Calculator calculator = TableVisualizer.this.calc;
                synchronized (calculator) {
                    TableVisualizer.this.calc.addSample(res);
                    int count = TableVisualizer.this.calc.getCount();
                    TableSample newS = new TableSample((long)count, res.getSampleCount(), res.getStartTime(), res.getThreadName(), res.getSampleLabel(), res.getTime(), res.isSuccessful(), res.getBytesAsLong(), res.getSentBytes(), res.getLatency(), res.getConnectTime());
                    TableVisualizer.this.model.addRow((Object)newS);
                }
                TableVisualizer.this.updateTextFields(res);
                if (TableVisualizer.this.autoscroll.isSelected()) {
                    TableVisualizer.this.table.scrollRectToVisible(TableVisualizer.this.table.getCellRect(TableVisualizer.this.table.getRowCount() - 1, 0, true));
                }
            }
        });
    }

    public synchronized void clearData() {
        this.model.clearData();
        this.calc.clear();
        this.noSamplesField.setText("0");
        this.dataField.setText("0");
        this.averageField.setText("0");
        this.deviationField.setText("0");
        this.repaint();
    }

    public String toString() {
        return "Show the samples in a table";
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel();
        EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
        mainPanel.setBorder(margin);
        mainPanel.setLayout((LayoutManager)new VerticalLayout(5, 3));
        mainPanel.add(this.makeTitlePanel());
        this.table = new JTable((TableModel)this.model);
        JMeterUtils.applyHiDPI((JTable)this.table);
        this.table.getTableHeader().setDefaultRenderer((TableCellRenderer)new HeaderAsPropertyRenderer());
        RendererUtils.applyRenderers((JTable)this.table, (TableCellRenderer[])RENDERERS);
        this.tableScrollPanel = new JScrollPane(this.table);
        this.tableScrollPanel.setViewportBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.autoscroll = new JCheckBox(JMeterUtils.getResString((String)"view_results_autoscroll"));
        this.childSamples = new JCheckBox(JMeterUtils.getResString((String)"view_results_childsamples"));
        JPanel dataPanel = new JPanel();
        JLabel dataLabel = new JLabel(JMeterUtils.getResString((String)"graph_results_latest_sample"));
        dataLabel.setForeground(Color.black);
        this.dataField = new JTextField(5);
        this.dataField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.dataField.setEditable(false);
        this.dataField.setForeground(Color.black);
        this.dataField.setBackground(this.getBackground());
        dataPanel.add(dataLabel);
        dataPanel.add(this.dataField);
        JPanel averagePanel = new JPanel();
        JLabel averageLabel = new JLabel(JMeterUtils.getResString((String)"graph_results_average"));
        averageLabel.setForeground(Color.blue);
        this.averageField = new JTextField(5);
        this.averageField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.averageField.setEditable(false);
        this.averageField.setForeground(Color.blue);
        this.averageField.setBackground(this.getBackground());
        averagePanel.add(averageLabel);
        averagePanel.add(this.averageField);
        JPanel deviationPanel = new JPanel();
        JLabel deviationLabel = new JLabel(JMeterUtils.getResString((String)"graph_results_deviation"));
        deviationLabel.setForeground(Color.red);
        this.deviationField = new JTextField(5);
        this.deviationField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.deviationField.setEditable(false);
        this.deviationField.setForeground(Color.red);
        this.deviationField.setBackground(this.getBackground());
        deviationPanel.add(deviationLabel);
        deviationPanel.add(this.deviationField);
        JPanel noSamplesPanel = new JPanel();
        JLabel noSamplesLabel = new JLabel(JMeterUtils.getResString((String)"graph_results_no_samples"));
        this.noSamplesField = new JTextField(8);
        this.noSamplesField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.noSamplesField.setEditable(false);
        this.noSamplesField.setForeground(Color.black);
        this.noSamplesField.setBackground(this.getBackground());
        noSamplesPanel.add(noSamplesLabel);
        noSamplesPanel.add(this.noSamplesField);
        JPanel tableInfoPanel = new JPanel();
        tableInfoPanel.setLayout(new FlowLayout());
        tableInfoPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        tableInfoPanel.add(noSamplesPanel);
        tableInfoPanel.add(dataPanel);
        tableInfoPanel.add(averagePanel);
        tableInfoPanel.add(deviationPanel);
        JPanel tableControlsPanel = new JPanel(new BorderLayout());
        tableControlsPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        HorizontalPanel jp = new HorizontalPanel();
        jp.add(this.autoscroll);
        jp.add(this.childSamples);
        tableControlsPanel.add((Component)jp, "West");
        tableControlsPanel.add((Component)tableInfoPanel, "Center");
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BorderLayout());
        tablePanel.add((Component)this.tableScrollPanel, "Center");
        tablePanel.add((Component)tableControlsPanel, "South");
        this.add(mainPanel, "North");
        this.add(tablePanel, "Center");
    }

    public static class SampleSuccessFunctor
    extends Functor {
        public SampleSuccessFunctor(String methodName) {
            super(methodName);
        }

        public Object invoke(Object pInvokee) {
            Boolean success = (Boolean)super.invoke(pInvokee);
            if (success != null) {
                if (success.booleanValue()) {
                    return imageSuccess;
                }
                return imageFailure;
            }
            return null;
        }
    }
}

