/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.modifiers;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.engine.event.LoopIterationListener;
import org.apache.jmeter.processor.PreProcessor;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class UserParameters
extends AbstractTestElement
implements Serializable,
PreProcessor,
LoopIterationListener {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 233L;
    public static final String NAMES = "UserParameters.names";
    public static final String THREAD_VALUES = "UserParameters.thread_values";
    public static final String PER_ITERATION = "UserParameters.per_iteration";
    private transient Object lock = new Object();

    private Object readResolve() {
        this.lock = new Object();
        return this;
    }

    public CollectionProperty getNames() {
        return (CollectionProperty)this.getProperty(NAMES);
    }

    public CollectionProperty getThreadLists() {
        return (CollectionProperty)this.getProperty(THREAD_VALUES);
    }

    public void setNames(Collection<?> list) {
        this.setProperty((JMeterProperty)new CollectionProperty(NAMES, list));
    }

    public void setNames(CollectionProperty list) {
        this.setProperty((JMeterProperty)list);
    }

    public void setThreadLists(Collection<?> threadLists) {
        this.setProperty((JMeterProperty)new CollectionProperty(THREAD_VALUES, threadLists));
    }

    public void setThreadLists(CollectionProperty threadLists) {
        this.setProperty((JMeterProperty)threadLists);
    }

    private CollectionProperty getValues() {
        CollectionProperty threadValues = (CollectionProperty)this.getProperty(THREAD_VALUES);
        if (threadValues.size() > 0) {
            return (CollectionProperty)threadValues.get(this.getThreadContext().getThreadNum() % threadValues.size());
        }
        return new CollectionProperty("noname", new LinkedList());
    }

    public boolean isPerIteration() {
        return this.getPropertyAsBoolean(PER_ITERATION);
    }

    public void setPerIteration(boolean perIter) {
        this.setProperty((JMeterProperty)new BooleanProperty(PER_ITERATION, perIter));
    }

    public void process() {
        if (log.isDebugEnabled()) {
            log.debug(Thread.currentThread().getName() + " process " + this.isPerIteration());
        }
        if (!this.isPerIteration()) {
            this.setValues();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setValues() {
        Object object = this.lock;
        synchronized (object) {
            if (log.isDebugEnabled()) {
                log.debug(Thread.currentThread().getName() + " Running up named: " + this.getName());
            }
            PropertyIterator namesIter = this.getNames().iterator();
            PropertyIterator valueIter = this.getValues().iterator();
            JMeterVariables jmvars = this.getThreadContext().getVariables();
            while (namesIter.hasNext() && valueIter.hasNext()) {
                String name = namesIter.next().getStringValue();
                String value = valueIter.next().getStringValue();
                if (log.isDebugEnabled()) {
                    log.debug(Thread.currentThread().getName() + " saving variable: " + name + "=" + value);
                }
                jmvars.put(name, value);
            }
        }
    }

    public void iterationStart(LoopIterationEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(Thread.currentThread().getName() + " iteration start " + this.isPerIteration());
        }
        if (this.isPerIteration()) {
            this.setValues();
        }
    }

    public Object clone() {
        UserParameters up = (UserParameters)super.clone();
        up.lock = this.lock;
        return up;
    }

    protected void mergeIn(TestElement element) {
    }
}

