/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.bolt.config;

import org.apache.jmeter.config.ConfigElement;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.testbeans.TestBeanHelper;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TestElementMetadata(labelResource="displayName")
public class BoltConnectionElement
extends AbstractTestElement
implements ConfigElement,
TestStateListener,
TestBean {
    private static final Logger log = LoggerFactory.getLogger(BoltConnectionElement.class);
    private String boltUri;
    private String username;
    private String password;
    private Driver driver;
    public static final String BOLT_CONNECTION = "boltConnection";

    public void addConfigElement(ConfigElement config) {
    }

    public boolean expectsModification() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStarted() {
        this.setRunningVersion(true);
        TestBeanHelper.prepare((TestElement)this);
        JMeterVariables variables = this.getThreadContext().getVariables();
        if (variables.getObject(BOLT_CONNECTION) != null) {
            log.error("Bolt connection already exists");
        } else {
            BoltConnectionElement boltConnectionElement = this;
            synchronized (boltConnectionElement) {
                this.driver = GraphDatabase.driver((String)this.getBoltUri(), (AuthToken)AuthTokens.basic((String)this.getUsername(), (String)this.getPassword()));
                variables.putObject(BOLT_CONNECTION, (Object)this.driver);
            }
        }
    }

    public void testStarted(String host) {
        this.testStarted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEnded() {
        BoltConnectionElement boltConnectionElement = this;
        synchronized (boltConnectionElement) {
            if (this.driver != null) {
                this.driver.close();
                this.driver = null;
            }
        }
    }

    public void testEnded(String host) {
        this.testEnded();
    }

    public String getBoltUri() {
        return this.boltUri;
    }

    public void setBoltUri(String boltUri) {
        this.boltUri = boltUri;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public static Driver getDriver() {
        return (Driver)JMeterContextService.getContext().getVariables().getObject(BOLT_CONNECTION);
    }
}

