/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ovf.xml;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.util.Map;
import org.jclouds.ovf.Configuration;
import org.jclouds.ovf.DeploymentOptionSection;
import org.jclouds.ovf.xml.SectionHandler;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class DeploymentOptionSectionHandler
extends SectionHandler<DeploymentOptionSection, DeploymentOptionSection.Builder> {
    protected Configuration.Builder configBuilder = Configuration.builder();

    @Inject
    public DeploymentOptionSectionHandler(Provider<DeploymentOptionSection.Builder> builderProvider) {
        super(builderProvider);
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) {
        Map attributes = SaxUtils.cleanseAttributes((Attributes)attrs);
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"Configuration")) {
            this.configBuilder.id((String)attributes.get("id"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endElement(String uri, String localName, String qName) {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"Info")) {
            ((DeploymentOptionSection.Builder)this.builder).info(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Label")) {
            this.configBuilder.label(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Description")) {
            this.configBuilder.description(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Configuration")) {
            try {
                ((DeploymentOptionSection.Builder)this.builder).configuration(this.configBuilder.build());
            }
            finally {
                this.configBuilder = Configuration.builder();
            }
        }
        super.endElement(uri, localName, qName);
    }
}

