/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.util;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Invokable;
import java.net.URI;
import java.util.List;
import org.assertj.core.api.Fail;
import org.jclouds.ContextBuilder;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.util.BlobStoreUtils;
import org.jclouds.blobstore.util.ReadOnlyBlobStore;
import org.jclouds.reflect.Invocation;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class BlobStoreUtilsTest {
    public void testGetKeyForAzureS3AndRackspace() {
        GeneratedHttpRequest request = this.requestForEndpointAndArgs("https://jclouds.blob.core.windows.net/adriancole-blobstore0/five", (List<Object>)ImmutableList.of((Object)"adriancole-blobstore0", (Object)"five"));
        Assert.assertEquals((String)BlobStoreUtils.getNameFor((GeneratedHttpRequest)request), (String)"five");
    }

    public void testGetKeyForAtmos() {
        GeneratedHttpRequest request = this.requestForEndpointAndArgs("https://storage4.clouddrive.com/v1/MossoCloudFS_dc1f419c-5059-4c87-a389-3f2e33a77b22/adriancole-blobstore0/four", (List<Object>)ImmutableList.of((Object)"adriancole-blobstore0/four"));
        Assert.assertEquals((String)BlobStoreUtils.getNameFor((GeneratedHttpRequest)request), (String)"four");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadOnlyBlobStore() {
        BlobStoreContext context = (BlobStoreContext)ContextBuilder.newBuilder((String)"transient").build(BlobStoreContext.class);
        try {
            BlobStore rwBlobStore = context.getBlobStore();
            BlobStore roBlobStore = ReadOnlyBlobStore.newReadOnlyBlobStore((BlobStore)rwBlobStore);
            String containerName = "name";
            rwBlobStore.createContainerInLocation(null, containerName);
            Blob blob = rwBlobStore.blobBuilder("blob").payload(new byte[0]).build();
            rwBlobStore.putBlob(containerName, blob);
            try {
                roBlobStore.putBlob(containerName, blob);
                Fail.failBecauseExceptionWasNotThrown(UnsupportedOperationException.class);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        finally {
            context.close();
        }
    }

    GeneratedHttpRequest requestForEndpointAndArgs(String endpoint, List<Object> args) {
        try {
            Invocation invocation = Invocation.create((Invokable)Reflection2.method(String.class, (String)"toString", (Class[])new Class[0]), args);
            return ((GeneratedHttpRequest.Builder)((GeneratedHttpRequest.Builder)GeneratedHttpRequest.builder().method("POST")).endpoint(URI.create(endpoint))).invocation(invocation).build();
        }
        catch (SecurityException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

