/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.strategy.internal;

import org.jclouds.blobstore.strategy.internal.MultipartUploadSlicingAlgorithm;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public final class MpuPartitioningAlgorithmTest {
    private static final long MIN_PART_SIZE = 0x500000L;
    private static final long MAX_PART_SIZE = 0x140000000L;
    private static final int MAX_NUMBER_OF_PARTS = 10000;

    @Test
    public void testLowerLimitFromWhereMultipartBecomeActive() {
        MultipartUploadSlicingAlgorithm strategy = new MultipartUploadSlicingAlgorithm(0x500000L, 0x140000000L, 10000);
        long length = 0x500000L;
        long chunkSize = strategy.calculateChunkSize(length);
        Assert.assertEquals((long)chunkSize, (long)0x2000000L);
        Assert.assertEquals((int)strategy.getParts(), (int)0);
        Assert.assertEquals((long)strategy.getRemaining(), (long)length);
        Assert.assertEquals((long)(chunkSize * (long)strategy.getParts() + strategy.getRemaining()), (long)length);
        length = 0x2000000L;
        chunkSize = strategy.calculateChunkSize(length);
        Assert.assertEquals((long)chunkSize, (long)0x2000000L);
        Assert.assertEquals((int)strategy.getParts(), (int)0);
        Assert.assertEquals((long)strategy.getRemaining(), (long)length);
        Assert.assertEquals((long)(chunkSize * (long)strategy.getParts() + strategy.getRemaining()), (long)length);
        length = 0x2000001L;
        chunkSize = strategy.calculateChunkSize(length);
        Assert.assertEquals((long)chunkSize, (long)0x2000000L);
        Assert.assertEquals((int)strategy.getParts(), (int)1);
        Assert.assertEquals((long)strategy.getRemaining(), (long)1L);
        Assert.assertEquals((long)(chunkSize * (long)strategy.getParts() + strategy.getRemaining()), (long)length);
    }

    @Test
    public void testWhenChunkSizeHasToStartGrowing() {
        MultipartUploadSlicingAlgorithm strategy = new MultipartUploadSlicingAlgorithm(0x500000L, 0x140000000L, 10000);
        long length = 0xC8000000L;
        long chunkSize = strategy.calculateChunkSize(length);
        Assert.assertEquals((long)chunkSize, (long)0x2000000L);
        Assert.assertEquals((int)strategy.getParts(), (int)99);
        Assert.assertEquals((long)strategy.getRemaining(), (long)0x2000000L);
        Assert.assertEquals((long)(chunkSize * (long)strategy.getParts() + strategy.getRemaining()), (long)length);
        chunkSize = strategy.calculateChunkSize(++length);
        Assert.assertEquals((long)chunkSize, (long)0x4000000L);
        Assert.assertEquals((int)strategy.getParts(), (int)50);
        Assert.assertEquals((long)strategy.getRemaining(), (long)1L);
        Assert.assertEquals((long)(chunkSize * (long)strategy.getParts() + strategy.getRemaining()), (long)length);
    }

    @Test
    public void testWhenPartsHasToStartGrowingFromMagnitudeBase() {
        MultipartUploadSlicingAlgorithm strategy = new MultipartUploadSlicingAlgorithm(0x500000L, 0x140000000L, 10000);
        long length = 0x7D00000000L;
        long chunkSize = strategy.calculateChunkSize(length);
        Assert.assertEquals((long)chunkSize, (long)0x140000000L);
        Assert.assertEquals((int)strategy.getParts(), (int)99);
        Assert.assertEquals((long)strategy.getRemaining(), (long)0x140000000L);
        Assert.assertEquals((long)(chunkSize * (long)strategy.getParts() + strategy.getRemaining()), (long)length);
        chunkSize = strategy.calculateChunkSize(++length);
        Assert.assertEquals((long)chunkSize, (long)0x140000000L);
        Assert.assertEquals((int)strategy.getParts(), (int)100);
        Assert.assertEquals((long)strategy.getRemaining(), (long)1L);
        Assert.assertEquals((long)(chunkSize * (long)strategy.getParts() + strategy.getRemaining()), (long)length);
    }

    @Test
    public void testWhenPartsExceedsMaxNumberOfParts() {
        MultipartUploadSlicingAlgorithm strategy = new MultipartUploadSlicingAlgorithm(0x500000L, 0x140000000L, 10000);
        long length = 53687091200000L;
        long chunkSize = strategy.calculateChunkSize(length);
        Assert.assertEquals((long)chunkSize, (long)0x140000000L);
        Assert.assertEquals((int)strategy.getParts(), (int)9999);
        Assert.assertEquals((long)strategy.getRemaining(), (long)0x140000000L);
        Assert.assertEquals((long)(chunkSize * (long)strategy.getParts() + strategy.getRemaining()), (long)length);
        chunkSize = strategy.calculateChunkSize(++length);
        Assert.assertEquals((long)chunkSize, (long)0x140000000L);
        Assert.assertEquals((int)strategy.getParts(), (int)10000);
        Assert.assertEquals((long)strategy.getRemaining(), (long)1L);
        Assert.assertEquals((long)(chunkSize * (long)strategy.getParts() + strategy.getRemaining()), (long)length);
    }
}

