/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.strategy.internal;

import com.google.common.collect.Iterables;
import com.google.common.io.ByteSource;
import com.google.inject.Injector;
import java.io.Closeable;
import org.assertj.core.api.Assertions;
import org.jclouds.ContextBuilder;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.strategy.internal.ConcatenateContainerLists;
import org.jclouds.util.Closeables2;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(testName="PrefixTest", singleThreaded=true)
public class ListContainerTest {
    private BlobStore blobStore;
    private ConcatenateContainerLists concatter;

    @BeforeClass
    public void setupBlobStore() {
        Injector injector = ContextBuilder.newBuilder((String)"transient").buildInjector();
        this.blobStore = (BlobStore)injector.getInstance(BlobStore.class);
        this.concatter = (ConcatenateContainerLists)injector.getInstance(ConcatenateContainerLists.class);
    }

    @AfterClass
    public void closeBlobSore() {
        if (this.blobStore != null) {
            Closeables2.closeQuietly((Closeable)this.blobStore.getContext());
        }
    }

    public void testListBlobWithPrefixAndDelimiter() {
        String containerName = "test";
        String name = "asdf/";
        this.blobStore.createContainerInLocation(null, containerName);
        this.blobStore.putBlob(containerName, this.blobStore.blobBuilder(name).payload("").build());
        Iterable results = this.concatter.execute(containerName, ListContainerOptions.Builder.prefix((String)name).delimiter(name));
        Assertions.assertThat((Iterable)results).hasSize(1);
    }

    public void testListWithPrefix() {
        String containerName = "prefix";
        String prefix = "foo";
        this.blobStore.createContainerInLocation(null, containerName);
        this.blobStore.putBlob(containerName, this.blobStore.blobBuilder(prefix).payload("").build());
        this.blobStore.putBlob(containerName, this.blobStore.blobBuilder(prefix + "bar").payload("").build());
        this.blobStore.putBlob(containerName, this.blobStore.blobBuilder(prefix + "baz").payload("").build());
        this.blobStore.putBlob(containerName, this.blobStore.blobBuilder("bar").payload("").build());
        Iterable results = this.concatter.execute(containerName, ListContainerOptions.Builder.prefix((String)prefix).recursive());
        Assertions.assertThat((Iterable)results).hasSize(3);
        Assertions.assertThat((String)((StorageMetadata)Iterables.get((Iterable)results, (int)0)).getName()).isEqualTo((Object)prefix);
        Assertions.assertThat((Comparable)((StorageMetadata)Iterables.get((Iterable)results, (int)0)).getType()).isEqualTo((Object)StorageType.BLOB);
        Assertions.assertThat((String)((StorageMetadata)Iterables.get((Iterable)results, (int)1)).getName()).isEqualTo((Object)(prefix + "bar"));
        Assertions.assertThat((Comparable)((StorageMetadata)Iterables.get((Iterable)results, (int)1)).getType()).isEqualTo((Object)StorageType.BLOB);
        Assertions.assertThat((String)((StorageMetadata)Iterables.get((Iterable)results, (int)2)).getName()).isEqualTo((Object)(prefix + "baz"));
        Assertions.assertThat((Comparable)((StorageMetadata)Iterables.get((Iterable)results, (int)2)).getType()).isEqualTo((Object)StorageType.BLOB);
    }

    public void testListWithPrefixAndDelimiter() {
        String containerName = "prefixWithSeparator";
        String prefix = "foo";
        this.blobStore.createContainerInLocation(null, containerName);
        this.blobStore.putBlob(containerName, this.blobStore.blobBuilder(prefix + "-object").payload("").build());
        this.blobStore.putBlob(containerName, this.blobStore.blobBuilder(prefix + "bar-object").payload("").build());
        this.blobStore.putBlob(containerName, this.blobStore.blobBuilder(prefix + "baz-object").payload("").build());
        this.blobStore.putBlob(containerName, this.blobStore.blobBuilder("bar-object").payload("").build());
        Iterable results = this.concatter.execute(containerName, ListContainerOptions.Builder.prefix((String)prefix).delimiter("-"));
        Assertions.assertThat((int)Iterables.size((Iterable)results)).isEqualTo(3);
        Assertions.assertThat((Comparable)((StorageMetadata)Iterables.get((Iterable)results, (int)0)).getType()).isEqualTo((Object)StorageType.RELATIVE_PATH);
        Assertions.assertThat((String)((StorageMetadata)Iterables.get((Iterable)results, (int)0)).getName()).isEqualTo((Object)(prefix + "-"));
        Assertions.assertThat((String)((StorageMetadata)Iterables.get((Iterable)results, (int)1)).getName()).isEqualTo((Object)(prefix + "bar-"));
        Assertions.assertThat((Comparable)((StorageMetadata)Iterables.get((Iterable)results, (int)1)).getType()).isEqualTo((Object)StorageType.RELATIVE_PATH);
        Assertions.assertThat((String)((StorageMetadata)Iterables.get((Iterable)results, (int)2)).getName()).isEqualTo((Object)(prefix + "baz-"));
        Assertions.assertThat((Comparable)((StorageMetadata)Iterables.get((Iterable)results, (int)2)).getType()).isEqualTo((Object)StorageType.RELATIVE_PATH);
    }

    public void testListRecursivePrefix() {
        String containerName = "testListRecursive";
        String prefix = "foo";
        this.blobStore.createContainerInLocation(null, containerName);
        this.blobStore.putBlob(containerName, this.blobStore.blobBuilder(prefix + "/object").payload("").build());
        this.blobStore.putBlob(containerName, this.blobStore.blobBuilder(prefix + "bar/object").payload("").build());
        this.blobStore.putBlob(containerName, this.blobStore.blobBuilder(prefix + "baz/object").payload("").build());
        this.blobStore.putBlob(containerName, this.blobStore.blobBuilder("bar/object").payload("").build());
        Iterable results = this.concatter.execute(containerName, ListContainerOptions.Builder.prefix((String)prefix).recursive());
        Assertions.assertThat((Iterable)results).hasSize(3);
        Assertions.assertThat((Comparable)((StorageMetadata)Iterables.get((Iterable)results, (int)0)).getType()).isEqualTo((Object)StorageType.BLOB);
        Assertions.assertThat((String)((StorageMetadata)Iterables.get((Iterable)results, (int)0)).getName()).isEqualTo((Object)(prefix + "/object"));
        Assertions.assertThat((Comparable)((StorageMetadata)Iterables.get((Iterable)results, (int)1)).getType()).isEqualTo((Object)StorageType.BLOB);
        Assertions.assertThat((String)((StorageMetadata)Iterables.get((Iterable)results, (int)1)).getName()).isEqualTo((Object)(prefix + "bar/object"));
        Assertions.assertThat((Comparable)((StorageMetadata)Iterables.get((Iterable)results, (int)2)).getType()).isEqualTo((Object)StorageType.BLOB);
        Assertions.assertThat((String)((StorageMetadata)Iterables.get((Iterable)results, (int)2)).getName()).isEqualTo((Object)(prefix + "baz/object"));
    }

    public void testListRecursivePrefixDelimiter() {
        String containerName = "testListRecursivePrefixDelimiter";
        String prefix = "foo/";
        this.blobStore.createContainerInLocation(null, containerName);
        this.blobStore.putBlob(containerName, this.blobStore.blobBuilder(prefix + "object").payload("").build());
        this.blobStore.putBlob(containerName, this.blobStore.blobBuilder(prefix + "bar/object").payload("").build());
        this.blobStore.putBlob(containerName, this.blobStore.blobBuilder(prefix + "baz/object").payload("").build());
        this.blobStore.putBlob(containerName, this.blobStore.blobBuilder("bar/object").payload("").build());
        Iterable results = this.concatter.execute(containerName, ListContainerOptions.Builder.prefix((String)prefix));
        Assertions.assertThat((Iterable)results).hasSize(3);
        Assertions.assertThat((Comparable)((StorageMetadata)Iterables.get((Iterable)results, (int)0)).getType()).isEqualTo((Object)StorageType.RELATIVE_PATH);
        Assertions.assertThat((String)((StorageMetadata)Iterables.get((Iterable)results, (int)0)).getName()).isEqualTo((Object)(prefix + "bar/"));
        Assertions.assertThat((Comparable)((StorageMetadata)Iterables.get((Iterable)results, (int)1)).getType()).isEqualTo((Object)StorageType.RELATIVE_PATH);
        Assertions.assertThat((String)((StorageMetadata)Iterables.get((Iterable)results, (int)1)).getName()).isEqualTo((Object)(prefix + "baz/"));
        Assertions.assertThat((Comparable)((StorageMetadata)Iterables.get((Iterable)results, (int)2)).getType()).isEqualTo((Object)StorageType.BLOB);
        Assertions.assertThat((String)((StorageMetadata)Iterables.get((Iterable)results, (int)2)).getName()).isEqualTo((Object)(prefix + "object"));
    }

    public void testListDirectory() {
        String containerName = "testListDir";
        String directory = "dir";
        this.blobStore.createContainerInLocation(null, containerName);
        this.blobStore.createDirectory(containerName, directory);
        this.blobStore.putBlob(containerName, this.blobStore.blobBuilder(directory + "/foo").payload("").build());
        this.blobStore.putBlob(containerName, this.blobStore.blobBuilder(directory + "/bar").payload("").build());
        Iterable results = this.concatter.execute(containerName, (ListContainerOptions)ListContainerOptions.NONE);
        Assertions.assertThat((Iterable)results).hasSize(2);
        Assertions.assertThat((String)((StorageMetadata)Iterables.get((Iterable)results, (int)0)).getName()).isEqualTo((Object)directory);
        Assertions.assertThat((Comparable)((StorageMetadata)Iterables.get((Iterable)results, (int)0)).getType()).isEqualTo((Object)StorageType.FOLDER);
        Assertions.assertThat((String)((StorageMetadata)Iterables.get((Iterable)results, (int)1)).getName()).isEqualTo((Object)(directory + '/'));
        Assertions.assertThat((Comparable)((StorageMetadata)Iterables.get((Iterable)results, (int)1)).getType()).isEqualTo((Object)StorageType.RELATIVE_PATH);
    }

    public void testListMarkers() {
        String containerName = "testListMarkers";
        this.blobStore.createContainerInLocation(null, containerName);
        this.blobStore.putBlob(containerName, this.blobStore.blobBuilder("abc").payload("").build());
        this.blobStore.putBlob(containerName, this.blobStore.blobBuilder("foo/bar").payload("").build());
        this.blobStore.putBlob(containerName, this.blobStore.blobBuilder("foo/baz").payload("").build());
        this.blobStore.putBlob(containerName, this.blobStore.blobBuilder("qux").payload("").build());
        PageSet results = this.blobStore.list(containerName, ListContainerOptions.Builder.maxResults((int)1));
        Assertions.assertThat((String)results.getNextMarker()).isEqualTo((Object)"abc");
        results = this.blobStore.list(containerName, ListContainerOptions.Builder.maxResults((int)1).afterMarker(results.getNextMarker()));
        Assertions.assertThat((String)results.getNextMarker()).isEqualTo((Object)"foo/");
        results = this.blobStore.list(containerName, ListContainerOptions.Builder.maxResults((int)1).afterMarker(results.getNextMarker()));
        Assertions.assertThat((String)results.getNextMarker()).isEqualTo(null);
    }

    public void testListBlobEndsWithDelimiter() {
        String containerName = "testListBlobEndsWithDelimiter";
        this.blobStore.createContainerInLocation(null, containerName);
        this.blobStore.putBlob(containerName, this.blobStore.blobBuilder("foo/").payload(ByteSource.empty()).build());
        PageSet results = this.blobStore.list(containerName, ListContainerOptions.Builder.prefix((String)"foo/"));
        Assertions.assertThat((int)results.size()).isEqualTo(1);
        Assertions.assertThat((String)((StorageMetadata)Iterables.get((Iterable)results, (int)0)).getName()).isEqualTo((Object)"foo/");
        Assertions.assertThat((Comparable)((StorageMetadata)Iterables.get((Iterable)results, (int)0)).getType()).isNotEqualTo((Object)StorageType.RELATIVE_PATH);
    }

    public void testDirectoryListing() {
        String containerName = "testDirectoryListing";
        this.blobStore.createContainerInLocation(null, containerName);
        this.blobStore.createDirectory(containerName, "dir");
        this.blobStore.createDirectory(containerName, "dir/dir");
        PageSet results = this.blobStore.list(containerName);
        Assertions.assertThat((int)results.size()).isEqualTo(2);
        Assertions.assertThat((String)((StorageMetadata)Iterables.get((Iterable)results, (int)0)).getName()).isEqualTo((Object)"dir");
        Assertions.assertThat((String)((StorageMetadata)Iterables.get((Iterable)results, (int)1)).getName()).isEqualTo((Object)"dir/");
        results = this.blobStore.list(containerName, ListContainerOptions.Builder.inDirectory((String)"dir"));
        Assertions.assertThat((int)results.size()).isEqualTo(1);
        Assertions.assertThat((String)((StorageMetadata)Iterables.get((Iterable)results, (int)0)).getName()).isEqualTo((Object)"dir/dir");
        Assertions.assertThat((Comparable)((StorageMetadata)Iterables.get((Iterable)results, (int)0)).getType()).isEqualTo((Object)StorageType.FOLDER);
        this.blobStore.putBlob(containerName, this.blobStore.blobBuilder("dir/dir/blob").payload("").build());
        results = this.blobStore.list(containerName, ListContainerOptions.Builder.inDirectory((String)"dir"));
        Assertions.assertThat((int)results.size()).isEqualTo(2);
        Assertions.assertThat((String)((StorageMetadata)Iterables.get((Iterable)results, (int)0)).getName()).isEqualTo((Object)"dir/dir");
        Assertions.assertThat((Comparable)((StorageMetadata)Iterables.get((Iterable)results, (int)0)).getType()).isEqualTo((Object)StorageType.FOLDER);
        Assertions.assertThat((String)((StorageMetadata)Iterables.get((Iterable)results, (int)1)).getName()).isEqualTo((Object)"dir/dir/");
        Assertions.assertThat((Comparable)((StorageMetadata)Iterables.get((Iterable)results, (int)1)).getType()).isEqualTo((Object)StorageType.RELATIVE_PATH);
    }
}

